/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.List;
import org.apache.flink.types.PojoTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PojoTestUtilsTest {
    PojoTestUtilsTest() {
    }

    @Test
    void testNonPojoRejected() {
        Assertions.assertThatThrownBy(() -> PojoTestUtils.assertSerializedAsPojo(NoPojo.class)).isInstanceOf(AssertionError.class);
    }

    @Test
    void testPojoAccepted() {
        PojoTestUtils.assertSerializedAsPojo(Pojo.class);
    }

    @Test
    void testPojoAcceptedIfKryoRequired() {
        PojoTestUtils.assertSerializedAsPojo(PojoRequiringKryo.class);
    }

    @Test
    void testWithoutKryoPojoAccepted() {
        PojoTestUtils.assertSerializedAsPojoWithoutKryo(Pojo.class);
    }

    @Test
    void testWithoutKryoPojoRejected() {
        Assertions.assertThatThrownBy(() -> PojoTestUtils.assertSerializedAsPojoWithoutKryo(PojoRequiringKryo.class)).isInstanceOf(AssertionError.class);
    }

    public static class PojoRequiringKryo {
        public List<Integer> x;
    }

    public static class Pojo {
        public int x;
    }

    private static class NoPojo {
        private NoPojo() {
        }
    }
}

