/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.benchmark;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.state.benchmark.StateBackendBenchmarkUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StateBackendBenchmarkUtilsTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final ValueStateDescriptor<Long> valueStateDescriptor = new ValueStateDescriptor("valueState", Long.class);
    private final ListStateDescriptor<Long> listStateDescriptor = new ListStateDescriptor("listState", Long.class);
    private final MapStateDescriptor<Long, Double> mapStateDescriptor = new MapStateDescriptor("mapState", Long.class, Double.class);
    @Parameterized.Parameter
    public StateBackendBenchmarkUtils.StateBackendType backendType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> data() {
        return Arrays.asList(StateBackendBenchmarkUtils.StateBackendType.values());
    }

    @Test
    public void testCreateKeyedStateBackend() throws IOException {
        KeyedStateBackend<Long> backend = StateBackendBenchmarkUtils.createKeyedStateBackend(this.backendType);
        StateBackendBenchmarkUtils.cleanUp(backend);
    }

    @Test
    public void testGetValueState() throws Exception {
        KeyedStateBackend<Long> backend = StateBackendBenchmarkUtils.createKeyedStateBackend(this.backendType);
        StateBackendBenchmarkUtils.getValueState(backend, this.valueStateDescriptor);
        StateBackendBenchmarkUtils.cleanUp(backend);
    }

    @Test
    public void testGetListState() throws Exception {
        KeyedStateBackend<Long> backend = StateBackendBenchmarkUtils.createKeyedStateBackend(this.backendType);
        StateBackendBenchmarkUtils.getListState(backend, this.listStateDescriptor);
        StateBackendBenchmarkUtils.cleanUp(backend);
    }

    @Test
    public void testGetMapState() throws Exception {
        KeyedStateBackend<Long> backend = StateBackendBenchmarkUtils.createKeyedStateBackend(this.backendType);
        StateBackendBenchmarkUtils.getMapState(backend, this.mapStateDescriptor);
        StateBackendBenchmarkUtils.cleanUp(backend);
    }

    @Test
    public void testApplyToAllKeys() throws Exception {
        long i;
        Assume.assumeThat((Object)((Object)this.backendType), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)((Object)StateBackendBenchmarkUtils.StateBackendType.BATCH_EXECUTION))));
        KeyedStateBackend<Long> backend = StateBackendBenchmarkUtils.createKeyedStateBackend(this.backendType);
        ListState<Long> listState = StateBackendBenchmarkUtils.getListState(backend, this.listStateDescriptor);
        for (i = 0L; i < 10L; ++i) {
            backend.setCurrentKey((Object)i);
            listState.add((Object)i);
        }
        StateBackendBenchmarkUtils.applyToAllKeys(backend, this.listStateDescriptor, (k, state) -> {
            backend.setCurrentKey(k);
            state.clear();
        });
        for (i = 0L; i < 10L; ++i) {
            backend.setCurrentKey((Object)i);
            Assert.assertNull((Object)listState.get());
        }
        StateBackendBenchmarkUtils.cleanUp(backend);
    }

    @Test
    public void testCompactState() throws Exception {
        KeyedStateBackend<Long> backend = StateBackendBenchmarkUtils.createKeyedStateBackend(this.backendType);
        ListState<Long> listState = StateBackendBenchmarkUtils.getListState(backend, this.listStateDescriptor);
        for (long i = 0L; i < 10L; ++i) {
            backend.setCurrentKey((Object)i);
            listState.add((Object)i);
        }
        if (backend instanceof RocksDBKeyedStateBackend) {
            RocksDBKeyedStateBackend rocksDBKeyedStateBackend = (RocksDBKeyedStateBackend)backend;
            StateBackendBenchmarkUtils.compactState(rocksDBKeyedStateBackend, this.listStateDescriptor);
        }
        StateBackendBenchmarkUtils.cleanUp(backend);
    }
}

