/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.junit5;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class MiniClusterExtensionDefaultParallelismITCase {
    private static final int TARGET_PARALLELISM = 1;
    @RegisterExtension
    static final MiniClusterExtension FLINK = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setConfiguration(new Configuration().set(CoreOptions.DEFAULT_PARALLELISM, (Object)1)).setNumberSlotsPerTaskManager(2).setNumberTaskManagers(1).build());

    MiniClusterExtensionDefaultParallelismITCase() {
    }

    @Test
    void testDefaultParallelismSettingHonored() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        int actualParallelism = (Integer)env.fromElements((Object[])new Integer[]{1}).map((MapFunction)new RichMapFunction<Integer, Integer>(){

            public Integer map(Integer value) {
                return this.getRuntimeContext().getNumberOfParallelSubtasks();
            }
        }).executeAndCollect(1).get(0);
        Assertions.assertThat((int)actualParallelism).isEqualTo(1);
    }
}

