/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.testutils;

import java.util.function.Function;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Metric;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;

public enum MetricMatchers {


    public static <T extends Metric, V> Matcher<T> isGauge(Matcher<V> valueMatcher) {
        return new MetricMatcher(Gauge.class, Gauge::getValue, valueMatcher);
    }

    public static <T extends Metric> Matcher<T> isCounter(Matcher<Long> valueMatcher) {
        return new MetricMatcher(Counter.class, Counter::getCount, valueMatcher);
    }

    private static class MetricMatcher<M extends Metric, V, T extends Metric>
    extends DiagnosingMatcher<T> {
        private final Matcher<?> typeMatcher;
        private final Function<M, V> valueExtractor;
        private final Matcher<V> valueMatcher;
        private final Class<M> expectedClass;

        MetricMatcher(Class<M> expectedClass, Function<M, V> valueExtractor, Matcher<V> valueMatcher) {
            this.expectedClass = expectedClass;
            this.typeMatcher = new IsInstanceOf(expectedClass);
            this.valueExtractor = valueExtractor;
            this.valueMatcher = valueMatcher;
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            if (!this.typeMatcher.matches(item)) {
                this.typeMatcher.describeMismatch(item, mismatchDescription);
                return false;
            }
            V value = this.valueExtractor.apply(this.expectedClass.cast(item));
            if (!this.valueMatcher.matches(value)) {
                mismatchDescription.appendText(this.expectedClass.getSimpleName()).appendText(" with ");
                this.valueMatcher.describeMismatch(value, mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.expectedClass.getSimpleName()).appendText(" with ").appendDescriptionOf(this.valueMatcher);
        }
    }
}

