/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

public abstract class CheckedThread
extends Thread {
    private volatile Throwable error;

    public CheckedThread() {
    }

    public CheckedThread(String name) {
        super(name);
    }

    public abstract void go() throws Exception;

    @Override
    public final void run() {
        try {
            this.go();
        }
        catch (Throwable t) {
            this.error = t;
        }
    }

    public void sync() throws Exception {
        super.join();
        if (this.error != null) {
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            if (this.error instanceof Exception) {
                throw (Exception)this.error;
            }
            throw new Exception(this.error.getMessage(), this.error);
        }
    }
}

