/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit.extensions.retry.strategy;

import org.apache.flink.testutils.junit.extensions.retry.strategy.AbstractRetryStrategy;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryOnExceptionStrategy
extends AbstractRetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RetryOnExceptionStrategy.class);
    private final Class<? extends Throwable> repeatableException;

    public RetryOnExceptionStrategy(int retryTimes, Class<? extends Throwable> repeatableException) {
        super(retryTimes, true);
        this.repeatableException = repeatableException;
    }

    @Override
    public void handleException(String testName, int attemptIndex, Throwable throwable) throws Throwable {
        if (this.repeatableException.isAssignableFrom(throwable.getClass())) {
            String retryMsg = String.format("Retry test %s[%d/%d] failed with repeatable exception, continue retrying.", testName, attemptIndex, this.totalTimes);
            LOG.warn(retryMsg, throwable);
            throw new TestAbortedException(retryMsg);
        }
        this.stopFollowingAttempts();
        LOG.error(String.format("Retry test %s[%d/%d] failed with unrepeatable exception, stop retrying.", testName, attemptIndex, this.totalTimes), throwable);
        throw throwable;
    }
}

