/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class CommonTestUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T createCopySerializable(T original) throws IOException {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(original);
        oos.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Serializable copy;
            Serializable serializable = copy = (Serializable)ois.readObject();
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static String createTempFile(String contents) throws IOException {
        File f = File.createTempFile("flink_test_", ".tmp");
        f.deleteOnExit();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(f));){
            out.write(contents);
        }
        return f.toURI().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void blockForeverNonInterruptibly() {
        Object lock = new Object();
        while (true) {
            try {
                while (true) {
                    Object object = lock;
                    synchronized (object) {
                        lock.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void setEnv(Map<String, String> newenv) {
        CommonTestUtils.setEnv(newenv, true);
    }

    public static void setEnv(Map<String, String> newenv, boolean clearExisting) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> clazz = env.getClass();
            Field field = clazz.getDeclaredField("m");
            field.setAccessible(true);
            Map map = (Map)field.get(env);
            if (clearExisting) {
                map.clear();
            }
            map.putAll(newenv);
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            try {
                Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
                theCaseInsensitiveEnvironmentField.setAccessible(true);
                Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
                if (clearExisting) {
                    cienv.clear();
                }
                cienv.putAll(newenv);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public static boolean containsCause(Throwable throwable, Class<? extends Throwable> cause) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            if (!cause.isAssignableFrom(current.getClass())) continue;
            return true;
        }
        return false;
    }

    public static void assertThrows(String msg, Class<? extends Exception> expected, Callable<?> code) {
        try {
            Object result = code.call();
            Assert.fail((String)("Previous method call should have failed but it returned: " + result));
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(expected));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)msg));
        }
    }

    public static void waitUtil(Supplier<Boolean> condition, Duration timeout, String errorMsg) throws TimeoutException, InterruptedException {
        long timeoutMs = timeout.toMillis();
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("The timeout must be positive.");
        }
        long startingTime = System.currentTimeMillis();
        boolean conditionResult = condition.get();
        while (!conditionResult && System.currentTimeMillis() - startingTime < timeoutMs) {
            conditionResult = condition.get();
            Thread.sleep(1L);
        }
        if (!conditionResult) {
            throw new TimeoutException(errorMsg);
        }
    }
}

