/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class FlinkMatchers {
    public static <T, E extends Throwable> FutureFailedMatcher<T> futureFailedWith(Class<E> exceptionType) {
        Objects.requireNonNull(exceptionType, "exceptionType should not be null");
        return new FutureFailedMatcher(exceptionType);
    }

    public static <T, E extends Throwable> FutureWillFailMatcher<T> futureWillCompleteExceptionally(Class<E> exceptionType, Duration timeout) {
        Objects.requireNonNull(exceptionType, "exceptionType should not be null");
        Objects.requireNonNull(timeout, "timeout should not be null");
        return new FutureWillFailMatcher(exceptionType, timeout);
    }

    public static <T> FutureWillFailMatcher<T> futureWillCompleteExceptionally(Function<Throwable, Boolean> exceptionCheck, Duration timeout, String checkDescription) {
        Objects.requireNonNull(exceptionCheck, "exceptionType should not be null");
        Objects.requireNonNull(timeout, "timeout should not be null");
        return new FutureWillFailMatcher(exceptionCheck, timeout, checkDescription);
    }

    public static <T> FutureWillFailMatcher<T> futureWillCompleteExceptionally(Duration timeout) {
        return FlinkMatchers.futureWillCompleteExceptionally(Throwable.class, timeout);
    }

    public static Matcher<Throwable> containsCause(Throwable failureCause) {
        return new ContainsCauseMatcher(failureCause);
    }

    public static Matcher<Throwable> containsMessage(String errorMessage) {
        return new ContainsMessageMatcher(errorMessage);
    }

    public static Matcher<CompletableFuture<?>> willNotComplete(Duration timeout) {
        return new WillNotCompleteMatcher(timeout);
    }

    private FlinkMatchers() {
    }

    private static final class WillNotCompleteMatcher
    extends TypeSafeDiagnosingMatcher<CompletableFuture<?>> {
        private final Duration timeout;

        private WillNotCompleteMatcher(Duration timeout) {
            this.timeout = timeout;
        }

        protected boolean matchesSafely(CompletableFuture<?> item, Description mismatchDescription) {
            try {
                Object value = item.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                mismatchDescription.appendText("The given future completed with ").appendValue(value);
            }
            catch (TimeoutException timeoutException) {
                return true;
            }
            catch (InterruptedException e) {
                mismatchDescription.appendText("The waiting thread was interrupted.");
            }
            catch (ExecutionException e) {
                mismatchDescription.appendText("The given future was completed exceptionally: ").appendValue((Object)e);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("The given future should not complete within ").appendValue((Object)this.timeout.toMillis()).appendText(" ms.");
        }
    }

    private static final class ContainsMessageMatcher
    extends TypeSafeDiagnosingMatcher<Throwable> {
        private final String errorMessage;

        private ContainsMessageMatcher(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        protected boolean matchesSafely(Throwable throwable, Description description) {
            Optional<Throwable> optionalCause = ContainsMessageMatcher.findThrowableWithMessage(throwable, this.errorMessage);
            if (!optionalCause.isPresent()) {
                description.appendText("The throwable ").appendValue((Object)throwable).appendText(" does not contain the expected error message ").appendValue((Object)this.errorMessage);
            }
            return optionalCause.isPresent();
        }

        public void describeTo(Description description) {
            description.appendText("Expected error message is ").appendValue((Object)this.errorMessage);
        }

        private static Optional<Throwable> findThrowableWithMessage(Throwable throwable, String searchMessage) {
            if (throwable == null || searchMessage == null) {
                return Optional.empty();
            }
            for (Throwable t = throwable; t != null; t = t.getCause()) {
                if (t.getMessage() == null || !t.getMessage().contains(searchMessage)) continue;
                return Optional.of(t);
            }
            return Optional.empty();
        }
    }

    private static final class ContainsCauseMatcher
    extends TypeSafeDiagnosingMatcher<Throwable> {
        private final Throwable failureCause;

        private ContainsCauseMatcher(Throwable failureCause) {
            this.failureCause = failureCause;
        }

        protected boolean matchesSafely(Throwable throwable, Description description) {
            Optional<Throwable> optionalCause = ContainsCauseMatcher.findThrowable(throwable, cause -> cause.getClass() == this.failureCause.getClass() && cause.getMessage().equals(this.failureCause.getMessage()));
            if (!optionalCause.isPresent()) {
                description.appendText("The throwable ").appendValue((Object)throwable).appendText(" does not contain the expected failure cause ").appendValue((Object)this.failureCause);
            }
            return optionalCause.isPresent();
        }

        public void describeTo(Description description) {
            description.appendText("Expected failure cause is ").appendValue((Object)this.failureCause);
        }

        private static Optional<Throwable> findThrowable(Throwable throwable, Predicate<Throwable> predicate) {
            if (throwable == null || predicate == null) {
                return Optional.empty();
            }
            for (Throwable t = throwable; t != null; t = t.getCause()) {
                if (!predicate.test(t)) continue;
                return Optional.of(t);
            }
            return Optional.empty();
        }
    }

    private static final class FutureWillFailMatcher<T>
    extends TypeSafeDiagnosingMatcher<CompletableFuture<T>> {
        private final Function<Throwable, Boolean> exceptionValidator;
        private final Duration timeout;
        private final String validationDescription;

        FutureWillFailMatcher(Class<? extends Throwable> expectedException, Duration timeout) {
            super(CompletableFuture.class);
            this.exceptionValidator = e -> expectedException.isAssignableFrom(e.getClass());
            this.timeout = timeout;
            this.validationDescription = expectedException.getName();
        }

        FutureWillFailMatcher(Function<Throwable, Boolean> exceptionValidator, Duration timeout, String validationDescription) {
            super(CompletableFuture.class);
            this.exceptionValidator = exceptionValidator;
            this.timeout = timeout;
            this.validationDescription = validationDescription;
        }

        protected boolean matchesSafely(CompletableFuture<T> future, Description mismatchDescription) {
            try {
                T result = future.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                mismatchDescription.appendText("Future did not complete exceptionally, but instead regularly with: " + result);
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new Error("interrupted test");
            }
            catch (TimeoutException e) {
                mismatchDescription.appendText("Future did not complete withing " + this.timeout.toMillis() + " milliseconds.");
                return false;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && this.exceptionValidator.apply(cause).booleanValue()) {
                    return true;
                }
                String otherDescription = "(null)";
                if (cause != null) {
                    StringWriter stm = new StringWriter();
                    try (PrintWriter wrt = new PrintWriter(stm);){
                        cause.printStackTrace(wrt);
                    }
                    otherDescription = stm.toString();
                }
                mismatchDescription.appendText("Future completed with different exception: " + otherDescription);
                return false;
            }
        }

        public void describeTo(Description description) {
            description.appendText("A CompletableFuture that will have failed within " + this.timeout.toMillis() + " milliseconds with: " + this.validationDescription);
        }
    }

    private static final class FutureFailedMatcher<T>
    extends TypeSafeDiagnosingMatcher<CompletableFuture<T>> {
        private final Class<? extends Throwable> expectedException;

        FutureFailedMatcher(Class<? extends Throwable> expectedException) {
            super(CompletableFuture.class);
            this.expectedException = expectedException;
        }

        protected boolean matchesSafely(CompletableFuture<T> future, Description mismatchDescription) {
            if (!future.isDone()) {
                mismatchDescription.appendText("Future is not completed.");
                return false;
            }
            if (!future.isCompletedExceptionally()) {
                Object result = future.getNow(null);
                assert (result != null);
                mismatchDescription.appendText("Future did not complete exceptionally, but instead regularly with: " + result);
                return false;
            }
            try {
                future.getNow(null);
                throw new Error();
            }
            catch (CompletionException e) {
                if (e.getCause() != null && this.expectedException.isAssignableFrom(e.getCause().getClass())) {
                    return true;
                }
                mismatchDescription.appendText("Future completed with different exception: " + e.getCause());
                return false;
            }
        }

        public void describeTo(Description description) {
            description.appendText("A CompletableFuture that failed with: " + this.expectedException.getName());
        }
    }
}

