/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;
import org.apache.flink.util.Preconditions;

public class ValueCountMergeFunction
implements MergeFunction {
    private static final long serialVersionUID = 1L;
    private long total;

    @Override
    public void reset() {
        this.total = 0L;
    }

    @Override
    public void add(RowData value) {
        this.total += this.count(value);
    }

    @Override
    @Nullable
    public RowData getValue() {
        return this.total == 0L ? null : GenericRowData.of((Object[])new Object[]{this.total});
    }

    @Override
    public MergeFunction copy() {
        return new ValueCountMergeFunction();
    }

    private long count(RowData value) {
        Preconditions.checkArgument((!value.isNullAt(0) ? 1 : 0) != 0, (Object)"Value count should not be null.");
        return value.getLong(0);
    }
}

