/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowTimeRangeBoundedPrecedingFunction<K>
extends KeyedProcessFunction<K, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RowTimeRangeBoundedPrecedingFunction.class);
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private transient JoinedRowData output;
    private transient ValueState<Long> lastTriggeringTsState;
    private transient ValueState<RowData> accState;
    private transient ValueState<Long> cleanupTsState;
    private transient MapState<Long, List<RowData>> inputState;
    private transient AggsHandleFunction function;
    private static final String LATE_ELEMENTS_DROPPED_METRIC_NAME = "numLateRecordsDropped";
    private transient Counter numLateRecordsDropped;

    @VisibleForTesting
    protected Counter getCounter() {
        return this.numLateRecordsDropped;
    }

    public RowTimeRangeBoundedPrecedingFunction(GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, long precedingOffset, int rowTimeIdx) {
        Preconditions.checkNotNull((Object)precedingOffset);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
    }

    public void open(OpenContext openContext) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Types.LONG);
        this.lastTriggeringTsState = this.getRuntimeContext().getState(lastTriggeringTsDescriptor);
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor accStateDesc = new ValueStateDescriptor("accState", accTypeInfo);
        this.accState = this.getRuntimeContext().getState(accStateDesc);
        InternalTypeInfo<RowData> inputType = InternalTypeInfo.ofFields(this.inputFieldTypes);
        ListTypeInfo rowListTypeInfo = new ListTypeInfo(inputType);
        MapStateDescriptor inputStateDesc = new MapStateDescriptor("inputState", Types.LONG, (TypeInformation)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(inputStateDesc);
        ValueStateDescriptor cleanupTsStateDescriptor = new ValueStateDescriptor("cleanupTsState", Types.LONG);
        this.cleanupTsState = this.getRuntimeContext().getState(cleanupTsStateDescriptor);
        this.numLateRecordsDropped = this.getRuntimeContext().getMetricGroup().counter(LATE_ELEMENTS_DROPPED_METRIC_NAME);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        long triggeringTs = input.getLong(this.rowTimeIdx);
        Long lastTriggeringTs = (Long)this.lastTriggeringTsState.value();
        if (lastTriggeringTs == null) {
            lastTriggeringTs = 0L;
        }
        if (triggeringTs > lastTriggeringTs) {
            ArrayList<RowData> data = (ArrayList<RowData>)this.inputState.get((Object)triggeringTs);
            if (null != data) {
                data.add(input);
                this.inputState.put((Object)triggeringTs, data);
            } else {
                data = new ArrayList<RowData>();
                data.add(input);
                this.inputState.put((Object)triggeringTs, data);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
            this.registerCleanupTimer(ctx, triggeringTs);
        } else {
            this.numLateRecordsDropped.inc();
        }
    }

    private void registerCleanupTimer(KeyedProcessFunction.Context ctx, long timestamp) throws Exception {
        long minCleanupTimestamp = timestamp + this.precedingOffset + 1L;
        long maxCleanupTimestamp = timestamp + (long)((double)this.precedingOffset * 1.5) + 1L;
        Long curCleanupTimestamp = (Long)this.cleanupTsState.value();
        if (curCleanupTimestamp == null || curCleanupTimestamp < minCleanupTimestamp) {
            ctx.timerService().registerEventTimeTimer(maxCleanupTimestamp);
            this.cleanupTsState.update((Object)maxCleanupTimestamp);
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        Long cleanupTimestamp = (Long)this.cleanupTsState.value();
        if (cleanupTimestamp != null && cleanupTimestamp <= timestamp) {
            this.inputState.clear();
            this.accState.clear();
            this.lastTriggeringTsState.clear();
            this.cleanupTsState.clear();
            this.function.cleanup();
            return;
        }
        List inputs = (List)this.inputState.get((Object)timestamp);
        if (null != inputs) {
            int dataListIndex = 0;
            RowData accumulators = (RowData)this.accState.value();
            if (null == accumulators) {
                accumulators = this.function.createAccumulators();
            }
            this.function.setAccumulators(accumulators);
            ArrayList<Long> retractTsList = new ArrayList<Long>();
            for (Map.Entry data : this.inputState.entries()) {
                Long dataTs = (Long)data.getKey();
                Long offset = timestamp - dataTs;
                if (offset <= this.precedingOffset) continue;
                List retractDataList = (List)data.getValue();
                if (retractDataList != null) {
                    for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                        RowData retractRow = (RowData)retractDataList.get(dataListIndex);
                        this.function.retract(retractRow);
                    }
                    retractTsList.add(dataTs);
                    continue;
                }
                LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                RowData curRow = (RowData)inputs.get(dataListIndex);
                this.function.accumulate(curRow);
            }
            RowData aggValue = this.function.getValue();
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                RowData curRow = (RowData)inputs.get(dataListIndex);
                this.output.replace(curRow, aggValue);
                out.collect((Object)this.output);
            }
            for (dataListIndex = 0; dataListIndex < retractTsList.size(); ++dataListIndex) {
                this.inputState.remove((Object)((Long)retractTsList.get(dataListIndex)));
            }
            accumulators = this.function.getAccumulators();
            this.accState.update((Object)accumulators);
        }
        this.lastTriggeringTsState.update((Object)timestamp);
    }

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

