/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.table.runtime.io.CompressedHeaderlessChannelReaderInputView;
import org.apache.flink.table.runtime.io.CompressedHeaderlessChannelWriterOutputView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CompressedHeaderlessChannelTest {
    private static final int BUFFER_SIZE = 256;
    private IOManager ioManager = new IOManagerAsync();

    static Collection<Arguments> compressionFactory() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{NettyShuffleEnvironmentOptions.CompressionCodec.LZ4, BlockCompressionFactory.createBlockCompressionFactory((NettyShuffleEnvironmentOptions.CompressionCodec)NettyShuffleEnvironmentOptions.CompressionCodec.LZ4)}), Arguments.of((Object[])new Object[]{NettyShuffleEnvironmentOptions.CompressionCodec.LZO, BlockCompressionFactory.createBlockCompressionFactory((NettyShuffleEnvironmentOptions.CompressionCodec)NettyShuffleEnvironmentOptions.CompressionCodec.LZO)}), Arguments.of((Object[])new Object[]{NettyShuffleEnvironmentOptions.CompressionCodec.ZSTD, BlockCompressionFactory.createBlockCompressionFactory((NettyShuffleEnvironmentOptions.CompressionCodec)NettyShuffleEnvironmentOptions.CompressionCodec.ZSTD)}));
    }

    CompressedHeaderlessChannelTest() {
    }

    @AfterEach
    void afterTest() throws Exception {
        this.ioManager.close();
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"compressionFactory"})
    void testCompressedView(NettyShuffleEnvironmentOptions.CompressionCodec codec, BlockCompressionFactory compressionFactory) throws IOException {
        for (int testTime = 0; testTime < 10; ++testTime) {
            int testRounds = new Random().nextInt(20000);
            FileIOChannel.ID channel = this.ioManager.createChannel();
            BufferFileWriter writer = this.ioManager.createBufferFileWriter(channel);
            CompressedHeaderlessChannelWriterOutputView outputView = new CompressedHeaderlessChannelWriterOutputView(writer, compressionFactory, 256);
            for (int i = 0; i < testRounds; ++i) {
                outputView.writeInt(i);
            }
            outputView.close();
            int blockCount = outputView.getBlockCount();
            CompressedHeaderlessChannelReaderInputView inputView = new CompressedHeaderlessChannelReaderInputView(channel, this.ioManager, compressionFactory, 256, blockCount);
            for (int i = 0; i < testRounds; ++i) {
                Assertions.assertThat((int)inputView.readInt()).isEqualTo(i);
            }
            inputView.close();
        }
    }
}

