/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryRowDataUtil;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.util.DataFormatTestUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BinarySegmentUtilsTest {
    BinarySegmentUtilsTest() {
    }

    @Test
    void testCopy() {
        MemorySegment[] segments = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[]{0, 2, 5}), MemorySegmentFactory.wrap((byte[])new byte[]{6, 12, 15})};
        byte[] bytes = BinarySegmentUtils.copyToBytes((MemorySegment[])segments, (int)4, (int)2);
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)new byte[]{12, 15});
    }

    @Test
    void testEquals() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[]{0, 2, 5}), MemorySegmentFactory.wrap((byte[])new byte[]{6, 12, 15}), MemorySegmentFactory.wrap((byte[])new byte[]{1, 1, 1})};
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[]{6, 0, 2, 5}), MemorySegmentFactory.wrap((byte[])new byte[]{6, 12, 15, 18})};
        Assertions.assertThat((boolean)BinarySegmentUtils.equalsMultiSegments((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)0, (int)0)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)1, (int)3)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)1, (int)6)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)1, (int)7)).isFalse();
    }

    @Test
    void testBoundaryByteArrayEquals() {
        byte[] bytes1 = new byte[5];
        bytes1[3] = 81;
        byte[] bytes2 = new byte[100];
        bytes2[3] = 81;
        bytes2[4] = 81;
        Assertions.assertThat((boolean)BinaryRowDataUtil.byteArrayEquals((byte[])bytes1, (byte[])bytes2, (int)4)).isTrue();
        Assertions.assertThat((boolean)BinaryRowDataUtil.byteArrayEquals((byte[])bytes1, (byte[])bytes2, (int)5)).isFalse();
        Assertions.assertThat((boolean)BinaryRowDataUtil.byteArrayEquals((byte[])bytes1, (byte[])bytes2, (int)0)).isTrue();
    }

    @Test
    void testBoundaryEquals() {
        BinaryRowData row24 = DataFormatTestUtil.get24BytesBinaryRow();
        BinaryRowData row160 = DataFormatTestUtil.get160BytesBinaryRow();
        BinaryRowData varRow160 = DataFormatTestUtil.getMultiSeg160BytesBinaryRow(row160);
        BinaryRowData varRow160InOne = DataFormatTestUtil.getMultiSeg160BytesInOneSegRow(row160);
        Assertions.assertThat((Object)varRow160InOne).isEqualTo((Object)row160);
        Assertions.assertThat((Object)varRow160InOne).isEqualTo((Object)varRow160);
        Assertions.assertThat((Object)varRow160).isEqualTo((Object)row160);
        Assertions.assertThat((Object)varRow160).isEqualTo((Object)varRow160InOne);
        Assertions.assertThat((Object)row160).isNotEqualTo((Object)row24);
        Assertions.assertThat((Object)varRow160).isNotEqualTo((Object)row24);
        Assertions.assertThat((Object)varRow160InOne).isNotEqualTo((Object)row24);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])row24.getSegments(), (int)0, (MemorySegment[])row160.getSegments(), (int)0, (int)0)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])row24.getSegments(), (int)0, (MemorySegment[])varRow160.getSegments(), (int)0, (int)0)).isTrue();
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[32]), MemorySegmentFactory.wrap((byte[])new byte[32])};
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[16]), MemorySegmentFactory.wrap((byte[])new byte[16]), MemorySegmentFactory.wrap((byte[])new byte[16])};
        segments1[0].put(9, (byte)1);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)14, (int)14)).isFalse();
        segments2[1].put(7, (byte)1);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)14, (int)14)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)2, (MemorySegment[])segments2, (int)16, (int)14)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)2, (MemorySegment[])segments2, (int)16, (int)16)).isTrue();
        segments2[2].put(7, (byte)1);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)2, (MemorySegment[])segments2, (int)32, (int)14)).isTrue();
    }

    @Test
    void testBoundaryCopy() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[32]), MemorySegmentFactory.wrap((byte[])new byte[32])};
        segments1[0].put(15, (byte)5);
        segments1[1].put(15, (byte)6);
        byte[] bytes = new byte[64];
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToBytes((MemorySegment[])segments1, (int)0, (byte[])bytes, (int)0, (int)64);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)0, (int)64)).isTrue();
        bytes = new byte[64];
        segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToBytes((MemorySegment[])segments1, (int)32, (byte[])bytes, (int)0, (int)14);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)32, (MemorySegment[])segments2, (int)0, (int)14)).isTrue();
        bytes = new byte[64];
        segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToBytes((MemorySegment[])segments1, (int)34, (byte[])bytes, (int)0, (int)14);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)34, (MemorySegment[])segments2, (int)0, (int)14)).isTrue();
    }

    @Test
    void testCopyToUnsafe() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[32]), MemorySegmentFactory.wrap((byte[])new byte[32])};
        segments1[0].put(15, (byte)5);
        segments1[1].put(15, (byte)6);
        byte[] bytes = new byte[64];
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToUnsafe((MemorySegment[])segments1, (int)0, (Object)bytes, (int)BinaryRowDataUtil.BYTE_ARRAY_BASE_OFFSET, (int)64);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)0, (int)64)).isTrue();
        bytes = new byte[64];
        segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToUnsafe((MemorySegment[])segments1, (int)32, (Object)bytes, (int)BinaryRowDataUtil.BYTE_ARRAY_BASE_OFFSET, (int)14);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)32, (MemorySegment[])segments2, (int)0, (int)14)).isTrue();
        bytes = new byte[64];
        segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToUnsafe((MemorySegment[])segments1, (int)34, (Object)bytes, (int)BinaryRowDataUtil.BYTE_ARRAY_BASE_OFFSET, (int)14);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)34, (MemorySegment[])segments2, (int)0, (int)14)).isTrue();
    }

    @Test
    void testFind() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[32]), MemorySegmentFactory.wrap((byte[])new byte[32])};
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[16]), MemorySegmentFactory.wrap((byte[])new byte[16]), MemorySegmentFactory.wrap((byte[])new byte[16])};
        Assertions.assertThat((int)BinarySegmentUtils.find((MemorySegment[])segments1, (int)34, (int)0, (MemorySegment[])segments2, (int)0, (int)0)).isEqualTo(34);
        Assertions.assertThat((int)BinarySegmentUtils.find((MemorySegment[])segments1, (int)34, (int)0, (MemorySegment[])segments2, (int)0, (int)15)).isEqualTo(-1);
    }
}

