/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.NestedRowData;
import org.apache.flink.table.data.util.DataFormatTestUtil;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.typeutils.StringDataSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NestedRowDataTest {
    NestedRowDataTest() {
    }

    @Test
    void testNestedRowDataWithOneSegment() {
        BinaryRowData row = this.getBinaryRowData();
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer((SerializerConfig)new SerializerConfigImpl());
        RowData nestedRow = row.getRow(0, 5);
        Assertions.assertThat((int)1).isEqualTo(nestedRow.getInt(0));
        Assertions.assertThat((long)5L).isEqualTo(nestedRow.getLong(1));
        Assertions.assertThat((Comparable)StringData.fromString((String)"12345678")).isEqualTo((Object)nestedRow.getString(2));
        Assertions.assertThat((boolean)nestedRow.isNullAt(3)).isTrue();
        Assertions.assertThat((Object)((DataFormatTestUtil.MyObj)nestedRow.getRawValue(4).toObject(genericSerializer))).isEqualTo((Object)new DataFormatTestUtil.MyObj(15, 5.0));
    }

    @Test
    void testNestedRowDataWithMultipleSegments() {
        BinaryRowData row = this.getBinaryRowData();
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer((SerializerConfig)new SerializerConfigImpl());
        MemorySegment[] segments = DataFormatTestUtil.splitBytes(row.getSegments()[0].getHeapMemory(), 3);
        row.pointTo(segments, 3, row.getSizeInBytes());
        RowData nestedRow = row.getRow(0, 5);
        Assertions.assertThat((int)1).isEqualTo(nestedRow.getInt(0));
        Assertions.assertThat((long)5L).isEqualTo(nestedRow.getLong(1));
        Assertions.assertThat((Comparable)StringData.fromString((String)"12345678")).isEqualTo((Object)nestedRow.getString(2));
        Assertions.assertThat((boolean)nestedRow.isNullAt(3)).isTrue();
        Assertions.assertThat((Object)((DataFormatTestUtil.MyObj)nestedRow.getRawValue(4).toObject(genericSerializer))).isEqualTo((Object)new DataFormatTestUtil.MyObj(15, 5.0));
    }

    @Test
    void testNestInNestedRowData() {
        GenericRowData gRow = new GenericRowData(4);
        gRow.setField(0, (Object)1);
        gRow.setField(1, (Object)5L);
        gRow.setField(2, (Object)StringData.fromString((String)"12345678"));
        gRow.setField(3, null);
        RowDataSerializer serializer = new RowDataSerializer(new LogicalType[]{DataTypes.INT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType()}, new TypeSerializer[]{IntSerializer.INSTANCE, LongSerializer.INSTANCE, StringSerializer.INSTANCE, StringSerializer.INSTANCE});
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, StringData.fromString((String)"hahahahafff"));
        writer.writeRow(1, (RowData)gRow, serializer);
        writer.complete();
        BinaryRowData row2 = new BinaryRowData(1);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeRow(0, (RowData)row, null);
        writer2.complete();
        NestedRowData nestedRow = (NestedRowData)row2.getRow(0, 2);
        BinaryRowData binaryRow = new BinaryRowData(2);
        binaryRow.pointTo(nestedRow.getSegments(), nestedRow.getOffset(), nestedRow.getSizeInBytes());
        Assertions.assertThat((Object)row).isEqualTo((Object)binaryRow);
        Assertions.assertThat((Comparable)StringData.fromString((String)"hahahahafff")).isEqualTo((Object)row2.getRow(0, 2).getString(0));
        nestedRow = row2.getRow(0, 2).getRow(1, 4);
        Assertions.assertThat((int)1).isEqualTo(nestedRow.getInt(0));
        Assertions.assertThat((long)5L).isEqualTo(nestedRow.getLong(1));
        Assertions.assertThat((Comparable)StringData.fromString((String)"12345678")).isEqualTo((Object)nestedRow.getString(2));
        Assertions.assertThat((boolean)nestedRow.isNullAt(3)).isTrue();
    }

    private BinaryRowData getBinaryRowData() {
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        GenericTypeInfo info = new GenericTypeInfo(DataFormatTestUtil.MyObj.class);
        TypeSerializer genericSerializer = info.createSerializer((SerializerConfig)new SerializerConfigImpl());
        GenericRowData gRow = new GenericRowData(5);
        gRow.setField(0, (Object)1);
        gRow.setField(1, (Object)5L);
        gRow.setField(2, (Object)StringData.fromString((String)"12345678"));
        gRow.setField(3, null);
        gRow.setField(4, (Object)RawValueData.fromObject((Object)new DataFormatTestUtil.MyObj(15, 5.0)));
        RowDataSerializer serializer = new RowDataSerializer(new LogicalType[]{DataTypes.INT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.RAW((Class)info.getTypeClass(), (TypeSerializer)info.createSerializer((SerializerConfig)new SerializerConfigImpl())).getLogicalType()}, new TypeSerializer[]{IntSerializer.INSTANCE, LongSerializer.INSTANCE, StringDataSerializer.INSTANCE, StringDataSerializer.INSTANCE, new RawValueDataSerializer(genericSerializer)});
        writer.writeRow(0, (RowData)gRow, serializer);
        writer.complete();
        return row;
    }
}

