/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.RawValueDataAsserter;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.hamcrest.Matcher;
import org.junit.Test;

public class BinaryArrayDataTest {
    @Test
    public void testArray() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 3, 4);
        writer.writeInt(0, 6);
        writer.setNullInt(1);
        writer.writeInt(2, 666);
        writer.complete();
        Assertions.assertThat((int)6).isEqualTo(array.getInt(0));
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
        Assertions.assertThat((int)666).isEqualTo(array.getInt(2));
        BinaryRowData row2 = new BinaryRowData(1);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeArray(0, (ArrayData)array, new ArrayDataSerializer(DataTypes.INT().getLogicalType()));
        writer2.complete();
        BinaryArrayData array2 = (BinaryArrayData)row2.getArray(0);
        Assertions.assertThat((Object)array).isEqualTo((Object)array2);
        Assertions.assertThat((int)6).isEqualTo(array2.getInt(0));
        Assertions.assertThat((boolean)array2.isNullAt(1)).isTrue();
        Assertions.assertThat((int)666).isEqualTo(array2.getInt(2));
        BinaryArrayData array3 = BinaryArrayDataTest.splitArray(array);
        BinaryRowData row22 = new BinaryRowData(1);
        BinaryRowWriter writer22 = new BinaryRowWriter(row22);
        writer22.writeArray(0, (ArrayData)array3, new ArrayDataSerializer(DataTypes.INT().getLogicalType()));
        writer22.complete();
        BinaryArrayData array22 = (BinaryArrayData)row22.getArray(0);
        Assertions.assertThat((Object)array).isEqualTo((Object)array22);
        Assertions.assertThat((int)6).isEqualTo(array22.getInt(0));
        Assertions.assertThat((boolean)array22.isNullAt(1)).isTrue();
        Assertions.assertThat((int)666).isEqualTo(array22.getInt(2));
    }

    @Test
    public void testArrayTypes() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 1);
        writer.setNullBoolean(0);
        writer.writeBoolean(1, true);
        writer.complete();
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        Assertions.assertThat((boolean)array.getBoolean(1)).isTrue();
        array.setBoolean(0, true);
        Assertions.assertThat((boolean)array.getBoolean(0)).isTrue();
        array.setNullBoolean(0);
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        BinaryArrayData newArray = BinaryArrayDataTest.splitArray(array);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        Assertions.assertThat((boolean)newArray.getBoolean(1)).isTrue();
        newArray.setBoolean(0, true);
        Assertions.assertThat((boolean)newArray.getBoolean(0)).isTrue();
        newArray.setNullBoolean(0);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        newArray.setBoolean(0, true);
        Assertions.assertThat((Object)BinaryArrayData.fromPrimitiveArray((boolean[])newArray.toBooleanArray())).isEqualTo((Object)newArray);
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 1);
        writer.setNullByte(0);
        writer.writeByte(1, (byte)25);
        writer.complete();
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        Assertions.assertThat((byte)array.getByte(1)).isEqualTo((byte)25);
        array.setByte(0, (byte)5);
        Assertions.assertThat((byte)array.getByte(0)).isEqualTo((byte)5);
        array.setNullByte(0);
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        newArray = BinaryArrayDataTest.splitArray(array);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        Assertions.assertThat((byte)newArray.getByte(1)).isEqualTo((byte)25);
        newArray.setByte(0, (byte)5);
        Assertions.assertThat((byte)newArray.getByte(0)).isEqualTo((byte)5);
        newArray.setNullByte(0);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        newArray.setByte(0, (byte)3);
        Assertions.assertThat((Object)BinaryArrayData.fromPrimitiveArray((byte[])newArray.toByteArray())).isEqualTo((Object)newArray);
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 2);
        writer.setNullShort(0);
        writer.writeShort(1, (short)25);
        writer.complete();
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        Assertions.assertThat((short)array.getShort(1)).isEqualTo((short)25);
        array.setShort(0, (short)5);
        Assertions.assertThat((short)array.getShort(0)).isEqualTo((short)5);
        array.setNullShort(0);
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        newArray = BinaryArrayDataTest.splitArray(array);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        Assertions.assertThat((short)newArray.getShort(1)).isEqualTo((short)25);
        newArray.setShort(0, (short)5);
        Assertions.assertThat((short)newArray.getShort(0)).isEqualTo((short)5);
        newArray.setNullShort(0);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        newArray.setShort(0, (short)3);
        Assertions.assertThat((Object)BinaryArrayData.fromPrimitiveArray((short[])newArray.toShortArray())).isEqualTo((Object)newArray);
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 4);
        writer.setNullInt(0);
        writer.writeInt(1, 25);
        writer.complete();
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        Assertions.assertThat((int)array.getInt(1)).isEqualTo(25);
        array.setInt(0, 5);
        Assertions.assertThat((int)array.getInt(0)).isEqualTo(5);
        array.setNullInt(0);
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        newArray = BinaryArrayDataTest.splitArray(array);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        Assertions.assertThat((int)newArray.getInt(1)).isEqualTo(25);
        newArray.setInt(0, 5);
        Assertions.assertThat((int)newArray.getInt(0)).isEqualTo(5);
        newArray.setNullInt(0);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        newArray.setInt(0, 3);
        Assertions.assertThat((Object)BinaryArrayData.fromPrimitiveArray((int[])newArray.toIntArray())).isEqualTo((Object)newArray);
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullLong(0);
        writer.writeLong(1, 25L);
        writer.complete();
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        Assertions.assertThat((long)array.getLong(1)).isEqualTo(25L);
        array.setLong(0, 5L);
        Assertions.assertThat((long)array.getLong(0)).isEqualTo(5L);
        array.setNullLong(0);
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        newArray = BinaryArrayDataTest.splitArray(array);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        Assertions.assertThat((long)newArray.getLong(1)).isEqualTo(25L);
        newArray.setLong(0, 5L);
        Assertions.assertThat((long)newArray.getLong(0)).isEqualTo(5L);
        newArray.setNullLong(0);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        newArray.setLong(0, 3L);
        Assertions.assertThat((Object)BinaryArrayData.fromPrimitiveArray((long[])newArray.toLongArray())).isEqualTo((Object)newArray);
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 4);
        writer.setNullFloat(0);
        writer.writeFloat(1, 25.0f);
        writer.complete();
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        Assertions.assertThat((float)array.getFloat(1)).isEqualTo(25.0f);
        array.setFloat(0, 5.0f);
        Assertions.assertThat((float)array.getFloat(0)).isEqualTo(5.0f);
        array.setNullFloat(0);
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        newArray = BinaryArrayDataTest.splitArray(array);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        Assertions.assertThat((float)newArray.getFloat(1)).isEqualTo(25.0f);
        newArray.setFloat(0, 5.0f);
        Assertions.assertThat((float)newArray.getFloat(0)).isEqualTo(5.0f);
        newArray.setNullFloat(0);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        newArray.setFloat(0, 3.0f);
        Assertions.assertThat((Object)BinaryArrayData.fromPrimitiveArray((float[])newArray.toFloatArray())).isEqualTo((Object)newArray);
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullDouble(0);
        writer.writeDouble(1, 25.0);
        writer.complete();
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        Assertions.assertThat((double)array.getDouble(1)).isEqualTo(25.0);
        array.setDouble(0, 5.0);
        Assertions.assertThat((double)array.getDouble(0)).isEqualTo(5.0);
        array.setNullDouble(0);
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        newArray = BinaryArrayDataTest.splitArray(array);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        Assertions.assertThat((double)newArray.getDouble(1)).isEqualTo(25.0);
        newArray.setDouble(0, 5.0);
        Assertions.assertThat((double)newArray.getDouble(0)).isEqualTo(5.0);
        newArray.setNullDouble(0);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        newArray.setDouble(0, 3.0);
        Assertions.assertThat((Object)BinaryArrayData.fromPrimitiveArray((double[])newArray.toDoubleArray())).isEqualTo((Object)newArray);
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullAt(0);
        writer.writeString(1, StringData.fromString((String)"jaja"));
        writer.complete();
        Assertions.assertThat((boolean)array.isNullAt(0)).isTrue();
        Assertions.assertThat((Comparable)array.getString(1)).isEqualTo((Object)StringData.fromString((String)"jaja"));
        newArray = BinaryArrayDataTest.splitArray(array);
        Assertions.assertThat((boolean)newArray.isNullAt(0)).isTrue();
        Assertions.assertThat((Comparable)newArray.getString(1)).isEqualTo((Object)StringData.fromString((String)"jaja"));
        BinaryArrayData subArray = new BinaryArrayData();
        BinaryArrayWriter subWriter = new BinaryArrayWriter(subArray, 2, 8);
        subWriter.setNullAt(0);
        subWriter.writeString(1, StringData.fromString((String)"hehehe"));
        subWriter.complete();
        BinaryArrayData array2 = new BinaryArrayData();
        BinaryArrayWriter writer2 = new BinaryArrayWriter(array2, 2, 8);
        writer2.setNullAt(0);
        writer2.writeArray(1, (ArrayData)subArray, new ArrayDataSerializer(DataTypes.INT().getLogicalType()));
        writer2.complete();
        Assertions.assertThat((boolean)array2.isNullAt(0)).isTrue();
        Assertions.assertThat((Object)array2.getArray(1)).isEqualTo((Object)subArray);
        BinaryArrayData newArray2 = BinaryArrayDataTest.splitArray(array2);
        Assertions.assertThat((boolean)newArray2.isNullAt(0)).isTrue();
        Assertions.assertThat((Object)newArray2.getArray(1)).isEqualTo((Object)subArray);
        array2 = new BinaryArrayData();
        writer2 = new BinaryArrayWriter(array2, 2, 8);
        writer2.setNullAt(0);
        writer2.writeMap(1, (MapData)BinaryMapData.valueOf((BinaryArrayData)subArray, (BinaryArrayData)subArray), new MapDataSerializer(DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType()));
        writer2.complete();
        Assertions.assertThat((boolean)array2.isNullAt(0)).isTrue();
        Assertions.assertThat((Object)array2.getMap(1)).isEqualTo((Object)BinaryMapData.valueOf((BinaryArrayData)subArray, (BinaryArrayData)subArray));
        newArray2 = BinaryArrayDataTest.splitArray(array2);
        Assertions.assertThat((boolean)newArray2.isNullAt(0)).isTrue();
        Assertions.assertThat((Object)newArray2.getMap(1)).isEqualTo((Object)BinaryMapData.valueOf((BinaryArrayData)subArray, (BinaryArrayData)subArray));
    }

    @Test
    public void testMap() {
        BinaryArrayData array1 = new BinaryArrayData();
        BinaryArrayWriter writer1 = new BinaryArrayWriter(array1, 3, 4);
        writer1.writeInt(0, 6);
        writer1.writeInt(1, 5);
        writer1.writeInt(2, 666);
        writer1.complete();
        BinaryArrayData array2 = new BinaryArrayData();
        BinaryArrayWriter writer2 = new BinaryArrayWriter(array2, 3, 8);
        writer2.writeString(0, StringData.fromString((String)"6"));
        writer2.writeString(1, StringData.fromString((String)"5"));
        writer2.writeString(2, StringData.fromString((String)"666"));
        writer2.complete();
        BinaryMapData binaryMap = BinaryMapData.valueOf((BinaryArrayData)array1, (BinaryArrayData)array2);
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        rowWriter.writeMap(0, (MapData)binaryMap, new MapDataSerializer(DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType()));
        rowWriter.complete();
        BinaryMapData map = (BinaryMapData)row.getMap(0);
        BinaryArrayData key = map.keyArray();
        BinaryArrayData value = map.valueArray();
        Assertions.assertThat((Object)map).isEqualTo((Object)binaryMap);
        Assertions.assertThat((Object)key).isEqualTo((Object)array1);
        Assertions.assertThat((Object)value).isEqualTo((Object)array2);
        Assertions.assertThat((int)5).isEqualTo(key.getInt(1));
        Assertions.assertThat((Comparable)StringData.fromString((String)"5")).isEqualTo((Object)value.getString(1));
    }

    private static BinaryArrayData splitArray(BinaryArrayData array) {
        BinaryArrayData ret = new BinaryArrayData();
        MemorySegment[] segments = BinaryArrayDataTest.splitBytes(BinarySegmentUtils.copyToBytes((MemorySegment[])array.getSegments(), (int)0, (int)array.getSizeInBytes()), 0);
        ret.pointTo(segments, 0, array.getSizeInBytes());
        return ret;
    }

    private static MemorySegment[] splitBytes(byte[] bytes, int baseOffset) {
        int newSize = (bytes.length + 1) / 2 + baseOffset;
        MemorySegment[] ret = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[newSize]), MemorySegmentFactory.wrap((byte[])new byte[newSize])};
        ret[0].put(baseOffset, bytes, 0, newSize - baseOffset);
        ret[1].put(0, bytes, newSize - baseOffset, bytes.length - (newSize - baseOffset));
        return ret;
    }

    @Test
    public void testToArray() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 3, 2);
        writer.writeShort(0, (short)5);
        writer.writeShort(1, (short)10);
        writer.writeShort(2, (short)15);
        writer.complete();
        short[] shorts = array.toShortArray();
        Assertions.assertThat((short)shorts[0]).isEqualTo((short)5);
        Assertions.assertThat((short)shorts[1]).isEqualTo((short)10);
        Assertions.assertThat((short)shorts[2]).isEqualTo((short)15);
        MemorySegment[] segments = BinaryArrayDataTest.splitBytes(writer.getSegments().getArray(), 3);
        array.pointTo(segments, 3, array.getSizeInBytes());
        Assertions.assertThat((short)array.getShort(0)).isEqualTo((short)5);
        Assertions.assertThat((short)array.getShort(1)).isEqualTo((short)10);
        Assertions.assertThat((short)array.getShort(2)).isEqualTo((short)15);
        short[] shorts2 = array.toShortArray();
        Assertions.assertThat((short)shorts2[0]).isEqualTo((short)5);
        Assertions.assertThat((short)shorts2[1]).isEqualTo((short)10);
        Assertions.assertThat((short)shorts2[2]).isEqualTo((short)15);
    }

    @Test
    public void testDecimal() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        int precision = 4;
        int scale = 2;
        writer.reset();
        writer.writeDecimal(0, DecimalData.fromUnscaledLong((long)5L, (int)precision, (int)scale), precision);
        writer.setNullAt(1);
        writer.complete();
        Assertions.assertThat((String)array.getDecimal(0, precision, scale).toString()).isEqualTo("0.05");
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
        array.setDecimal(0, DecimalData.fromUnscaledLong((long)6L, (int)precision, (int)scale), precision);
        Assertions.assertThat((String)array.getDecimal(0, precision, scale).toString()).isEqualTo("0.06");
        precision = 25;
        scale = 5;
        DecimalData decimal1 = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(5.55), (int)precision, (int)scale);
        DecimalData decimal2 = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.55), (int)precision, (int)scale);
        writer.reset();
        writer.writeDecimal(0, decimal1, precision);
        writer.writeDecimal(1, null, precision);
        writer.complete();
        Assertions.assertThat((String)array.getDecimal(0, precision, scale).toString()).isEqualTo("5.55000");
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
        array.setDecimal(0, decimal2, precision);
        Assertions.assertThat((String)array.getDecimal(0, precision, scale).toString()).isEqualTo("6.55000");
    }

    @Test
    public void testGeneric() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        RawValueData generic = RawValueData.fromObject((Object)"hahah");
        RawValueDataSerializer serializer = new RawValueDataSerializer((TypeSerializer)StringSerializer.INSTANCE);
        writer.writeRawValue(0, generic, serializer);
        writer.setNullAt(1);
        writer.complete();
        RawValueData newGeneric = array.getRawValue(0);
        Assertions.assertThat((Object)newGeneric).satisfies((Condition)HamcrestCondition.matching((Matcher)RawValueDataAsserter.equivalent(generic, serializer)));
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
    }

    @Test
    public void testNested() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        writer.writeRow(0, (RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"1"), 1}), new RowDataSerializer(RowType.of((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, new IntType()})));
        writer.setNullAt(1);
        writer.complete();
        RowData nestedRow = array.getRow(0, 2);
        Assertions.assertThat((String)nestedRow.getString(0).toString()).isEqualTo("1");
        Assertions.assertThat((int)nestedRow.getInt(1)).isEqualTo(1);
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
    }

    @Test
    public void testBinary() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        byte[] bytes1 = new byte[]{1, -1, 5};
        byte[] bytes2 = new byte[]{1, -1, 5, 5, 1, 5, 1, 5};
        writer.writeBinary(0, bytes1);
        writer.writeBinary(1, bytes2);
        writer.complete();
        Assertions.assertThat((byte[])array.getBinary(0)).isEqualTo((Object)bytes1);
        Assertions.assertThat((byte[])array.getBinary(1)).isEqualTo((Object)bytes2);
    }

    @Test
    public void testTimestampData() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        int precision = 3;
        writer.reset();
        writer.writeTimestamp(0, TimestampData.fromEpochMillis((long)123L), 3);
        writer.setNullAt(1);
        writer.complete();
        Assertions.assertThat((String)array.getTimestamp(0, 3).toString()).isEqualTo("1970-01-01T00:00:00.123");
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
        array.setTimestamp(0, TimestampData.fromEpochMillis((long)-123L), 3);
        Assertions.assertThat((String)array.getTimestamp(0, 3).toString()).isEqualTo("1969-12-31T23:59:59.877");
        precision = 9;
        TimestampData timestamp1 = TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(1970, 1, 1, 0, 0, 0, 123456789));
        TimestampData timestamp2 = TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf("1969-01-01 00:00:00.123456789"));
        writer.reset();
        writer.writeTimestamp(0, timestamp1, 9);
        writer.writeTimestamp(1, null, 9);
        writer.complete();
        Assertions.assertThat((String)array.getTimestamp(0, 9).toString()).isEqualTo("1970-01-01T00:00:00.123456789");
        Assertions.assertThat((boolean)array.isNullAt(1)).isTrue();
        array.setTimestamp(0, timestamp2, 9);
        Assertions.assertThat((String)array.getTimestamp(0, 9).toString()).isEqualTo("1969-01-01T00:00:00.123456789");
    }
}

