/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TimeWindowUtilTest {
    private static final ZoneId UTC_ZONE_ID = TimeZone.getTimeZone("UTC").toZoneId();

    @Test
    public void testShiftedTimeZone() {
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("1970-01-01T00:00:01"), (ZoneId)zoneId)).isEqualTo(-28799000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("1970-01-01T07:59:59.999"), (ZoneId)zoneId)).isEqualTo(-1L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("1970-01-01T08:00:01"), (ZoneId)zoneId)).isEqualTo(1000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("1970-01-01T08:00:00.001"), (ZoneId)zoneId)).isEqualTo(1L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("1970-01-01T00:00:01"), (ZoneId)zoneId)).isEqualTo(-28799000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("1970-01-01T07:59:59.999"), (ZoneId)zoneId)).isEqualTo(-1L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("1970-01-01T08:00:01"), (ZoneId)zoneId)).isEqualTo(1000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("1970-01-01T08:00:00.001"), (ZoneId)zoneId)).isEqualTo(1L);
    }

    @Test
    public void testDaylightSaving() {
        ZoneId zoneId = ZoneId.of("America/Los_Angeles");
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-03-14T00:00:00"), (ZoneId)zoneId)).isEqualTo(1615708800000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-03-14T01:00:00"), (ZoneId)zoneId)).isEqualTo(1615712400000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-03-14T02:00:00"), (ZoneId)zoneId)).isEqualTo(1615716000000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-03-14T02:30:00"), (ZoneId)zoneId)).isEqualTo(1615716000000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-03-14T02:59:59"), (ZoneId)zoneId)).isEqualTo(1615716000000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-03-14T03:00:00"), (ZoneId)zoneId)).isEqualTo(1615716000000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-03-14T03:30:00"), (ZoneId)zoneId)).isEqualTo(1615717800000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-03-14T03:59:59"), (ZoneId)zoneId)).isEqualTo(1615719599000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-03-14T00:00:00"), (ZoneId)zoneId)).isEqualTo(1615708800000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-03-14T01:00:00"), (ZoneId)zoneId)).isEqualTo(1615712400000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-03-14T02:00:00"), (ZoneId)zoneId)).isEqualTo(1615716000000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-03-14T02:30:00"), (ZoneId)zoneId)).isEqualTo(1615717800000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-03-14T02:59:59"), (ZoneId)zoneId)).isEqualTo(1615719599000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-03-14T03:30:00"), (ZoneId)zoneId)).isEqualTo(1615717800000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-03-14T03:00:00"), (ZoneId)zoneId)).isEqualTo(1615716000000L);
        Assertions.assertThat((long)TimeWindowUtil.toUtcTimestampMills((long)1636272000000L, (ZoneId)zoneId)).isEqualTo(TimeWindowUtilTest.utcMills("2021-11-07T01:00:00"));
        Assertions.assertThat((long)TimeWindowUtil.toUtcTimestampMills((long)1636275600000L, (ZoneId)zoneId)).isEqualTo(TimeWindowUtilTest.utcMills("2021-11-07T01:00:00"));
        Assertions.assertThat((long)TimeWindowUtil.toUtcTimestampMills((long)1636272001000L, (ZoneId)zoneId)).isEqualTo(TimeWindowUtilTest.utcMills("2021-11-07T01:00:01"));
        Assertions.assertThat((long)TimeWindowUtil.toUtcTimestampMills((long)1636275599000L, (ZoneId)zoneId)).isEqualTo(TimeWindowUtilTest.utcMills("2021-11-07T01:59:59"));
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-11-07T00:00:00"), (ZoneId)zoneId)).isEqualTo(1636268400000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-11-07T01:00:00"), (ZoneId)zoneId)).isEqualTo(1636275600000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-11-07T02:00:00"), (ZoneId)zoneId)).isEqualTo(1636279200000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-11-07T00:00:01"), (ZoneId)zoneId)).isEqualTo(1636268401000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-11-07T01:59:59"), (ZoneId)zoneId)).isEqualTo(1636279199000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)TimeWindowUtilTest.utcMills("2021-11-07T02:00:01"), (ZoneId)zoneId)).isEqualTo(1636279201000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-11-07T00:00:00"), (ZoneId)zoneId)).isEqualTo(1636268400000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-11-07T01:00:00"), (ZoneId)zoneId)).isEqualTo(1636272000000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-11-07T02:00:00"), (ZoneId)zoneId)).isEqualTo(1636279200000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-11-07T00:00:01"), (ZoneId)zoneId)).isEqualTo(1636268401000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-11-07T01:59:59"), (ZoneId)zoneId)).isEqualTo(1636275599000L);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)TimeWindowUtilTest.utcMills("2021-11-07T02:00:01"), (ZoneId)zoneId)).isEqualTo(1636279201000L);
    }

    @Test
    public void testMaxWatermark() {
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        Assertions.assertThat((long)TimeWindowUtil.toUtcTimestampMills((long)Long.MAX_VALUE, (ZoneId)zoneId)).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMillsForTimer((long)Long.MAX_VALUE, (ZoneId)zoneId)).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((long)TimeWindowUtil.toEpochMills((long)Long.MAX_VALUE, (ZoneId)zoneId)).isEqualTo(Long.MAX_VALUE);
    }

    private static long utcMills(String utcDateTime) {
        return LocalDateTime.parse(utcDateTime).atZone(UTC_ZONE_ID).toInstant().toEpochMilli();
    }
}

