/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.wmassigners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.runtime.operators.wmassigners.RowTimeMiniBatchAssginerOperator;
import org.apache.flink.table.runtime.operators.wmassigners.WatermarkAssignerOperatorTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RowTimeMiniBatchAssginerOperatorTest
extends WatermarkAssignerOperatorTestBase {
    @Test
    public void testRowTimeWatermarkAssigner() throws Exception {
        RowTimeMiniBatchAssginerOperator operator = new RowTimeMiniBatchAssginerOperator(5L);
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)operator);
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{1L})));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{2L})));
        testHarness.processWatermark(new Watermark(2L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{3L})));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{4L})));
        testHarness.processWatermark(new Watermark(3L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{5L})));
        testHarness.processWatermark(new Watermark(4L));
        testHarness.processWatermark(new Watermark(5L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{7L})));
        testHarness.processWatermark(new Watermark(6L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{11L})));
        testHarness.processWatermark(new Watermark(10L));
        testHarness.processWatermark(new Watermark(12L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{16L})));
        testHarness.processWatermark(new Watermark(15L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{17L})));
        testHarness.processWatermark(new Watermark(16L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{20L})));
        testHarness.processWatermark(new Watermark(19L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{22L})));
        testHarness.processWatermark(new Watermark(20L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{24L})));
        testHarness.processWatermark(new Watermark(21L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{25L})));
        testHarness.close();
        ArrayList<Watermark> expected = new ArrayList<Watermark>();
        expected.add(new Watermark(4L));
        expected.add(new Watermark(10L));
        expected.add(new Watermark(15L));
        expected.add(new Watermark(19L));
        expected.add(new Watermark(21L));
        ConcurrentLinkedQueue output = testHarness.getOutput();
        List<Watermark> watermarks = this.extractWatermarks(output);
        Assertions.assertThat(watermarks).isEqualTo(expected);
        Assertions.assertThat((Collection)output).hasSize(expected.size() + 13);
    }

    @Test
    public void testEndWatermarkIsForwarded() throws Exception {
        RowTimeMiniBatchAssginerOperator operator = new RowTimeMiniBatchAssginerOperator(50L);
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)operator);
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{1L})));
        testHarness.processWatermark(new Watermark(2L));
        testHarness.processElement(new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{50L})));
        testHarness.processWatermark(Watermark.MAX_WATERMARK);
        ConcurrentLinkedQueue output = testHarness.getOutput();
        List<Watermark> watermarks = this.extractWatermarks(output);
        Assertions.assertThat(watermarks).hasSize(1);
        Assertions.assertThat((Object)watermarks.get(0)).isEqualTo((Object)Watermark.MAX_WATERMARK);
    }
}

