/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.slicing;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssignerTestBase;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigners;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceSharedAssigner;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HoppingSliceAssignerTest
extends SliceAssignerTestBase {
    @Parameterized.Parameter
    public ZoneId shiftTimeZone;

    @Parameterized.Parameters(name="timezone = {0}")
    public static Collection<ZoneId> parameters() {
        return Arrays.asList(ZoneId.of("America/Los_Angeles"), ZoneId.of("Asia/Shanghai"));
    }

    @Test
    public void testSliceAssignment() {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat((long)HoppingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat((long)HoppingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T04:59:59.999"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)HoppingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T06:00:00"));
    }

    @Test
    public void testSliceAssignmentWithOffset() {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L)).withOffset(Duration.ofMillis(100L));
        Assertions.assertThat((long)HoppingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00.1"))).isEqualTo(this.utcMills("1970-01-01T01:00:00.1"));
        Assertions.assertThat((long)HoppingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.099"))).isEqualTo(this.utcMills("1970-01-01T05:00:00.1"));
        Assertions.assertThat((long)HoppingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.1"))).isEqualTo(this.utcMills("1970-01-01T06:00:00.1"));
    }

    @Test
    public void testDstSaving() {
        if (!TimeZone.getTimeZone(this.shiftTimeZone).useDaylightTime()) {
            return;
        }
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(4L), (Duration)Duration.ofHours(1L));
        long epoch1 = 1615708800000L;
        long epoch2 = 1615712400000L;
        long epoch3 = 1615716000000L;
        long epoch4 = 1615719600000L;
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-03-13T21:00", "2021-03-14T01:00", epoch1, (SliceAssigner)assigner);
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-03-13T22:00", "2021-03-14T02:00", epoch2, (SliceAssigner)assigner);
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch3, (SliceAssigner)assigner);
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-03-14T01:00", "2021-03-14T05:00", epoch4, (SliceAssigner)assigner);
        long epoch5 = 1636268400000L;
        long epoch6 = 1636272000000L;
        long epoch7 = 1636275600000L;
        long epoch8 = 1636279200000L;
        long epoch9 = 1636282800000L;
        long epoch10 = 1636286400000L;
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-11-06T21:00", "2021-11-07T01:00", epoch5, (SliceAssigner)assigner);
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-11-06T22:00", "2021-11-07T02:00", epoch6, (SliceAssigner)assigner);
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-11-06T22:00", "2021-11-07T02:00", epoch7, (SliceAssigner)assigner);
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-11-06T23:00", "2021-11-07T03:00", epoch8, (SliceAssigner)assigner);
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch9, (SliceAssigner)assigner);
        HoppingSliceAssignerTest.assertSliceStartEnd("2021-11-07T01:00", "2021-11-07T05:00", epoch10, (SliceAssigner)assigner);
    }

    @Test
    public void testGetWindowStart() {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T19:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T01:00:00"))).isEqualTo(this.utcMills("1969-12-31T20:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T02:00:00"))).isEqualTo(this.utcMills("1969-12-31T21:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T03:00:00"))).isEqualTo(this.utcMills("1969-12-31T22:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00"))).isEqualTo(this.utcMills("1969-12-31T23:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T06:00:00"))).isEqualTo(this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
    }

    @Test
    public void testExpiredSlices() {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(4L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat(HoppingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1969-12-31T21:00:00")});
        Assertions.assertThat(HoppingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T04:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T01:00:00")});
        Assertions.assertThat(HoppingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T08:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T05:00:00")});
    }

    @Test
    public void testMerge() throws Exception {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat((Long)HoppingSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).isNull();
        Assertions.assertThat(HoppingSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).isEqualTo(Arrays.asList(this.utcMills("1970-01-01T00:00:00"), this.utcMills("1969-12-31T23:00:00"), this.utcMills("1969-12-31T22:00:00"), this.utcMills("1969-12-31T21:00:00"), this.utcMills("1969-12-31T20:00:00")));
        Assertions.assertThat((Long)HoppingSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).isNull();
        Assertions.assertThat(HoppingSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).isEqualTo(Arrays.asList(this.utcMills("1970-01-01T05:00:00"), this.utcMills("1970-01-01T04:00:00"), this.utcMills("1970-01-01T03:00:00"), this.utcMills("1970-01-01T02:00:00"), this.utcMills("1970-01-01T01:00:00")));
        Assertions.assertThat((Long)HoppingSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T06:00:00"))).isNull();
        Assertions.assertThat(HoppingSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T06:00:00"))).isEqualTo(Arrays.asList(this.utcMills("1970-01-01T06:00:00"), this.utcMills("1970-01-01T05:00:00"), this.utcMills("1970-01-01T04:00:00"), this.utcMills("1970-01-01T03:00:00"), this.utcMills("1970-01-01T02:00:00")));
    }

    @Test
    public void testNextTriggerWindow() {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T00:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T01:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T01:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T02:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T02:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T03:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T03:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T04:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T04:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T05:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T05:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T06:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T06:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T07:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T00:00:00"), () -> true)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T01:00:00"), () -> true)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T02:00:00"), () -> true)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T03:00:00"), () -> true)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T04:00:00"), () -> true)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T05:00:00"), () -> true)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T06:00:00"), () -> true)).isEqualTo(Optional.empty());
    }

    @Test
    public void testEventTime() {
        SliceAssigners.HoppingSliceAssigner assigner1 = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)assigner1.isEventTime()).isTrue();
        SliceAssigners.HoppingSliceAssigner assigner2 = SliceAssigners.hopping((int)-1, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)assigner2.isEventTime()).isFalse();
    }

    @Test
    public void testInvalidParameters() {
        HoppingSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(-2L), (Duration)Duration.ofSeconds(1L)), "Hopping Window must satisfy slide > 0 and size > 0, but got slide 1000ms and size -2000ms.");
        HoppingSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofSeconds(-1L)), "Hopping Window must satisfy slide > 0 and size > 0, but got slide -1000ms and size 2000ms.");
        HoppingSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(2L)), "Slicing Hopping Window requires size must be an integral multiple of slide, but got size 5000ms and slide 2000ms.");
        SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(10L), (Duration)Duration.ofSeconds(5L)).withOffset(Duration.ofSeconds(-1L));
    }

    private long localMills(String timestampStr) {
        return this.localMills(timestampStr, this.shiftTimeZone);
    }
}

