/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.join.stream.StreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.StreamingJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class StreamingJoinOperatorTest
extends StreamingJoinOperatorTestBase {
    private static final Function<String, Boolean[]> JOIN_TYPE_EXTRACTOR = testDisplayName -> {
        if (testDisplayName.contains("InnerJoin")) {
            return new Boolean[]{false, false};
        }
        if (testDisplayName.contains("LeftOuterJoin")) {
            return new Boolean[]{true, false};
        }
        return new Boolean[]{false, true};
    };

    protected StreamingJoinOperator createJoinOperator(TestInfo testInfo) {
        Boolean[] joinTypeSpec = JOIN_TYPE_EXTRACTOR.apply(testInfo.getDisplayName());
        Long[] ttl = (Long[])STATE_RETENTION_TIME_EXTRACTOR.apply(testInfo.getTags());
        return new StreamingJoinOperator(this.leftTypeInfo, this.rightTypeInfo, this.joinCondition, this.leftInputSpec, this.rightInputSpec, joinTypeSpec[0].booleanValue(), joinTypeSpec[1].booleanValue(), new boolean[]{true}, ttl[0].longValue(), ttl[1].longValue());
    }

    @Override
    protected RowType getOutputType() {
        return RowType.of((LogicalType[])((LogicalType[])Stream.concat(this.leftTypeInfo.toRowType().getChildren().stream(), this.rightTypeInfo.toRowType().getChildren().stream()).toArray(LogicalType[]::new)), (String[])((String[])Stream.concat(this.leftTypeInfo.toRowType().getFieldNames().stream(), this.rightTypeInfo.toRowType().getFieldNames().stream()).toArray(String[]::new)));
    }

    @Tags(value={@Tag(value="leftStateRetentionTime=4000"), @Tag(value="rightStateRetentionTime=1000")})
    @Test
    public void testInnerJoinWithDifferentStateRetentionTime() throws Exception {
        this.testHarness.setStateTtlProcessingTime(1L);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "AIR"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#2", "AIR"));
        this.testHarness.setStateTtlProcessingTime(3000L);
        this.testHarness.processElement1(StreamRecordUtils.updateAfterRecord("Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement2(StreamRecordUtils.updateAfterRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.UPDATE_AFTER, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"));
        this.testHarness.setStateTtlProcessingTime(4001L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#1", "TRUCK"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement2(StreamRecordUtils.deleteRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"));
        this.testHarness.setStateTtlProcessingTime(7000L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "RAIL"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
    }

    @Test
    public void testInnerJoinWithStateRetentionDisabled() throws Exception {
        this.testHarness.setStateTtlProcessingTime(1L);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "AIR"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#2", "AIR"));
        this.testHarness.setStateTtlProcessingTime(3000L);
        this.testHarness.processElement1(StreamRecordUtils.updateAfterRecord("Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.UPDATE_AFTER, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "AIR"));
        this.testHarness.processElement2(StreamRecordUtils.updateAfterRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.UPDATE_AFTER, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"));
        this.testHarness.setStateTtlProcessingTime(4001L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#1", "TRUCK"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#1", "TRUCK"));
        this.testHarness.processElement2(StreamRecordUtils.deleteRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"));
        this.testHarness.setStateTtlProcessingTime(7000L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "RAIL"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "RAIL"));
    }

    @Tags(value={@Tag(value="leftStateRetentionTime=4000"), @Tag(value="rightStateRetentionTime=4000")})
    @Test
    public void testInnerJoinWithSameStateRetentionTime() throws Exception {
        this.testHarness.setStateTtlProcessingTime(1L);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "AIR"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#2", "AIR"));
        this.testHarness.setStateTtlProcessingTime(4000L);
        this.testHarness.processElement1(StreamRecordUtils.updateAfterRecord("Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.UPDATE_AFTER, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "AIR"));
        this.testHarness.setStateTtlProcessingTime(4001L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#1", "TRUCK"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.setStateTtlProcessingTime(7999L);
        this.testHarness.processElement2(StreamRecordUtils.updateAfterRecord("LineOrd#2", "TRUCK"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.UPDATE_AFTER, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "TRUCK"));
        this.testHarness.setStateTtlProcessingTime(8000L);
        this.testHarness.processElement2(StreamRecordUtils.updateAfterRecord("LineOrd#2", "RAIL"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
    }

    @Tags(value={@Tag(value="leftStateRetentionTime=4000"), @Tag(value="rightStateRetentionTime=1000")})
    @Test
    public void testLeftOuterJoinWithDifferentStateRetentionTime() throws Exception {
        this.testHarness.setStateTtlProcessingTime(1L);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464", null, null));
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", null, null));
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "AIR"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", null, null), StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#2", "AIR"));
        this.testHarness.setStateTtlProcessingTime(3000L);
        this.testHarness.processElement1(StreamRecordUtils.updateAfterRecord("Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", null, null));
        this.testHarness.processElement2(StreamRecordUtils.updateAfterRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", null, null), StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"));
        this.testHarness.setStateTtlProcessingTime(4001L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#1", "TRUCK"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement2(StreamRecordUtils.deleteRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"), StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", null, null));
        this.testHarness.setStateTtlProcessingTime(8001L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "RAIL"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
    }

    @Test
    public void testLeftOuterJoinWithStateRetentionDisabled() throws Exception {
        this.testHarness.setStateTtlProcessingTime(1L);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464", null, null));
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", null, null));
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "AIR"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", null, null), StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#2", "AIR"));
        this.testHarness.setStateTtlProcessingTime(3000L);
        this.testHarness.processElement1(StreamRecordUtils.updateAfterRecord("Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "AIR"));
        this.testHarness.processElement2(StreamRecordUtils.updateAfterRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"));
        this.testHarness.setStateTtlProcessingTime(4001L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#1", "TRUCK"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, "Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464", null, null), StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#1", "TRUCK"));
        this.testHarness.setStateTtlProcessingTime(8001L);
        this.testHarness.processElement2(StreamRecordUtils.deleteRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"));
    }

    @Tags(value={@Tag(value="leftStateRetentionTime=4000"), @Tag(value="rightStateRetentionTime=1000")})
    @Test
    public void testRightOuterJoinWithDifferentStateRetentionTime() throws Exception {
        this.testHarness.setStateTtlProcessingTime(1L);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.setStateTtlProcessingTime(4001L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "AIR"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, null, null, null, "LineOrd#2", "AIR"));
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#1", "TRUCK"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, null, null, null, "LineOrd#1", "TRUCK"));
        this.testHarness.setStateTtlProcessingTime(5001L);
        this.testHarness.processElement1(StreamRecordUtils.updateAfterRecord("Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement2(StreamRecordUtils.updateAfterRecord("LineOrd#2", "SHIP"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "SHIP"));
        this.testHarness.processElement2(StreamRecordUtils.updateAfterRecord("LineOrd#1", "RAIL"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, null, null, null, "LineOrd#1", "RAIL"));
        this.testHarness.setStateTtlProcessingTime(6000L);
        this.testHarness.processElement1(StreamRecordUtils.updateAfterRecord("Ord#1", "LineOrd#1", "3 North Winchester Drive, Haines City, FL 33844"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.DELETE, null, null, null, "LineOrd#1", "RAIL"), StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#1", "3 North Winchester Drive, Haines City, FL 33844", "LineOrd#1", "RAIL"));
        this.testHarness.setStateTtlProcessingTime(7000L);
        this.testHarness.processElement1(StreamRecordUtils.deleteRecord("Ord#1", "LineOrd#1", "3 North Winchester Drive, Haines City, FL 33844"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
    }

    @Test
    public void testRightOuterJoinWithDStateRetentionDisabled() throws Exception {
        this.testHarness.setStateTtlProcessingTime(1L);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.processElement1(StreamRecordUtils.insertRecord("Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464"));
        this.assertor.shouldEmitNothing((AbstractStreamOperatorTestHarness<RowData>)this.testHarness);
        this.testHarness.setStateTtlProcessingTime(4001L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#2", "AIR"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#2", "AIR"));
        this.testHarness.setStateTtlProcessingTime(10000L);
        this.testHarness.processElement2(StreamRecordUtils.insertRecord("LineOrd#1", "TRUCK"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#1", "3 Bellevue Drive, Pottstown, PA 19464", "LineOrd#1", "TRUCK"));
        this.testHarness.setStateTtlProcessingTime(20000L);
        this.testHarness.processElement1(StreamRecordUtils.updateAfterRecord("Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815"));
        this.assertor.shouldEmit((AbstractStreamOperatorTestHarness<RowData>)this.testHarness, StreamRecordUtils.rowOfKind(RowKind.INSERT, "Ord#1", "LineOrd#2", "68 Manor Station Street, Honolulu, HI 96815", "LineOrd#2", "AIR"));
    }
}

