/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.GenericRowRecordSortComparator;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.HandwrittenSelectorUtil;

abstract class RowTimeDeduplicateFunctionTestBase {
    protected final long miniBatchSize = 4L;
    protected Time minTtlTime = Time.milliseconds((long)10L);
    protected InternalTypeInfo inputRowType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, new IntType(), new BigIntType()});
    protected TypeSerializer<RowData> serializer = this.inputRowType.toSerializer();
    protected int rowTimeIndex = 2;
    protected int rowKeyIndex = 0;
    protected RowDataKeySelector rowKeySelector = HandwrittenSelectorUtil.getRowDataSelector(new int[]{this.rowKeyIndex}, this.inputRowType.toRowFieldTypes());
    protected RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(this.inputRowType.toRowFieldTypes(), new GenericRowRecordSortComparator(this.rowKeyIndex, this.inputRowType.toRowFieldTypes()[this.rowKeyIndex]));

    RowTimeDeduplicateFunctionTestBase() {
    }

    protected OneInputStreamOperatorTestHarness<RowData, RowData> createTestHarness(KeyedProcessOperator<RowData, RowData, RowData> operator) throws Exception {
        return new KeyedOneInputStreamOperatorTestHarness(operator, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
    }

    protected OneInputStreamOperatorTestHarness<RowData, RowData> createTestHarness(KeyedMapBundleOperator<RowData, RowData, RowData, RowData> operator) throws Exception {
        return new KeyedOneInputStreamOperatorTestHarness(operator, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
    }
}

