/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.flink.table.runtime.generated.CompileUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codehaus.janino.ExpressionEvaluator;
import org.junit.Before;
import org.junit.Test;

public class CompileUtilsTest {
    @Before
    public void before() {
        CompileUtils.COMPILED_CLASS_CACHE.invalidateAll();
        CompileUtils.COMPILED_EXPRESSION_CACHE.invalidateAll();
    }

    @Test
    public void testCacheReuse() {
        String code = "public class Main {\n  int i;\n  int j;\n}";
        Class class1 = CompileUtils.compile((ClassLoader)this.getClass().getClassLoader(), (String)"Main", (String)code);
        Class class2 = CompileUtils.compile((ClassLoader)this.getClass().getClassLoader(), (String)"Main", (String)code);
        Class class3 = CompileUtils.compile((ClassLoader)new TestClassLoader(), (String)"Main", (String)code);
        Assertions.assertThat((Class)class2).isSameAs((Object)class1);
        Assertions.assertThat((Class)class3).isNotSameAs((Object)class1);
    }

    @Test
    public void testExpressionCacheReuse() {
        String code = "a + b";
        ExpressionEvaluator evaluator1 = CompileUtils.compileExpression((String)code, Arrays.asList("a", "b"), Arrays.asList(Integer.class, Integer.class), Integer.class);
        ExpressionEvaluator evaluator2 = CompileUtils.compileExpression((String)code, Arrays.asList("a", "b"), Arrays.asList(Integer.class, Integer.class), Integer.class);
        ExpressionEvaluator evaluator3 = CompileUtils.compileExpression((String)code, Arrays.asList("a", "b"), Arrays.asList(String.class, String.class), String.class);
        Assertions.assertThat((Object)evaluator2).isSameAs((Object)evaluator1);
        Assertions.assertThat((Object)evaluator3).isNotSameAs((Object)evaluator1);
    }

    @Test
    public void testWrongCode() {
        String code = "public class111 Main {\n  int i;\n  int j;\n}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CompileUtils.compile((ClassLoader)this.getClass().getClassLoader(), (String)"Main", (String)code)).isInstanceOf(FlinkRuntimeException.class)).hasMessageContaining("Table program cannot be compiled. This is a bug. Please file an issue.");
    }

    private static class TestClassLoader
    extends URLClassLoader {
        TestClassLoader() {
            super(new URL[0], Thread.currentThread().getContextClassLoader());
        }
    }
}

