/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.bundle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.operators.join.stream.bundle.BufferBundle;

public class JoinKeyContainsUniqueKeyBundle
extends BufferBundle<List<RowData>> {
    @Override
    public int addRecord(RowData joinKey, @Nullable RowData uniqueKey, RowData record) {
        this.bundle.computeIfAbsent(joinKey, key -> new ArrayList());
        if (!this.foldRecord(joinKey, record)) {
            ++this.actualSize;
            this.bundle.computeIfAbsent(joinKey, key -> new ArrayList()).add(record);
        }
        return ++this.count;
    }

    @Override
    public Map<RowData, List<RowData>> getRecords() throws Exception {
        return this.bundle;
    }

    @Override
    public Map<RowData, List<RowData>> getRecordsWithJoinKey(RowData joinKey) {
        throw new UnsupportedOperationException("JoinKeyContainsUniqueKeyBundle do not support getRecordsWithJoinKey() function.");
    }

    private boolean foldRecord(RowData joinKey, RowData record) {
        Optional lastElement;
        List list = (List)this.bundle.get(joinKey);
        boolean shouldFoldRecord = false;
        Optional<Object> optional = lastElement = list.isEmpty() ? Optional.empty() : Optional.of(list.get(list.size() - 1));
        if (lastElement.isPresent()) {
            RowData last = (RowData)lastElement.get();
            if (RowDataUtil.isAccumulateMsg(last)) {
                if (RowDataUtil.isRetractMsg(record)) {
                    shouldFoldRecord = true;
                }
                --this.actualSize;
                list.remove(list.size() - 1);
                if (list.isEmpty() && shouldFoldRecord) {
                    this.bundle.remove(joinKey);
                }
            } else if (RowDataUtil.isRetractMsg(record)) {
                --this.actualSize;
                list.remove(list.size() - 1);
            }
        }
        return shouldFoldRecord;
    }
}

