/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.operators.sort.SortUtil;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SortUtilTest {
    @Test
    public void testNormalizedKey() {
        int i;
        int i2;
        int len = 10;
        Random random = new Random();
        MemorySegment[] segments = new MemorySegment[len];
        MemorySegment[] compareSegs = new MemorySegment[len];
        for (i2 = 0; i2 < len; ++i2) {
            segments[i2] = MemorySegmentFactory.allocateUnpooledSegment((int)20);
            compareSegs[i2] = MemorySegmentFactory.allocateUnpooledSegment((int)20);
        }
        SortUtil.minNormalizedKey((MemorySegment)segments[0], (int)0, (int)20);
        SortUtil.maxNormalizedKey((MemorySegment)segments[1], (int)0, (int)20);
        for (i2 = 0; i2 < len; ++i2) {
            byte[] rndBytes = new byte[20];
            random.nextBytes(rndBytes);
            segments[2].put(0, rndBytes);
            Assertions.assertThat((int)segments[0].compare(segments[2], 0, 0, 20)).isLessThanOrEqualTo(0);
            Assertions.assertThat((int)segments[1].compare(segments[2], 0, 0, 20)).isGreaterThanOrEqualTo(0);
        }
        Object[] arr = new DecimalData[len];
        for (i = 0; i < len; ++i) {
            arr[i] = DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(random.nextInt()), (int)18, (int)0);
            SortUtil.putDecimalNormalizedKey((DecimalData)arr[i], (MemorySegment)segments[i], (int)0, (int)8);
        }
        Arrays.sort(arr, DecimalData::compareTo);
        for (i = 0; i < len; ++i) {
            SortUtil.putDecimalNormalizedKey((DecimalData)arr[i], (MemorySegment)compareSegs[i], (int)0, (int)8);
        }
        Arrays.sort(segments, (o1, o2) -> o1.compare(o2, 0, 0, 8));
        for (i = 0; i < len; ++i) {
            Assertions.assertThat((boolean)compareSegs[i].equalTo(segments[i], 0, 0, 8)).isTrue();
        }
        arr = new Float[len];
        for (i = 0; i < len; ++i) {
            arr[i] = Float.valueOf(random.nextFloat());
            SortUtil.putFloatNormalizedKey((float)arr[i].floatValue(), (MemorySegment)segments[i], (int)0, (int)4);
        }
        Arrays.sort(arr, Float::compareTo);
        for (i = 0; i < len; ++i) {
            SortUtil.putFloatNormalizedKey((float)arr[i].floatValue(), (MemorySegment)compareSegs[i], (int)0, (int)4);
        }
        Arrays.sort(segments, (o1, o2) -> o1.compare(o2, 0, 0, 4));
        for (i = 0; i < len; ++i) {
            Assertions.assertThat((boolean)compareSegs[i].equalTo(segments[i], 0, 0, 4)).isTrue();
        }
        arr = new Double[len];
        for (i = 0; i < len; ++i) {
            arr[i] = Double.valueOf(random.nextDouble());
            SortUtil.putDoubleNormalizedKey((double)arr[i].doubleValue(), (MemorySegment)segments[i], (int)0, (int)8);
        }
        Arrays.sort(arr, Double::compareTo);
        for (i = 0; i < len; ++i) {
            SortUtil.putDoubleNormalizedKey((double)arr[i].doubleValue(), (MemorySegment)compareSegs[i], (int)0, (int)8);
        }
        Arrays.sort(segments, (o1, o2) -> o1.compare(o2, 0, 0, 8));
        for (i = 0; i < len; ++i) {
            Assertions.assertThat((boolean)compareSegs[i].equalTo(segments[i], 0, 0, 8)).isTrue();
        }
        arr = new BinaryStringData[len];
        for (i = 0; i < len; ++i) {
            arr[i] = BinaryStringData.fromString((String)String.valueOf(random.nextLong()));
            SortUtil.putStringNormalizedKey((StringData)arr[i], (MemorySegment)segments[i], (int)0, (int)8);
        }
        Arrays.sort(arr, Comparable::compareTo);
        for (i = 0; i < len; ++i) {
            SortUtil.putStringNormalizedKey((StringData)arr[i], (MemorySegment)compareSegs[i], (int)0, (int)8);
        }
        Arrays.sort(segments, (o1, o2) -> o1.compare(o2, 0, 0, 8));
        for (i = 0; i < len; ++i) {
            Assertions.assertThat((boolean)compareSegs[i].equalTo(segments[i], 0, 0, 8)).isTrue();
        }
    }
}

