/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.over.RowTimeOverWindowTestBase;
import org.apache.flink.table.runtime.operators.over.RowTimeRowsBoundedPrecedingFunction;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RowTimeRowsBoundedPrecedingFunctionTest
extends RowTimeOverWindowTestBase {
    @Test
    public void testLateRecordMetrics() throws Exception {
        RowTimeRowsBoundedPrecedingFunction function = new RowTimeRowsBoundedPrecedingFunction(1000L, 2000L, aggsHandleFunction, this.accTypes, this.inputFieldTypes, 2000L, 2);
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)function);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness((KeyedProcessOperator<RowData, RowData, RowData>)operator);
        testHarness.open();
        Counter counter = function.getCounter();
        testHarness.processElement(StreamRecordUtils.insertRecord("key", 1L, 100L));
        testHarness.processElement(StreamRecordUtils.insertRecord("key", 1L, 100L));
        testHarness.processElement(StreamRecordUtils.insertRecord("key", 1L, 500L));
        testHarness.processWatermark(new Watermark(500L));
        testHarness.processElement(StreamRecordUtils.insertRecord("key", 1L, 400L));
        Assertions.assertThat((long)counter.getCount()).isEqualTo(1L);
    }
}

