/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.output;

import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.operators.multipleinput.MultipleInputTestBase;
import org.apache.flink.table.runtime.operators.multipleinput.TestingOneInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.TestingTwoInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.output.BroadcastingOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingBroadcastingOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingFirstInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingOneInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.CopyingSecondInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.FirstInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.OneInputStreamOperatorOutput;
import org.apache.flink.table.runtime.operators.multipleinput.output.SecondInputOfTwoInputStreamOperatorOutput;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OutputTest
extends MultipleInputTestBase {
    private StreamRecord<RowData> element;
    private Watermark watermark;
    private LatencyMarker latencyMarker;
    private TypeSerializer<RowData> serializer;

    @Before
    public void setup() {
        this.element = new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"123")}), 456L);
        this.watermark = new Watermark(1223456789L);
        this.latencyMarker = new LatencyMarker(122345678L, new OperatorID(123L, 456L), 1);
        this.serializer = InternalTypeInfo.of((RowType)RowType.of((LogicalType[])new LogicalType[]{DataTypes.STRING().getLogicalType()})).createSerializer((SerializerConfig)new SerializerConfigImpl());
    }

    @Test
    public void testOneInput() throws Exception {
        TestingOneInputStreamOperator op = this.createOneInputStreamOperator();
        OneInputStreamOperatorOutput output = new OneInputStreamOperatorOutput((OneInputStreamOperator)op);
        output.collect(this.element);
        Assertions.assertThat(op.getCurrentElement()).isEqualTo(this.element);
        output.emitWatermark(this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark()).isEqualTo((Object)this.watermark);
        output.emitLatencyMarker(this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker()).isEqualTo((Object)this.latencyMarker);
    }

    @Test
    public void testCopyingOneInput() throws Exception {
        TestingOneInputStreamOperator op = this.createOneInputStreamOperator();
        CopyingOneInputStreamOperatorOutput output = new CopyingOneInputStreamOperatorOutput((OneInputStreamOperator)op, this.serializer);
        output.collect(this.element);
        Assertions.assertThat(op.getCurrentElement()).isNotSameAs(this.element);
        Assertions.assertThat(op.getCurrentElement()).isEqualTo(this.element);
        output.emitWatermark(this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark()).isSameAs((Object)this.watermark);
        output.emitLatencyMarker(this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker()).isSameAs((Object)this.latencyMarker);
    }

    @Test
    public void testFirstInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        FirstInputOfTwoInputStreamOperatorOutput output = new FirstInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator)op);
        output.collect(this.element);
        Assertions.assertThat(op.getCurrentElement1()).isEqualTo(this.element);
        Assertions.assertThat(op.getCurrentElement2()).isNull();
        output.emitWatermark(this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark1()).isEqualTo((Object)this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark2()).isNull();
        output.emitLatencyMarker(this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker1()).isEqualTo((Object)this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker2()).isNull();
    }

    @Test
    public void testCopyingFirstInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        CopyingFirstInputOfTwoInputStreamOperatorOutput output = new CopyingFirstInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator)op, this.serializer);
        output.collect(this.element);
        Assertions.assertThat(op.getCurrentElement1()).isNotSameAs(this.element);
        Assertions.assertThat(op.getCurrentElement1()).isEqualTo(this.element);
        Assertions.assertThat(op.getCurrentElement2()).isNull();
        output.emitWatermark(this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark1()).isSameAs((Object)this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark2()).isNull();
        output.emitLatencyMarker(this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker1()).isSameAs((Object)this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker2()).isNull();
    }

    @Test
    public void testSecondInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        SecondInputOfTwoInputStreamOperatorOutput output = new SecondInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator)op);
        output.collect(this.element);
        Assertions.assertThat(op.getCurrentElement2()).isEqualTo(this.element);
        Assertions.assertThat(op.getCurrentElement1()).isNull();
        output.emitWatermark(this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark2()).isEqualTo((Object)this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark1()).isNull();
        output.emitLatencyMarker(this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker2()).isEqualTo((Object)this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker1()).isNull();
    }

    @Test
    public void testCopyingSecondInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        CopyingSecondInputOfTwoInputStreamOperatorOutput output = new CopyingSecondInputOfTwoInputStreamOperatorOutput((TwoInputStreamOperator)op, this.serializer);
        output.collect(this.element);
        Assertions.assertThat(op.getCurrentElement2()).isNotSameAs(this.element);
        Assertions.assertThat(op.getCurrentElement2()).isEqualTo(this.element);
        Assertions.assertThat(op.getCurrentElement1()).isNull();
        output.emitWatermark(this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark2()).isSameAs((Object)this.watermark);
        Assertions.assertThat((Object)op.getCurrentWatermark1()).isNull();
        output.emitLatencyMarker(this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker2()).isSameAs((Object)this.latencyMarker);
        Assertions.assertThat((Object)op.getCurrentLatencyMarker1()).isNull();
    }

    @Test
    public void testBroadcasting() throws Exception {
        TestingOneInputStreamOperator op1 = this.createOneInputStreamOperator();
        TestingOneInputStreamOperator op2 = this.createOneInputStreamOperator();
        BroadcastingOutput output = new BroadcastingOutput(new Output[]{new OneInputStreamOperatorOutput((OneInputStreamOperator)op1), new OneInputStreamOperatorOutput((OneInputStreamOperator)op2)});
        output.collect(this.element);
        Assertions.assertThat(op1.getCurrentElement()).isEqualTo(this.element);
        Assertions.assertThat(op2.getCurrentElement()).isEqualTo(this.element);
        output.emitWatermark(this.watermark);
        Assertions.assertThat((Object)op1.getCurrentWatermark()).isEqualTo((Object)this.watermark);
        Assertions.assertThat((Object)op2.getCurrentWatermark()).isEqualTo((Object)this.watermark);
        output.emitLatencyMarker(this.latencyMarker);
        if (op1.getCurrentLatencyMarker() != null) {
            Assertions.assertThat((Object)op1.getCurrentLatencyMarker()).isEqualTo((Object)this.latencyMarker);
            Assertions.assertThat((Object)op2.getCurrentLatencyMarker()).isNull();
        } else {
            Assertions.assertThat((Object)op2.getCurrentLatencyMarker()).isEqualTo((Object)this.latencyMarker);
        }
    }

    @Test
    public void testCopyingBroadcasting() throws Exception {
        TestingOneInputStreamOperator op1 = this.createOneInputStreamOperator();
        TestingOneInputStreamOperator op2 = this.createOneInputStreamOperator();
        CopyingBroadcastingOutput output = new CopyingBroadcastingOutput(new Output[]{new OneInputStreamOperatorOutput((OneInputStreamOperator)op1), new OneInputStreamOperatorOutput((OneInputStreamOperator)op2)});
        output.collect(this.element);
        Assertions.assertThat(op1.getCurrentElement()).isNotSameAs(this.element);
        Assertions.assertThat(op1.getCurrentElement()).isEqualTo(this.element);
        Assertions.assertThat(op2.getCurrentElement()).isSameAs(this.element);
        output.emitWatermark(this.watermark);
        Assertions.assertThat((Object)op1.getCurrentWatermark()).isSameAs((Object)this.watermark);
        Assertions.assertThat((Object)op2.getCurrentWatermark()).isSameAs((Object)this.watermark);
        output.emitLatencyMarker(this.latencyMarker);
        if (op1.getCurrentLatencyMarker() != null) {
            Assertions.assertThat((Object)op1.getCurrentLatencyMarker()).isSameAs((Object)this.latencyMarker);
            Assertions.assertThat((Object)op2.getCurrentLatencyMarker()).isNull();
        } else {
            Assertions.assertThat((Object)op2.getCurrentLatencyMarker()).isSameAs((Object)this.latencyMarker);
        }
    }
}

