/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggregate.hyperloglog;

import java.util.HashSet;
import java.util.Random;
import java.util.function.Function;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.runtime.functions.aggregate.hyperloglog.HllBuffer;
import org.apache.flink.table.runtime.functions.aggregate.hyperloglog.HyperLogLogPlusPlus;
import org.apache.flink.table.runtime.functions.aggregate.hyperloglog.XXH64;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class HyperLogLogPlusPlusTest {
    @Test
    public void testInvalidRelativeSD() {
        Assertions.assertThatThrownBy(() -> new HyperLogLogPlusPlus(0.4)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(IllegalArgumentException.class, (String)"HLL++ requires at least 4 bits for addressing. Use a lower error, at most 39%.")});
    }

    @Test
    public void testInputAllNulls() {
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus(0.01);
        HllBuffer buffer = this.createHllBuffer(hll);
        long estimate = hll.query(buffer);
        Assertions.assertThat((long)estimate).isEqualTo(0L);
    }

    @Test
    public void testDeterministicCardinalityEstimation() {
        int repeats = 10;
        this.testCardinalityEstimates(new double[]{0.1, 0.05, 0.025, 0.01, 0.001}, new int[]{100, 500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000}, i -> i / repeats, i -> i / repeats);
    }

    @Test
    public void testMerge() {
        int i;
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus(0.05);
        HllBuffer buffer1a = this.createHllBuffer(hll);
        HllBuffer buffer1b = this.createHllBuffer(hll);
        HllBuffer buffer2 = this.createHllBuffer(hll);
        for (i = 0; i < 500000; ++i) {
            hll.updateByHashcode(buffer1a, XXH64.hashInt((int)i, (long)42L));
        }
        for (i = 500000; i < 1000000; ++i) {
            hll.updateByHashcode(buffer1b, XXH64.hashInt((int)i, (long)42L));
        }
        hll.merge(buffer1a, buffer1b);
        for (i = 999999; i >= 0; --i) {
            hll.updateByHashcode(buffer2, XXH64.hashInt((int)i, (long)42L));
        }
        Assertions.assertThat((long[])buffer2.array).isEqualTo((Object)buffer1a.array);
    }

    @Test
    public void testRandomCardinalityEstimation() {
        Random srng = new Random(323981238L);
        HashSet seen = new HashSet();
        Function<Integer, Integer> update = i -> {
            int value = srng.nextInt();
            seen.add(value);
            return value;
        };
        Function<Integer, Integer> eval = n -> {
            int cardinality = seen.size();
            seen.clear();
            return cardinality;
        };
        this.testCardinalityEstimates(new double[]{0.05, 0.01}, new int[]{100, 10000, 500000}, update, eval);
    }

    @Test
    public void testPositiveAndNegativeZero() {
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus(0.05);
        HllBuffer buffer = this.createHllBuffer(hll);
        hll.updateByHashcode(buffer, XXH64.hashLong((long)Double.doubleToLongBits(0.0), (long)42L));
        hll.updateByHashcode(buffer, XXH64.hashLong((long)Double.doubleToLongBits(-0.0), (long)42L));
        long estimate = hll.query(buffer);
        double error = Math.abs((double)estimate - 1.0);
        Assertions.assertThat((error < hll.trueRsd() * 3.0 ? 1 : 0) != 0).isFalse();
    }

    @Test
    public void testNaN() {
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus(0.05);
        HllBuffer buffer = this.createHllBuffer(hll);
        hll.updateByHashcode(buffer, XXH64.hashLong((long)Double.doubleToLongBits(Double.NaN), (long)42L));
        long estimate = hll.query(buffer);
        double error = Math.abs((double)estimate - 1.0);
        Assertions.assertThat((error < hll.trueRsd() * 3.0 ? 1 : 0) != 0).isTrue();
    }

    private void testCardinalityEstimates(double[] rsds, int[] ns, Function<Integer, Integer> updateFun, Function<Integer, Integer> evalFun) {
        for (double rsd : rsds) {
            for (int n : ns) {
                int cardinality;
                HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus(rsd);
                HllBuffer buffer = this.createHllBuffer(hll);
                for (int i = 0; i < n; ++i) {
                    hll.updateByHashcode(buffer, XXH64.hashInt((int)updateFun.apply(i), (long)42L));
                }
                long estimate = hll.query(buffer);
                double error = Math.abs((double)estimate * 1.0 / (double)(cardinality = evalFun.apply(n).intValue()) - 1.0);
                Assertions.assertThat((error < hll.trueRsd() * 3.0 ? 1 : 0) != 0).isTrue();
            }
        }
    }

    public HllBuffer createHllBuffer(HyperLogLogPlusPlus hll) {
        HllBuffer buffer = new HllBuffer();
        buffer.array = new long[hll.getNumWords()];
        for (int word = 0; word < hll.getNumWords(); ++word) {
            buffer.array[word] = 0L;
        }
        return buffer;
    }
}

