/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.operators.sort.SortUtil;
import org.apache.flink.table.runtime.util.StringUtf8Utils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BinaryStringDataTest {
    private BinaryStringData empty = this.fromString("");
    private final Mode mode;

    public BinaryStringDataTest(Mode mode) {
        this.mode = mode;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Mode> getVarSeg() {
        return Arrays.asList(Mode.ONE_SEG, Mode.MULTI_SEGS, Mode.STRING, Mode.RANDOM);
    }

    private BinaryStringData fromString(String str) {
        BinaryStringData string = BinaryStringData.fromString((String)str);
        Mode mode = this.mode;
        if (mode == Mode.RANDOM) {
            int rnd = new Random().nextInt(3);
            if (rnd == 0) {
                mode = Mode.ONE_SEG;
            } else if (rnd == 1) {
                mode = Mode.MULTI_SEGS;
            } else if (rnd == 2) {
                mode = Mode.STRING;
            }
        }
        if (mode == Mode.STRING) {
            return string;
        }
        if (mode == Mode.ONE_SEG || string.getSizeInBytes() < 2) {
            string.ensureMaterialized();
            return string;
        }
        int numBytes = string.getSizeInBytes();
        int pad = new Random().nextInt(5);
        int numBytesWithPad = numBytes + pad;
        int segSize = numBytesWithPad / 2 + 1;
        byte[] bytes1 = new byte[segSize];
        byte[] bytes2 = new byte[segSize];
        if (segSize - pad > 0 && numBytes >= segSize - pad) {
            string.getSegments()[0].get(0, bytes1, pad, segSize - pad);
        }
        string.getSegments()[0].get(segSize - pad, bytes2, 0, numBytes - segSize + pad);
        return BinaryStringData.fromAddress((MemorySegment[])new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes1), MemorySegmentFactory.wrap((byte[])bytes2)}, (int)pad, (int)numBytes);
    }

    private void checkBasic(String str, int len) {
        BinaryStringData s1 = this.fromString(str);
        BinaryStringData s2 = BinaryStringData.fromBytes((byte[])str.getBytes(StandardCharsets.UTF_8));
        Assertions.assertThat((int)len).isEqualTo(s1.numChars());
        Assertions.assertThat((int)len).isEqualTo(s2.numChars());
        Assertions.assertThat((String)str).isEqualTo(s1.toString());
        Assertions.assertThat((String)str).isEqualTo(s2.toString());
        Assertions.assertThat((Comparable)s2).isEqualTo((Object)s1);
        Assertions.assertThat((int)s2.hashCode()).isEqualTo(s1.hashCode());
        Assertions.assertThat((int)s1.compareTo((StringData)s2)).isEqualTo(0);
        Assertions.assertThat((boolean)s1.contains(s2)).isTrue();
        Assertions.assertThat((boolean)s2.contains(s1)).isTrue();
        Assertions.assertThat((boolean)s1.startsWith(s1)).isTrue();
        Assertions.assertThat((boolean)s1.endsWith(s1)).isTrue();
    }

    @Test
    public void basicTest() {
        this.checkBasic("", 0);
        this.checkBasic(",", 1);
        this.checkBasic("hello", 5);
        this.checkBasic("hello world", 11);
        this.checkBasic("Flink\u4e2d\u6587\u793e\u533a", 9);
        this.checkBasic("\u4e2d \u6587 \u793e \u533a", 7);
        this.checkBasic("\u00a1", 1);
        this.checkBasic("\u043a\u0443", 2);
        this.checkBasic("\ufe3d\ufe4b\uff05", 3);
        this.checkBasic("\ud83e\udd19", 1);
    }

    @Test
    public void emptyStringTest() {
        Assertions.assertThat((Comparable)this.fromString("")).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringData.fromBytes((byte[])new byte[0])).isEqualTo((Object)this.empty);
        Assertions.assertThat((int)this.empty.numChars()).isEqualTo(0);
        Assertions.assertThat((int)this.empty.getSizeInBytes()).isEqualTo(0);
    }

    @Test
    public void compareTo() {
        Assertions.assertThat((int)this.fromString("   ").compareTo((StringData)BinaryStringData.blankString((int)3))).isEqualTo(0);
        Assertions.assertThat((int)this.fromString("").compareTo((StringData)this.fromString("a"))).isLessThan(0);
        Assertions.assertThat((int)this.fromString("abc").compareTo((StringData)this.fromString("ABC"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("abc0").compareTo((StringData)this.fromString("abc"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("abcabcabc").compareTo((StringData)this.fromString("abcabcabc"))).isEqualTo(0);
        Assertions.assertThat((int)this.fromString("aBcabcabc").compareTo((StringData)this.fromString("Abcabcabc"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("Abcabcabc").compareTo((StringData)this.fromString("abcabcabC"))).isLessThan(0);
        Assertions.assertThat((int)this.fromString("abcabcabc").compareTo((StringData)this.fromString("abcabcabC"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("abc").compareTo((StringData)this.fromString("\u4e16\u754c"))).isLessThan(0);
        Assertions.assertThat((int)this.fromString("\u4f60\u597d").compareTo((StringData)this.fromString("\u4e16\u754c"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("\u4f60\u597d123").compareTo((StringData)this.fromString("\u4f60\u597d122"))).isGreaterThan(0);
        MemorySegment segment1 = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        MemorySegment segment2 = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        SortUtil.putStringNormalizedKey((StringData)this.fromString("abcabcabc"), (MemorySegment)segment1, (int)0, (int)9);
        SortUtil.putStringNormalizedKey((StringData)this.fromString("abcabcabC"), (MemorySegment)segment2, (int)0, (int)9);
        Assertions.assertThat((int)segment1.compare(segment2, 0, 0, 9)).isGreaterThan(0);
        SortUtil.putStringNormalizedKey((StringData)this.fromString("abcab"), (MemorySegment)segment1, (int)0, (int)9);
        Assertions.assertThat((int)segment1.compare(segment2, 0, 0, 9)).isLessThan(0);
    }

    @Test
    public void testMultiSegments() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[10]), MemorySegmentFactory.wrap((byte[])new byte[10])};
        segments1[0].put(5, "abcde".getBytes(StandardCharsets.UTF_8), 0, 5);
        segments1[1].put(0, "aaaaa".getBytes(StandardCharsets.UTF_8), 0, 5);
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[5]), MemorySegmentFactory.wrap((byte[])new byte[5])};
        segments2[0].put(0, "abcde".getBytes(StandardCharsets.UTF_8), 0, 5);
        segments2[1].put(0, "b".getBytes(StandardCharsets.UTF_8), 0, 1);
        BinaryStringData binaryString1 = BinaryStringData.fromAddress((MemorySegment[])segments1, (int)5, (int)10);
        BinaryStringData binaryString2 = BinaryStringData.fromAddress((MemorySegment[])segments2, (int)0, (int)6);
        Assertions.assertThat((String)binaryString1.toString()).isEqualTo("abcdeaaaaa");
        Assertions.assertThat((String)binaryString2.toString()).isEqualTo("abcdeb");
        Assertions.assertThat((int)binaryString1.compareTo((StringData)binaryString2)).isEqualTo(-1);
        binaryString1 = BinaryStringData.fromAddress((MemorySegment[])segments1, (int)5, (int)5);
        binaryString2 = BinaryStringData.fromAddress((MemorySegment[])segments2, (int)0, (int)5);
        Assertions.assertThat((String)binaryString1.toString()).isEqualTo("abcde");
        Assertions.assertThat((String)binaryString2.toString()).isEqualTo("abcde");
        Assertions.assertThat((int)binaryString1.compareTo((StringData)binaryString2)).isEqualTo(0);
        binaryString1 = BinaryStringData.fromAddress((MemorySegment[])segments1, (int)10, (int)5);
        binaryString2 = BinaryStringData.fromAddress((MemorySegment[])segments2, (int)0, (int)5);
        Assertions.assertThat((String)binaryString1.toString()).isEqualTo("aaaaa");
        Assertions.assertThat((String)binaryString2.toString()).isEqualTo("abcde");
        Assertions.assertThat((int)binaryString1.compareTo((StringData)binaryString2)).isEqualTo(-1);
        Assertions.assertThat((int)binaryString2.compareTo((StringData)binaryString1)).isEqualTo(1);
        segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[10])};
        segments2[0].put(4, "abcdeb".getBytes(StandardCharsets.UTF_8), 0, 6);
        binaryString1 = BinaryStringData.fromAddress((MemorySegment[])segments1, (int)5, (int)10);
        binaryString2 = BinaryStringData.fromAddress((MemorySegment[])segments2, (int)4, (int)6);
        Assertions.assertThat((String)binaryString1.toString()).isEqualTo("abcdeaaaaa");
        Assertions.assertThat((String)binaryString2.toString()).isEqualTo("abcdeb");
        Assertions.assertThat((int)binaryString1.compareTo((StringData)binaryString2)).isEqualTo(-1);
        Assertions.assertThat((int)binaryString2.compareTo((StringData)binaryString1)).isEqualTo(1);
    }

    @Test
    public void concatTest() {
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[0])).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{null})).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.empty})).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("ab")})).isEqualTo((Object)this.fromString("ab"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("a"), this.fromString("b")})).isEqualTo((Object)this.fromString("ab"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("a"), this.fromString("b"), this.fromString("c")})).isEqualTo((Object)this.fromString("abc"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("a"), null, this.fromString("c")})).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("a"), null, null})).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{null, null, null})).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("\u6570\u636e"), this.fromString("\u7816\u5934")})).isEqualTo((Object)this.fromString("\u6570\u636e\u7816\u5934"));
    }

    @Test
    public void concatWsTest() {
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs(null, (BinaryStringData[])new BinaryStringData[]{null})).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs(null, (BinaryStringData[])new BinaryStringData[]{this.fromString("a")})).isNull();
        BinaryStringData sep = this.fromString("\u54c8\u54c8");
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.empty})).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("ab")})).isEqualTo((Object)this.fromString("ab"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("a"), this.fromString("b")})).isEqualTo((Object)this.fromString("a\u54c8\u54c8b"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("a"), this.fromString("b"), this.fromString("c")})).isEqualTo((Object)this.fromString("a\u54c8\u54c8b\u54c8\u54c8c"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("a"), null, this.fromString("c")})).isEqualTo((Object)this.fromString("a\u54c8\u54c8c"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("a"), null, null})).isEqualTo((Object)this.fromString("a"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{null, null, null})).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("\u6570\u636e"), this.fromString("\u7816\u5934")})).isEqualTo((Object)this.fromString("\u6570\u636e\u54c8\u54c8\u7816\u5934"));
    }

    @Test
    public void contains() {
        Assertions.assertThat((boolean)this.empty.contains(this.empty)).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").contains(this.fromString("ello"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").contains(this.fromString("vello"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("hello").contains(this.fromString("hellooo"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u5343\u4e16\u754c"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u4e16\u5343"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u5927\u5343\u4e16\u754c\u597d"))).isFalse();
    }

    @Test
    public void startsWith() {
        Assertions.assertThat((boolean)this.empty.startsWith(this.empty)).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").startsWith(this.fromString("hell"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").startsWith(this.fromString("ell"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("hello").startsWith(this.fromString("hellooo"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u6570\u636e\u7816\u5934").startsWith(this.fromString("\u6570\u636e"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").startsWith(this.fromString("\u5343"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").startsWith(this.fromString("\u5927\u5343\u4e16\u754c\u597d"))).isFalse();
    }

    @Test
    public void endsWith() {
        Assertions.assertThat((boolean)this.empty.endsWith(this.empty)).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").endsWith(this.fromString("ello"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").endsWith(this.fromString("ellov"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("hello").endsWith(this.fromString("hhhello"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").endsWith(this.fromString("\u4e16\u754c"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").endsWith(this.fromString("\u4e16"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u6570\u636e\u7816\u5934").endsWith(this.fromString("\u6211\u7684\u6570\u636e\u7816\u5934"))).isFalse();
    }

    @Test
    public void substring() {
        Assertions.assertThat((Comparable)this.fromString("hello").substring(0, 0)).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)this.fromString("hello").substring(1, 3)).isEqualTo((Object)this.fromString("el"));
        Assertions.assertThat((Comparable)this.fromString("\u6570\u636e\u7816\u5934").substring(0, 1)).isEqualTo((Object)this.fromString("\u6570"));
        Assertions.assertThat((Comparable)this.fromString("\u6570\u636e\u7816\u5934").substring(1, 3)).isEqualTo((Object)this.fromString("\u636e\u7816"));
        Assertions.assertThat((Comparable)this.fromString("\u6570\u636e\u7816\u5934").substring(3, 5)).isEqualTo((Object)this.fromString("\u5934"));
        Assertions.assertThat((Comparable)this.fromString("\u07f5\u68b7").substring(0, 2)).isEqualTo((Object)this.fromString("\u07f5\u68b7"));
    }

    @Test
    public void trims() {
        Assertions.assertThat((Comparable)this.fromString("1").trim()).isEqualTo((Object)this.fromString("1"));
        Assertions.assertThat((Comparable)this.fromString("  hello ").trim()).isEqualTo((Object)this.fromString("hello"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("  hello "))).isEqualTo((Object)this.fromString("hello "));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("  hello "))).isEqualTo((Object)this.fromString("  hello"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("  hello "), (boolean)false, (boolean)false, (BinaryStringData)this.fromString(" "))).isEqualTo((Object)this.fromString("  hello "));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("  hello "), (boolean)true, (boolean)true, (BinaryStringData)this.fromString(" "))).isEqualTo((Object)this.fromString("hello"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("  hello "), (boolean)true, (boolean)false, (BinaryStringData)this.fromString(" "))).isEqualTo((Object)this.fromString("hello "));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("  hello "), (boolean)false, (boolean)true, (BinaryStringData)this.fromString(" "))).isEqualTo((Object)this.fromString("  hello"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("xxxhellox"), (boolean)true, (boolean)true, (BinaryStringData)this.fromString("x"))).isEqualTo((Object)this.fromString("hello"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("xxxhellox"), (BinaryStringData)this.fromString("xoh"))).isEqualTo((Object)this.fromString("ell"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("xxxhellox"), (BinaryStringData)this.fromString("xoh"))).isEqualTo((Object)this.fromString("ellox"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("xxxhellox"), (BinaryStringData)this.fromString("xoh"))).isEqualTo((Object)this.fromString("xxxhell"));
        Assertions.assertThat((Comparable)this.empty.trim()).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)this.fromString("  ").trim()).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("  "))).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("  "))).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)this.fromString("  \u6570\u636e\u7816\u5934 ").trim()).isEqualTo((Object)this.fromString("\u6570\u636e\u7816\u5934"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("  \u6570\u636e\u7816\u5934 "))).isEqualTo((Object)this.fromString("\u6570\u636e\u7816\u5934 "));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("  \u6570\u636e\u7816\u5934 "))).isEqualTo((Object)this.fromString("  \u6570\u636e\u7816\u5934"));
        Assertions.assertThat((Comparable)this.fromString("\u6570\u636e\u7816\u5934").trim()).isEqualTo((Object)this.fromString("\u6570\u636e\u7816\u5934"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("\u6570\u636e\u7816\u5934"))).isEqualTo((Object)this.fromString("\u6570\u636e\u7816\u5934"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("\u6570\u636e\u7816\u5934"))).isEqualTo((Object)this.fromString("\u6570\u636e\u7816\u5934"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("\u5e74\u5e74\u5c81\u5c81, \u5c81\u5c81\u5e74\u5e74"), (BinaryStringData)this.fromString("\u5e74\u5c81 "))).isEqualTo((Object)this.fromString(","));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("\u5e74\u5e74\u5c81\u5c81, \u5c81\u5c81\u5e74\u5e74"), (BinaryStringData)this.fromString("\u5e74\u5c81 "))).isEqualTo((Object)this.fromString(", \u5c81\u5c81\u5e74\u5e74"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("\u5e74\u5e74\u5c81\u5c81, \u5c81\u5c81\u5e74\u5e74"), (BinaryStringData)this.fromString("\u5e74\u5c81 "))).isEqualTo((Object)this.fromString("\u5e74\u5e74\u5c81\u5c81,"));
        char[] charsLessThan0x20 = new char[10];
        Arrays.fill(charsLessThan0x20, '\u001f');
        String stringStartingWithSpace = new String(charsLessThan0x20) + "hello" + new String(charsLessThan0x20);
        Assertions.assertThat((Comparable)this.fromString(stringStartingWithSpace).trim()).isEqualTo((Object)this.fromString(stringStartingWithSpace));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString(stringStartingWithSpace))).isEqualTo((Object)this.fromString(stringStartingWithSpace));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString(stringStartingWithSpace))).isEqualTo((Object)this.fromString(stringStartingWithSpace));
    }

    @Test
    public void testSqlSubstring() {
        Assertions.assertThat((Comparable)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)2)).isEqualTo((Object)this.fromString("ello"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)2, (int)3)).isEqualTo((Object)this.fromString("ell"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.substringSQL((BinaryStringData)this.empty, (int)2, (int)3)).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)0, (int)-1)).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)10)).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)0, (int)3)).isEqualTo((Object)this.fromString("hel"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)-2, (int)3)).isEqualTo((Object)this.fromString("lo"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)-100, (int)3)).isEqualTo((Object)this.empty);
    }

    @Test
    public void reverseTest() {
        Assertions.assertThat((Comparable)BinaryStringDataUtil.reverse((BinaryStringData)this.fromString("hello"))).isEqualTo((Object)this.fromString("olleh"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.reverse((BinaryStringData)this.fromString("\u4e2d\u56fd"))).isEqualTo((Object)this.fromString("\u56fd\u4e2d"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.reverse((BinaryStringData)this.fromString("hello, \u4e2d\u56fd"))).isEqualTo((Object)this.fromString("\u56fd\u4e2d ,olleh"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.reverse((BinaryStringData)this.empty)).isEqualTo((Object)this.empty);
    }

    @Test
    public void indexOf() {
        Assertions.assertThat((int)this.empty.indexOf(this.empty, 0)).isEqualTo(0);
        Assertions.assertThat((int)this.empty.indexOf(this.fromString("l"), 0)).isEqualTo(-1);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.empty, 0)).isEqualTo(0);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("l"), 0)).isEqualTo(2);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("l"), 3)).isEqualTo(3);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("a"), 0)).isEqualTo(-1);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("ll"), 0)).isEqualTo(2);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("ll"), 4)).isEqualTo(-1);
        Assertions.assertThat((int)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u636e\u7816"), 0)).isEqualTo(1);
        Assertions.assertThat((int)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u6570"), 3)).isEqualTo(-1);
        Assertions.assertThat((int)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u6570"), 0)).isEqualTo(0);
        Assertions.assertThat((int)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u5934"), 0)).isEqualTo(3);
    }

    @Test
    public void testToNumeric() {
        Assertions.assertThat((byte)BinaryStringDataUtil.toByte((BinaryStringData)this.fromString("123"))).isEqualTo(Byte.parseByte("123"));
        Assertions.assertThat((byte)BinaryStringDataUtil.toByte((BinaryStringData)this.fromString("+123"))).isEqualTo(Byte.parseByte("123"));
        Assertions.assertThat((byte)BinaryStringDataUtil.toByte((BinaryStringData)this.fromString("-123"))).isEqualTo(Byte.parseByte("-123"));
        Assertions.assertThat((short)BinaryStringDataUtil.toShort((BinaryStringData)this.fromString("123"))).isEqualTo(Short.parseShort("123"));
        Assertions.assertThat((short)BinaryStringDataUtil.toShort((BinaryStringData)this.fromString("+123"))).isEqualTo(Short.parseShort("123"));
        Assertions.assertThat((short)BinaryStringDataUtil.toShort((BinaryStringData)this.fromString("-123"))).isEqualTo(Short.parseShort("-123"));
        Assertions.assertThat((int)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("123"))).isEqualTo(Integer.parseInt("123"));
        Assertions.assertThat((int)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("+123"))).isEqualTo(Integer.parseInt("123"));
        Assertions.assertThat((int)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("-123"))).isEqualTo(Integer.parseInt("-123"));
        Assertions.assertThat((long)BinaryStringDataUtil.toLong((BinaryStringData)this.fromString("1234567890"))).isEqualTo(Long.parseLong("1234567890"));
        Assertions.assertThat((long)BinaryStringDataUtil.toLong((BinaryStringData)this.fromString("+1234567890"))).isEqualTo(Long.parseLong("+1234567890"));
        Assertions.assertThat((long)BinaryStringDataUtil.toLong((BinaryStringData)this.fromString("-1234567890"))).isEqualTo(Long.parseLong("-1234567890"));
        Assertions.assertThat((int)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("123.456789"))).isEqualTo(Integer.parseInt("123"));
        Assertions.assertThat((long)BinaryStringDataUtil.toLong((BinaryStringData)this.fromString("123.456789"))).isEqualTo(Long.parseLong("123"));
        Assertions.assertThatThrownBy(() -> BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("1a3.456789"))).isInstanceOf(NumberFormatException.class);
        Assertions.assertThatThrownBy(() -> BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("123.a56789"))).isInstanceOf(NumberFormatException.class);
        BinaryRowData row = new BinaryRowData(20);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, (StringData)BinaryStringData.fromString((String)"1"));
        writer.writeString(1, (StringData)BinaryStringData.fromString((String)"123"));
        writer.writeString(2, (StringData)BinaryStringData.fromString((String)"12345"));
        writer.writeString(3, (StringData)BinaryStringData.fromString((String)"123456789"));
        writer.complete();
        Assertions.assertThat((byte)BinaryStringDataUtil.toByte((BinaryStringData)((BinaryStringData)row.getString(0)))).isEqualTo(Byte.parseByte("1"));
        Assertions.assertThat((short)BinaryStringDataUtil.toShort((BinaryStringData)((BinaryStringData)row.getString(1)))).isEqualTo(Short.parseShort("123"));
        Assertions.assertThat((int)BinaryStringDataUtil.toInt((BinaryStringData)((BinaryStringData)row.getString(2)))).isEqualTo(Integer.parseInt("12345"));
        Assertions.assertThat((long)BinaryStringDataUtil.toLong((BinaryStringData)((BinaryStringData)row.getString(3)))).isEqualTo(Long.parseLong("123456789"));
    }

    @Test
    public void testToUpperLowerCase() {
        Assertions.assertThat((Comparable)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba").toLowerCase()).isEqualTo((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"));
        Assertions.assertThat((Comparable)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba").toUpperCase()).isEqualTo((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"));
        Assertions.assertThat((Comparable)this.fromString("aBcDeFg").toLowerCase()).isEqualTo((Object)this.fromString("abcdefg"));
        Assertions.assertThat((Comparable)this.fromString("aBcDeFg").toUpperCase()).isEqualTo((Object)this.fromString("ABCDEFG"));
        Assertions.assertThat((Comparable)this.fromString("!@#$%^*").toLowerCase()).isEqualTo((Object)this.fromString("!@#$%^*"));
        Assertions.assertThat((Comparable)this.fromString("!@#$%^*").toLowerCase()).isEqualTo((Object)this.fromString("!@#$%^*"));
        BinaryRowData row = new BinaryRowData(20);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, (StringData)BinaryStringData.fromString((String)"a"));
        writer.writeString(1, (StringData)BinaryStringData.fromString((String)"\u6211\u662f\u4e2d\u56fd\u4eba"));
        writer.writeString(3, (StringData)BinaryStringData.fromString((String)"aBcDeFg"));
        writer.writeString(5, (StringData)BinaryStringData.fromString((String)"!@#$%^*"));
        writer.complete();
        Assertions.assertThat((Comparable)((BinaryStringData)row.getString(0)).toUpperCase()).isEqualTo((Object)this.fromString("A"));
        Assertions.assertThat((Comparable)((BinaryStringData)row.getString(1)).toUpperCase()).isEqualTo((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"));
        Assertions.assertThat((Comparable)((BinaryStringData)row.getString(1)).toLowerCase()).isEqualTo((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"));
        Assertions.assertThat((Comparable)((BinaryStringData)row.getString(3)).toUpperCase()).isEqualTo((Object)this.fromString("ABCDEFG"));
        Assertions.assertThat((Comparable)((BinaryStringData)row.getString(3)).toLowerCase()).isEqualTo((Object)this.fromString("abcdefg"));
        Assertions.assertThat((Comparable)((BinaryStringData)row.getString(5)).toUpperCase()).isEqualTo((Object)this.fromString("!@#$%^*"));
        Assertions.assertThat((Comparable)((BinaryStringData)row.getString(5)).toLowerCase()).isEqualTo((Object)this.fromString("!@#$%^*"));
    }

    @Test
    public void testToDecimal() {
        int i;
        class DecimalTestData {
            private String str;
            private int precision;
            private int scale;

            DecimalTestData(String str, int precision, int scale) {
                this.str = str;
                this.precision = precision;
                this.scale = scale;
            }
        }
        DecimalTestData[] data;
        for (DecimalTestData d : data = new DecimalTestData[]{new DecimalTestData("12.345", 5, 3), new DecimalTestData("-12.345", 5, 3), new DecimalTestData("+12345", 5, 0), new DecimalTestData("-12345", 5, 0), new DecimalTestData("12345.", 5, 0), new DecimalTestData("-12345.", 5, 0), new DecimalTestData(".12345", 5, 5), new DecimalTestData("-.12345", 5, 5), new DecimalTestData("+12.345E3", 5, 0), new DecimalTestData("-12.345e3", 5, 0), new DecimalTestData("12.345e-3", 6, 6), new DecimalTestData("-12.345E-3", 6, 6), new DecimalTestData("12345E3", 8, 0), new DecimalTestData("-12345e3", 8, 0), new DecimalTestData("12345e-3", 5, 3), new DecimalTestData("-12345E-3", 5, 3), new DecimalTestData("+.12345E3", 5, 2), new DecimalTestData("-.12345e3", 5, 2), new DecimalTestData(".12345e-3", 8, 8), new DecimalTestData("-.12345E-3", 8, 8), new DecimalTestData("1234512345.1234", 18, 8), new DecimalTestData("-1234512345.1234", 18, 8), new DecimalTestData("1234512345.1234", 12, 2), new DecimalTestData("-1234512345.1234", 12, 2), new DecimalTestData("1234512345.1299", 12, 2), new DecimalTestData("-1234512345.1299", 12, 2), new DecimalTestData("999999999999999999", 18, 0), new DecimalTestData("1234512345.1234512345", 20, 10), new DecimalTestData("-1234512345.1234512345", 20, 10), new DecimalTestData("1234512345.1234512345", 15, 5), new DecimalTestData("-1234512345.1234512345", 15, 5), new DecimalTestData("12345123451234512345E-10", 20, 10), new DecimalTestData("-12345123451234512345E-10", 20, 10), new DecimalTestData("12345123451234512345E-10", 15, 5), new DecimalTestData("-12345123451234512345E-10", 15, 5), new DecimalTestData("999999999999999999999", 21, 0), new DecimalTestData("-999999999999999999999", 21, 0), new DecimalTestData("0.00000000000000000000123456789123456789", 38, 38), new DecimalTestData("-0.00000000000000000000123456789123456789", 38, 38), new DecimalTestData("0.00000000000000000000123456789123456789", 29, 29), new DecimalTestData("-0.00000000000000000000123456789123456789", 29, 29), new DecimalTestData("123456789123E-27", 18, 18), new DecimalTestData("-123456789123E-27", 18, 18), new DecimalTestData("123456789999E-27", 18, 18), new DecimalTestData("-123456789999E-27", 18, 18), new DecimalTestData("123456789123456789E-36", 18, 18), new DecimalTestData("-123456789123456789E-36", 18, 18), new DecimalTestData("123456789999999999E-36", 18, 18), new DecimalTestData("-123456789999999999E-36", 18, 18)}) {
            Assertions.assertThat((Comparable)BinaryStringDataUtil.toDecimal((BinaryStringData)this.fromString(d.str), (int)d.precision, (int)d.scale)).isEqualTo((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(d.str), (int)d.precision, (int)d.scale));
        }
        BinaryRowData row = new BinaryRowData(data.length);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (i = 0; i < data.length; ++i) {
            writer.writeString(i, (StringData)BinaryStringData.fromString((String)data[i].str));
        }
        writer.complete();
        for (i = 0; i < data.length; ++i) {
            DecimalTestData d;
            d = data[i];
            Assertions.assertThat((Comparable)BinaryStringDataUtil.toDecimal((BinaryStringData)((BinaryStringData)row.getString(i)), (int)d.precision, (int)d.scale)).isEqualTo((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(d.str), (int)d.precision, (int)d.scale));
        }
    }

    @Test
    public void testEmptyString() {
        BinaryStringData str2 = this.fromString("hahahahah");
        MemorySegment[] segments = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[10]), MemorySegmentFactory.wrap((byte[])new byte[10])};
        BinaryStringData str3 = BinaryStringData.fromAddress((MemorySegment[])segments, (int)15, (int)0);
        Assertions.assertThat((int)BinaryStringData.EMPTY_UTF8.compareTo((StringData)str2)).isLessThan(0);
        Assertions.assertThat((int)str2.compareTo((StringData)BinaryStringData.EMPTY_UTF8)).isGreaterThan(0);
        Assertions.assertThat((int)BinaryStringData.EMPTY_UTF8.compareTo((StringData)str3)).isEqualTo(0);
        Assertions.assertThat((int)str3.compareTo((StringData)BinaryStringData.EMPTY_UTF8)).isEqualTo(0);
        Assertions.assertThat((Comparable)str2).isNotEqualTo((Object)BinaryStringData.EMPTY_UTF8);
        Assertions.assertThat((Comparable)BinaryStringData.EMPTY_UTF8).isNotEqualTo((Object)str2);
        Assertions.assertThat((Comparable)str3).isEqualTo((Object)BinaryStringData.EMPTY_UTF8);
        Assertions.assertThat((Comparable)BinaryStringData.EMPTY_UTF8).isEqualTo((Object)str3);
    }

    @Test
    public void testEncodeWithIllegalCharacter() throws UnsupportedEncodingException {
        char[] chars = new char[]{'\u4e9a', '\u9ebb', '|', '\u957f', '\u8896', '|', '\u8fde', '\u8863', '\u88d9', '|', '\ud83d', '|', '\udc57'};
        String str = new String(chars);
        Assertions.assertThat((byte[])StringUtf8Utils.encodeUTF8((String)str)).isEqualTo((Object)str.getBytes("UTF-8"));
    }

    @Test
    public void testKeyValue() {
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v1|k2:v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k3"))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v1|k2:v2|"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k3"))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("|k1:v1|k2:v2|"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k3"))).isNull();
        String tab = StringEscapeUtils.unescapeJava((String)"\t");
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v1" + tab + "k2:v2"), (byte)this.fromString("\t").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k2"))).isEqualTo((Object)this.fromString("v2"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v1|k2:v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), null)).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k2"))).isEqualTo((Object)this.fromString("v2"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("|k1=v1|k2=v2|"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k2"))).isEqualTo((Object)this.fromString("v2"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1||k2=v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k2"))).isEqualTo((Object)this.fromString("v2"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1;k2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k2"))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1"))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k=1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k="))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1==v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1"))).isEqualTo((Object)this.fromString("=v1"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1==v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1="))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1="))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1k1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1"))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1k1k1k1k1k1k1k1k1k1"))).isNull();
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v||k2:v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k2"))).isEqualTo((Object)this.fromString("v2"));
        Assertions.assertThat((Comparable)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v||k2:v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k2"))).isEqualTo((Object)this.fromString("v2"));
    }

    @Test
    public void testDecodeWithIllegalUtf8Bytes() throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{-102, -69, 124, 127, -106, 124, -34, 99, -39, 124, 61, 124, 87};
        String str = new String(bytes, StandardCharsets.UTF_8);
        Assertions.assertThat((String)StringUtf8Utils.decodeUTF8((byte[])bytes, (int)0, (int)bytes.length)).isEqualTo(str);
        Assertions.assertThat((String)StringUtf8Utils.decodeUTF8((MemorySegment)MemorySegmentFactory.wrap((byte[])bytes), (int)0, (int)bytes.length)).isEqualTo(str);
        byte[] newBytes = new byte[bytes.length + 5];
        System.arraycopy(bytes, 0, newBytes, 5, bytes.length);
        Assertions.assertThat((String)StringUtf8Utils.decodeUTF8((MemorySegment)MemorySegmentFactory.wrap((byte[])newBytes), (int)5, (int)bytes.length)).isEqualTo(str);
    }

    @Test
    public void skipWrongFirstByte() {
        int[] wrongFirstBytes = new int[]{128, 159, 191, 192, 194, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
        byte[] c = new byte[1];
        for (int wrongFirstByte : wrongFirstBytes) {
            c[0] = (byte)wrongFirstByte;
            Assertions.assertThat((int)1).isEqualTo(BinaryStringData.fromBytes((byte[])c).numChars());
        }
    }

    @Test
    public void testSplit() {
        Assertions.assertThat((Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString(""), (BinaryStringData)this.fromString(""))).isEqualTo((Object)BinaryStringDataUtil.EMPTY_STRING_ARRAY);
        Assertions.assertThat((Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString("ab de fg"), null)).isEqualTo((Object)new BinaryStringData[]{this.fromString("ab"), this.fromString("de"), this.fromString("fg")});
        Assertions.assertThat((Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString("ab   de fg"), null)).isEqualTo((Object)new BinaryStringData[]{this.fromString("ab"), this.fromString(""), this.fromString(""), this.fromString("de"), this.fromString("fg")});
        Assertions.assertThat((Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString("ab:cd:ef"), (BinaryStringData)this.fromString(":"))).isEqualTo((Object)new BinaryStringData[]{this.fromString("ab"), this.fromString("cd"), this.fromString("ef")});
        Assertions.assertThat((Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString("ab-!-cd-!-ef"), (BinaryStringData)this.fromString("-!-"))).isEqualTo((Object)new BinaryStringData[]{this.fromString("ab"), this.fromString("cd"), this.fromString("ef")});
    }

    @Test
    public void testLazy() {
        String javaStr = "haha";
        BinaryStringData str = BinaryStringData.fromString((String)javaStr);
        str.ensureMaterialized();
        Assertions.assertThat((String)javaStr).isSameAs((Object)str.toString());
    }

    private static enum Mode {
        ONE_SEG,
        MULTI_SEGS,
        STRING,
        RANDOM;

    }
}

