/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.util.CollectorOutput;
import org.apache.flink.streaming.util.MockStreamConfig;
import org.apache.flink.streaming.util.MockStreamTaskBuilder;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapper;
import org.apache.flink.table.runtime.operators.multipleinput.TestingOneInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.TestingTwoInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.output.BlackHoleOutput;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class MultipleInputTestBase {
    protected Transformation<RowData> createSource(StreamExecutionEnvironment env, String ... data) {
        return env.fromData((Collection)Arrays.stream(data).map(StringData::fromString).map(xva$0 -> GenericRowData.of((Object[])new Object[]{xva$0})).collect(Collectors.toList()), (TypeInformation)InternalTypeInfo.of((RowType)RowType.of((LogicalType[])new LogicalType[]{DataTypes.STRING().getLogicalType()}))).getTransformation();
    }

    protected TestingOneInputStreamOperator createOneInputStreamOperator() throws Exception {
        TestingOneInputStreamOperator op = new TestingOneInputStreamOperator();
        op.setup(this.createStreamTask(), this.createStreamConfig(), new BlackHoleOutput());
        return op;
    }

    protected TestingTwoInputStreamOperator createTwoInputStreamOperator() throws Exception {
        TestingTwoInputStreamOperator op = new TestingTwoInputStreamOperator();
        op.setup(this.createStreamTask(), this.createStreamConfig(), new BlackHoleOutput());
        return op;
    }

    protected OneInputTransformation<RowData, RowData> createOneInputTransform(Transformation<RowData> input, String name, TypeInformation<RowData> outputType) {
        return this.createOneInputTransform(input, name, new TestingOneInputStreamOperator(), outputType);
    }

    protected OneInputTransformation<RowData, RowData> createOneInputTransform(Transformation<RowData> input, String name, TestingOneInputStreamOperator operator, TypeInformation<RowData> outputType) {
        return new OneInputTransformation(input, name, (OneInputStreamOperator)operator, outputType, 10);
    }

    protected TwoInputTransformation<RowData, RowData, RowData> createTwoInputTransform(Transformation<RowData> input1, Transformation<RowData> input2, String name, TypeInformation<RowData> outputType) {
        return this.createTwoInputTransform(input1, input2, name, new TestingTwoInputStreamOperator(), outputType);
    }

    protected TwoInputTransformation<RowData, RowData, RowData> createTwoInputTransform(Transformation<RowData> input1, Transformation<RowData> input2, String name, TestingTwoInputStreamOperator operator, TypeInformation<RowData> outputType) {
        return new TwoInputTransformation(input1, input2, name, (TwoInputStreamOperator)operator, outputType, 10);
    }

    protected TableOperatorWrapper<TestingOneInputStreamOperator> createOneInputOperatorWrapper(TestingOneInputStreamOperator operator, String name) {
        return new TableOperatorWrapper((StreamOperatorFactory)SimpleOperatorFactory.of((StreamOperator)operator), name, Collections.singletonList(new RowTypeInfo(new TypeInformation[]{Types.STRING})), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.STRING}));
    }

    protected TableOperatorWrapper<TestingOneInputStreamOperator> createOneInputOperatorWrapper(String name) {
        return this.createOneInputOperatorWrapper(new TestingOneInputStreamOperator(), name);
    }

    protected TableOperatorWrapper<TestingTwoInputStreamOperator> createTwoInputOperatorWrapper(TestingTwoInputStreamOperator operator, String name) {
        return new TableOperatorWrapper((StreamOperatorFactory)SimpleOperatorFactory.of((StreamOperator)operator), name, Arrays.asList(new RowTypeInfo(new TypeInformation[]{Types.STRING}), new RowTypeInfo(new TypeInformation[]{Types.STRING})), (TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.STRING, Types.STRING}));
    }

    protected TableOperatorWrapper<TestingTwoInputStreamOperator> createTwoInputOperatorWrapper(String name) {
        return this.createTwoInputOperatorWrapper(new TestingTwoInputStreamOperator(), name);
    }

    protected StreamOperatorParameters<RowData> createStreamOperatorParameters() throws Exception {
        return this.createStreamOperatorParameters((CollectorOutput<RowData>)new CollectorOutput(new ArrayList()));
    }

    protected StreamConfig createStreamConfig() {
        return new MockStreamConfig(new Configuration(), 1);
    }

    protected StreamTask createStreamTask() throws Exception {
        MockEnvironment env = new MockEnvironmentBuilder().build();
        return new MockStreamTaskBuilder((Environment)env).build();
    }

    protected StreamOperatorParameters<RowData> createStreamOperatorParameters(CollectorOutput<RowData> output) throws Exception {
        return new StreamOperatorParameters(this.createStreamTask(), this.createStreamConfig(), output, TestProcessingTimeService::new, null);
    }
}

