/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.operators.aggregate.window.WindowAggOperatorBuilder;
import org.apache.flink.table.runtime.operators.aggregate.window.WindowAggOperatorTestBase;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAggOperator;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigners;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SlicingWindowAggOperatorTest
extends WindowAggOperatorTestBase {
    public SlicingWindowAggOperatorTest(ZoneId shiftTimeZone) {
        super(shiftTimeZone);
    }

    @Test
    public void testEventTimeHoppingWindows() throws Exception {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)2, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofSeconds(1L));
        SlicingSumAndCountAggsFunction aggsFunction = new SlicingSumAndCountAggsFunction((SliceAssigner)assigner);
        WindowAggOperator operator = WindowAggOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)INPUT_ROW_SER).shiftTimeZone(this.shiftTimeZone).keySerializer(KEY_SER).assigner((WindowAssigner)assigner).aggregate(SlicingWindowAggOperatorTest.createGeneratedAggsHandle(aggsFunction), (AbstractRowDataSerializer)ACC_SER).countStarIndex(1).build();
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup(OUT_SERIALIZER);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)3999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)3000L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)20L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)0L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1998L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1000L)));
        testHarness.processWatermark(new Watermark(999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, this.localMills(-2000L), this.localMills(1000L)));
        expectedOutput.add(new Watermark(999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(1999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, this.localMills(-1000L), this.localMills(2000L)));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, this.localMills(-1000L), this.localMills(2000L)));
        expectedOutput.add(new Watermark(1999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(2999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, this.localMills(0L), this.localMills(3000L)));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, this.localMills(0L), this.localMills(3000L)));
        expectedOutput.add(new Watermark(2999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.prepareSnapshotPreBarrier(0L);
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        ((AbstractIntegerAssert)Assertions.assertThat((int)aggsFunction.closeCalled.get()).as("Close was not called.", new Object[0])).isGreaterThan(0);
        expectedOutput.clear();
        testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup(OUT_SERIALIZER);
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processWatermark(new Watermark(3999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 5L, 5L, this.localMills(1000L), this.localMills(4000L)));
        expectedOutput.add(new Watermark(3999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)3500L)));
        testHarness.processWatermark(new Watermark(4999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, this.localMills(2000L), this.localMills(5000L)));
        expectedOutput.add(new Watermark(4999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)2999L)));
        testHarness.processWatermark(new Watermark(5999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, this.localMills(3000L), this.localMills(6000L)));
        expectedOutput.add(new Watermark(5999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(6999L));
        testHarness.processWatermark(new Watermark(7999L));
        expectedOutput.add(new Watermark(6999L));
        expectedOutput.add(new Watermark(7999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        Assertions.assertThat((long)operator.getNumLateRecordsDropped().getCount()).isEqualTo(1L);
        testHarness.close();
    }

    @Test
    public void testProcessingTimeHoppingWindows() throws Exception {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)-1, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(3L), (Duration)Duration.ofHours(1L));
        SlicingSumAndCountAggsFunction aggsFunction = new SlicingSumAndCountAggsFunction((SliceAssigner)assigner);
        WindowAggOperator operator = WindowAggOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)INPUT_ROW_SER).shiftTimeZone(this.shiftTimeZone).keySerializer(KEY_SER).assigner((WindowAssigner)assigner).aggregate(SlicingWindowAggOperatorTest.createGeneratedAggsHandle(aggsFunction), (AbstractRowDataSerializer)ACC_SER).countStarIndex(1).build();
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup(OUT_SERIALIZER);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T00:00:00.003"));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T01:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 1L, 1L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1969-12-31T22:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T01:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T02:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1969-12-31T23:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T02:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T03:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T03:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 2L, 2L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T03:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T07:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 2L, 2L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T01:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T04:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 5L, 5L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T01:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T04:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 5L, 5L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T02:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T05:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T03:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T06:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
        ((AbstractIntegerAssert)Assertions.assertThat((int)aggsFunction.closeCalled.get()).as("Close was not called.", new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testEventTimeCumulativeWindows() throws Exception {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)2, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofSeconds(1L));
        SlicingSumAndCountAggsFunction aggsFunction = new SlicingSumAndCountAggsFunction((SliceAssigner)assigner);
        WindowAggOperator operator = WindowAggOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)INPUT_ROW_SER).shiftTimeZone(this.shiftTimeZone).keySerializer(KEY_SER).assigner((WindowAssigner)assigner).aggregate(SlicingWindowAggOperatorTest.createGeneratedAggsHandle(aggsFunction), (AbstractRowDataSerializer)ACC_SER).build();
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup(OUT_SERIALIZER);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)2999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)3000L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)20L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)0L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1998L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1000L)));
        testHarness.processWatermark(new Watermark(999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, this.localMills(0L), this.localMills(1000L)));
        expectedOutput.add(new Watermark(999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(1999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, this.localMills(0L), this.localMills(2000L)));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, this.localMills(0L), this.localMills(2000L)));
        expectedOutput.add(new Watermark(1999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.prepareSnapshotPreBarrier(0L);
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        ((AbstractIntegerAssert)Assertions.assertThat((int)aggsFunction.closeCalled.get()).as("Close was not called.", new Object[0])).isGreaterThan(0);
        expectedOutput.clear();
        testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1000L)));
        testHarness.processWatermark(new Watermark(1999L));
        expectedOutput.add(new Watermark(1999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(2999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, this.localMills(0L), this.localMills(3000L)));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 5L, 5L, this.localMills(0L), this.localMills(3000L)));
        expectedOutput.add(new Watermark(2999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(3999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 1L, 1L, this.localMills(3000L), this.localMills(4000L)));
        expectedOutput.add(new Watermark(3999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 2, TimestampData.fromEpochMillis((long)3500L)));
        testHarness.processWatermark(new Watermark(4999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 1L, 1L, this.localMills(3000L), this.localMills(5000L)));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 2L, 1L, this.localMills(3000L), this.localMills(5000L)));
        expectedOutput.add(new Watermark(4999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)2999L)));
        testHarness.processWatermark(new Watermark(5999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 1L, 1L, this.localMills(3000L), this.localMills(6000L)));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 2L, 1L, this.localMills(3000L), this.localMills(6000L)));
        expectedOutput.add(new Watermark(5999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(6999L));
        testHarness.processWatermark(new Watermark(7999L));
        expectedOutput.add(new Watermark(6999L));
        expectedOutput.add(new Watermark(7999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        Assertions.assertThat((long)operator.getNumLateRecordsDropped().getCount()).isEqualTo(1L);
        testHarness.close();
    }

    @Test
    public void testProcessingTimeCumulativeWindows() throws Exception {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)-1, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofDays(1L), (Duration)Duration.ofHours(8L));
        SlicingSumAndCountAggsFunction aggsFunction = new SlicingSumAndCountAggsFunction((SliceAssigner)assigner);
        WindowAggOperator operator = WindowAggOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)INPUT_ROW_SER).shiftTimeZone(this.shiftTimeZone).keySerializer(KEY_SER).assigner((WindowAssigner)assigner).aggregate(SlicingWindowAggOperatorTest.createGeneratedAggsHandle(aggsFunction), (AbstractRowDataSerializer)ACC_SER).build();
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup(OUT_SERIALIZER);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T00:00:00.003"));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T08:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 1L, 1L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T08:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T16:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T16:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-02T00:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T00:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 2L, 2L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T00:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-03T08:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 2L, 2L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T08:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 1L, 1L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T08:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 2L, 2L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T16:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 1L, 1L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T16:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 2L, 2L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-03T00:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 1L, 1L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-02T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-03T00:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
        ((AbstractIntegerAssert)Assertions.assertThat((int)aggsFunction.closeCalled.get()).as("Close was not called.", new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testEventTimeTumblingWindows() throws Exception {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)2, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(3L));
        SlicingSumAndCountAggsFunction aggsFunction = new SlicingSumAndCountAggsFunction((SliceAssigner)assigner);
        WindowAggOperator operator = WindowAggOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)INPUT_ROW_SER).shiftTimeZone(this.shiftTimeZone).keySerializer(KEY_SER).assigner((WindowAssigner)assigner).aggregate(SlicingWindowAggOperatorTest.createGeneratedAggsHandle(aggsFunction), (AbstractRowDataSerializer)ACC_SER).build();
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup(OUT_SERIALIZER);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)3999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)3000L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)20L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)0L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1998L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1999L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)1000L)));
        testHarness.processWatermark(new Watermark(999L));
        expectedOutput.add(new Watermark(999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(1999L));
        expectedOutput.add(new Watermark(1999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.prepareSnapshotPreBarrier(0L);
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        ((AbstractIntegerAssert)Assertions.assertThat((int)aggsFunction.closeCalled.get()).as("Close was not called.", new Object[0])).isGreaterThan(0);
        expectedOutput.clear();
        testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processWatermark(new Watermark(2999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, this.localMills(0L), this.localMills(3000L)));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, this.localMills(0L), this.localMills(3000L)));
        expectedOutput.add(new Watermark(2999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(3999L));
        expectedOutput.add(new Watermark(3999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)2500L)));
        testHarness.processWatermark(new Watermark(4999L));
        expectedOutput.add(new Watermark(4999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)2999L)));
        testHarness.processWatermark(new Watermark(5999L));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 2L, 2L, this.localMills(3000L), this.localMills(6000L)));
        expectedOutput.add(new Watermark(5999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(6999L));
        testHarness.processWatermark(new Watermark(7999L));
        expectedOutput.add(new Watermark(6999L));
        expectedOutput.add(new Watermark(7999L));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        Assertions.assertThat((long)operator.getNumLateRecordsDropped().getCount()).isEqualTo(2L);
        testHarness.close();
    }

    @Test
    public void testProcessingTimeTumblingWindows() throws Exception {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)-1, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L));
        SlicingSumAndCountAggsFunction aggsFunction = new SlicingSumAndCountAggsFunction((SliceAssigner)assigner);
        WindowAggOperator operator = WindowAggOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)INPUT_ROW_SER).shiftTimeZone(this.shiftTimeZone).keySerializer(KEY_SER).assigner((WindowAssigner)assigner).aggregate(SlicingWindowAggOperatorTest.createGeneratedAggsHandle(aggsFunction), (AbstractRowDataSerializer)ACC_SER).build();
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = SlicingWindowAggOperatorTest.createTestHarness(operator);
        testHarness.setup(OUT_SERIALIZER);
        testHarness.open();
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T00:00:00.003"));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)Long.MAX_VALUE)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)7000L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key2", 1, TimestampData.fromEpochMillis((long)7000L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)7000L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)7000L)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T05:00:00"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key2", 3L, 3L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T05:00:00")));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 2L, 2L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T00:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T05:00:00")));
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)7000L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)7000L)));
        testHarness.processElement(StreamRecordUtils.insertRecord("key1", 1, TimestampData.fromEpochMillis((long)7000L)));
        testHarness.setProcessingTime(SlicingWindowAggOperatorTest.epochMills(this.shiftTimeZone, "1970-01-01T10:00:01"));
        expectedOutput.add(StreamRecordUtils.insertRecord("key1", 3L, 3L, SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T05:00:00"), SlicingWindowAggOperatorTest.epochMills(UTC_ZONE_ID, "1970-01-01T10:00:00")));
        Assertions.assertThat((Long)((Long)operator.getWatermarkLatency().getValue())).isEqualTo((Object)0L);
        ASSERTER.assertOutputEqualsSorted("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testInvalidWindows() {
        SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)2, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofSeconds(1L));
        SlicingSumAndCountAggsFunction aggsFunction = new SlicingSumAndCountAggsFunction((SliceAssigner)assigner);
        Assertions.assertThatThrownBy(() -> this.lambda$testInvalidWindows$0((SliceAssigner)assigner, aggsFunction)).hasMessageContaining("Hopping window requires a COUNT(*) in the aggregate functions.");
    }

    @Parameterized.Parameters(name="TimeZone = {0}")
    public static Collection<Object[]> runMode() {
        return Arrays.asList({UTC_ZONE_ID}, {SHANGHAI_ZONE_ID});
    }

    private /* synthetic */ void lambda$testInvalidWindows$0(SliceAssigner assigner, SlicingSumAndCountAggsFunction aggsFunction) throws Throwable {
        WindowAggOperatorBuilder.builder().inputSerializer((AbstractRowDataSerializer)INPUT_ROW_SER).shiftTimeZone(this.shiftTimeZone).keySerializer(KEY_SER).assigner((WindowAssigner)assigner).aggregate(SlicingWindowAggOperatorTest.createGeneratedAggsHandle(aggsFunction), (AbstractRowDataSerializer)ACC_SER).build();
    }

    protected static class SlicingSumAndCountAggsFunction
    extends WindowAggOperatorTestBase.SumAndCountAggsFunctionBase<Long> {
        private final SliceAssigner assigner;

        public SlicingSumAndCountAggsFunction(SliceAssigner assigner) {
            this.assigner = assigner;
        }

        @Override
        protected long getWindowStart(Long window) {
            return this.assigner.getWindowStart(window.longValue());
        }

        @Override
        protected long getWindowEnd(Long window) {
            return window;
        }
    }
}

