/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.formats.raw;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.raw.RawFormatDeserializationSchema;
import org.apache.flink.formats.raw.RawFormatSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class RawFormatSerDeSchemaTest {
    @Parameterized.Parameter
    public TestSpec testSpec;

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<TestSpec> testData() {
        return Arrays.asList(TestSpec.type(DataTypes.TINYINT()).values((byte)127).binary(new byte[][]{{127}}), TestSpec.type(DataTypes.SMALLINT()).values((short)Short.MAX_VALUE).binary(new byte[][]{StringUtils.hexStringToByte((String)"7fff")}), TestSpec.type(DataTypes.SMALLINT()).values((short)Short.MAX_VALUE).withLittleEndian().binary(new byte[][]{StringUtils.hexStringToByte((String)"ff7f")}), TestSpec.type(DataTypes.INT()).values(Integer.MAX_VALUE).binary(new byte[][]{StringUtils.hexStringToByte((String)"7fffffff")}), TestSpec.type(DataTypes.INT()).values(Integer.MAX_VALUE).withLittleEndian().binary(new byte[][]{StringUtils.hexStringToByte((String)"ffffff7f")}), TestSpec.type(DataTypes.BIGINT()).values(Long.MAX_VALUE).binary(new byte[][]{StringUtils.hexStringToByte((String)"7fffffffffffffff")}), TestSpec.type(DataTypes.BIGINT()).values(Long.MAX_VALUE).withLittleEndian().binary(new byte[][]{StringUtils.hexStringToByte((String)"ffffffffffffff7f")}), TestSpec.type(DataTypes.FLOAT()).values(Float.valueOf(Float.MAX_VALUE)).binary(new byte[][]{StringUtils.hexStringToByte((String)"7f7fffff")}), TestSpec.type(DataTypes.FLOAT()).values(Float.valueOf(Float.MAX_VALUE)).withLittleEndian().binary(new byte[][]{StringUtils.hexStringToByte((String)"ffff7f7f")}), TestSpec.type(DataTypes.DOUBLE()).values(Double.MAX_VALUE).binary(new byte[][]{StringUtils.hexStringToByte((String)"7fefffffffffffff")}), TestSpec.type(DataTypes.DOUBLE()).values(Double.MAX_VALUE).withLittleEndian().binary(new byte[][]{StringUtils.hexStringToByte((String)"ffffffffffffef7f")}), TestSpec.type(DataTypes.BOOLEAN()).values(true).binary(new byte[][]{{1}}), TestSpec.type(DataTypes.BOOLEAN()).values(false).binary(new byte[][]{{0}}), TestSpec.type(DataTypes.STRING()).values("Hello World").binary(new byte[][]{"Hello World".getBytes()}), TestSpec.type(DataTypes.STRING()).values("\u4f60\u597d\u4e16\u754c\uff0cHello World").binary(new byte[][]{"\u4f60\u597d\u4e16\u754c\uff0cHello World".getBytes()}), TestSpec.type(DataTypes.STRING()).values("Flink Awesome!").withCharset("UTF-16").binary(new byte[][]{"Flink Awesome!".getBytes(StandardCharsets.UTF_16)}), TestSpec.type(DataTypes.STRING()).values("Flink \u5e05\u54ed!").withCharset("UTF-16").binary(new byte[][]{"Flink \u5e05\u54ed!".getBytes(StandardCharsets.UTF_16)}), TestSpec.type(DataTypes.STRING()).values("").binary(new byte[][]{"".getBytes()}), TestSpec.type(DataTypes.VARCHAR((int)5)).values("HELLO").binary(new byte[][]{"HELLO".getBytes()}), TestSpec.type(DataTypes.STRING()).values("line 1", "line 2", "line 3").binary("line 1".getBytes(), "line 2".getBytes(), "line 3".getBytes()), TestSpec.type(DataTypes.BYTES()).values(new Object[]{new byte[]{1, 3, 5, 7, 9}}).binary(new byte[][]{{1, 3, 5, 7, 9}}), TestSpec.type(DataTypes.BYTES()).values(new Object[]{new byte[0]}).binary(new byte[][]{new byte[0]}), TestSpec.type(DataTypes.BINARY((int)3)).values(new Object[]{new byte[]{1, 3, 5}}).binary(new byte[][]{{1, 3, 5}}), TestSpec.type(DataTypes.RAW(LocalDateTime.class, (TypeSerializer)new LocalDateTimeSerializer())).values(LocalDateTime.parse("2020-11-11T18:08:01.123")).binary(new byte[][]{RawFormatSerDeSchemaTest.serializeLocalDateTime(LocalDateTime.parse("2020-11-11T18:08:01.123"))}), TestSpec.type(DataTypes.TINYINT()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.SMALLINT()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.INT()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.BIGINT()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.FLOAT()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.DOUBLE()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.BOOLEAN()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.STRING()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.BYTES()).values(new Object[]{null}).binary(new byte[][]{(byte[])null}), TestSpec.type(DataTypes.RAW(LocalDateTime.class, (TypeSerializer)new LocalDateTimeSerializer())).values(new Object[]{null}).binary(new byte[][]{(byte[])null}));
    }

    @Test
    public void testSerializationAndDeserialization() throws Exception {
        Row row;
        int i;
        RawFormatDeserializationSchema deserializationSchema = new RawFormatDeserializationSchema(this.testSpec.type.getLogicalType(), TypeInformation.of(RowData.class), this.testSpec.charsetName, this.testSpec.isBigEndian);
        RawFormatSerializationSchema serializationSchema = new RawFormatSerializationSchema(this.testSpec.type.getLogicalType(), this.testSpec.charsetName, this.testSpec.isBigEndian);
        deserializationSchema.open((DeserializationSchema.InitializationContext)Mockito.mock(DeserializationSchema.InitializationContext.class));
        serializationSchema.open((SerializationSchema.InitializationContext)Mockito.mock(SerializationSchema.InitializationContext.class));
        DataStructureConverter converter = DataStructureConverters.getConverter((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"single", (DataType)this.testSpec.type)}));
        byte[][] serializedBytesArr = new byte[this.testSpec.values.length][];
        RowData[] deserializedRowDataArr = new RowData[this.testSpec.values.length];
        for (i = 0; i < this.testSpec.values.length; ++i) {
            row = Row.of((Object[])new Object[]{this.testSpec.values[i]});
            RowData originalRowData = (RowData)converter.toInternal((Object)row);
            serializedBytesArr[i] = serializationSchema.serialize(originalRowData);
        }
        for (i = 0; i < this.testSpec.values.length; ++i) {
            Assertions.assertThat((byte[])serializedBytesArr[i]).isEqualTo((Object)this.testSpec.binary[i]);
            deserializedRowDataArr[i] = deserializationSchema.deserialize(serializedBytesArr[i]);
        }
        for (i = 0; i < this.testSpec.values.length; ++i) {
            row = Row.of((Object[])new Object[]{this.testSpec.values[i]});
            Row actual = (Row)converter.toExternal((Object)deserializedRowDataArr[i]);
            Assertions.assertThat((Object)actual).isEqualTo((Object)row);
        }
    }

    private static byte[] serializeLocalDateTime(LocalDateTime localDateTime) {
        DataOutputSerializer dos = new DataOutputSerializer(16);
        LocalDateTimeSerializer serializer = new LocalDateTimeSerializer();
        try {
            serializer.serialize(localDateTime, (DataOutputView)dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return dos.getCopyOfBuffer();
    }

    private static class TestSpec {
        private Object[] values;
        private byte[][] binary;
        private final DataType type;
        private String charsetName = "UTF-8";
        private boolean isBigEndian = true;

        private TestSpec(DataType type) {
            this.type = type;
        }

        public static TestSpec type(DataType fieldType) {
            return new TestSpec(fieldType);
        }

        public TestSpec values(Object ... values) {
            this.values = values;
            return this;
        }

        public TestSpec binary(byte[] ... bytes) {
            this.binary = bytes;
            return this;
        }

        public TestSpec withCharset(String charsetName) {
            this.charsetName = charsetName;
            return this;
        }

        public TestSpec withLittleEndian() {
            this.isBigEndian = false;
            return this;
        }

        public String toString() {
            ArrayList<String> hexes = new ArrayList<String>();
            for (byte[] b : this.binary) {
                hexes.add(b == null ? "" : "0x" + StringUtils.byteToHexString((byte[])b));
            }
            return "TestSpec{values=" + Arrays.toString(this.values) + ", binary=" + hexes + ", type=" + this.type + ", charsetName='" + this.charsetName + '\'' + ", isBigEndian=" + this.isBigEndian + '}';
        }
    }
}

