/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.assertj.core.api.Assertions;

public class SerializerTestUtil {
    public static <T> TypeSerializer<T> snapshotAndReconfigure(TypeSerializer<T> serializer, SerializerGetter<T> serializerGetter) throws IOException {
        TypeSerializer restoredSerializer;
        TypeSerializerSnapshot restoredConfig;
        byte[] serializedConfig;
        TypeSerializerSnapshot configSnapshot = serializer.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)configSnapshot);
            serializedConfig = out.toByteArray();
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            restoredConfig = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        TypeSerializerSchemaCompatibility strategy = serializerGetter.getSerializer().snapshotConfiguration().resolveSchemaCompatibility(restoredConfig);
        if (strategy.isCompatibleAsIs()) {
            restoredSerializer = restoredConfig.restoreSerializer();
        } else if (strategy.isCompatibleWithReconfiguredSerializer()) {
            restoredSerializer = strategy.getReconfiguredSerializer();
        } else {
            throw new AssertionError((Object)("Unable to restore serializer with " + strategy));
        }
        Assertions.assertThat(restoredSerializer.getClass()).isEqualTo(serializer.getClass());
        return restoredSerializer;
    }

    public static class MyObjSerializer
    extends Serializer<MyObj>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int delta = 7;

        public void write(Kryo kryo, Output output, MyObj myObj) {
            output.writeInt(myObj.getA() + 7);
            output.writeInt(myObj.getB() + 7);
        }

        public MyObj read(Kryo kryo, Input input, Class<MyObj> aClass) {
            int a = input.readInt() - 7;
            int b = input.readInt() - 7;
            return new MyObj(a, b);
        }

        public boolean equals(Object o) {
            return o instanceof MyObjSerializer;
        }
    }

    public static class MyObj {
        private int a;
        private int b;

        public MyObj(int a, int b) {
            this.a = a;
            this.b = b;
        }

        int getA() {
            return this.a;
        }

        int getB() {
            return this.b;
        }

        public boolean equals(Object o) {
            return o instanceof MyObj && ((MyObj)o).a == this.a && ((MyObj)o).b == this.b;
        }
    }

    public static interface SerializerGetter<T> {
        public TypeSerializer<T> getSerializer();
    }
}

