/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.interval;

import java.util.ArrayList;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.functions.co.KeyedCoProcessFunction;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.operators.co.KeyedCoProcessOperator;
import org.apache.flink.streaming.util.KeyedTwoInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.interval.ProcTimeIntervalJoin;
import org.apache.flink.table.runtime.operators.join.interval.TimeIntervalStreamJoinTestBase;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.HandwrittenSelectorUtil;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ProcTimeIntervalJoinTest
extends TimeIntervalStreamJoinTestBase {
    private int keyIdx = 0;
    private RowDataKeySelector keySelector = HandwrittenSelectorUtil.getRowDataSelector(new int[]{this.keyIdx}, this.rowType.toRowFieldTypes());
    private TypeInformation<RowData> keyType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[0]);

    @Test
    public void testProcTimeInnerJoinWithCommonBounds() throws Exception {
        ProcTimeIntervalJoin joinProcessFunc = new ProcTimeIntervalJoin(FlinkJoinType.INNER, -10L, 20L, 15L, this.rowType, this.rowType, this.joinFunction);
        KeyedTwoInputStreamOperatorTestHarness<RowData, RowData, RowData, RowData> testHarness = this.createTestHarness(joinProcessFunc);
        testHarness.open();
        testHarness.setProcessingTime(1L);
        testHarness.processElement1(StreamRecordUtils.insertRecord(1L, "1a1"));
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(1);
        testHarness.setProcessingTime(2L);
        testHarness.processElement1(StreamRecordUtils.insertRecord(2L, "2a2"));
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        testHarness.setProcessingTime(3L);
        testHarness.processElement1(StreamRecordUtils.insertRecord(1L, "1a3"));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        testHarness.processElement2(StreamRecordUtils.insertRecord(1L, "1b3"));
        testHarness.setProcessingTime(4L);
        testHarness.processElement2(StreamRecordUtils.insertRecord(2L, "2b4"));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(8);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(4);
        testHarness.setProcessingTime(13L);
        testHarness.processElement2(StreamRecordUtils.insertRecord(1L, "1b13"));
        testHarness.setProcessingTime(33L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        testHarness.processElement1(StreamRecordUtils.insertRecord(1L, "1a33"));
        testHarness.processElement1(StreamRecordUtils.insertRecord(2L, "2a33"));
        testHarness.processElement2(StreamRecordUtils.insertRecord(2L, "2b33"));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord(1L, "1a1", 1L, "1b3"));
        expectedOutput.add(StreamRecordUtils.insertRecord(1L, "1a3", 1L, "1b3"));
        expectedOutput.add(StreamRecordUtils.insertRecord(2L, "2a2", 2L, "2b4"));
        expectedOutput.add(StreamRecordUtils.insertRecord(1L, "1a3", 1L, "1b13"));
        expectedOutput.add(StreamRecordUtils.insertRecord(1L, "1a33", 1L, "1b13"));
        expectedOutput.add(StreamRecordUtils.insertRecord(2L, "2a33", 2L, "2b33"));
        this.assertor.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testProcTimeInnerJoinWithNegativeBounds() throws Exception {
        ProcTimeIntervalJoin joinProcessFunc = new ProcTimeIntervalJoin(FlinkJoinType.INNER, -10L, -5L, 2L, this.rowType, this.rowType, this.joinFunction);
        KeyedTwoInputStreamOperatorTestHarness<RowData, RowData, RowData, RowData> testHarness = this.createTestHarness(joinProcessFunc);
        testHarness.open();
        testHarness.setProcessingTime(1L);
        testHarness.processElement1(StreamRecordUtils.insertRecord(1L, "1a1"));
        testHarness.setProcessingTime(2L);
        testHarness.processElement1(StreamRecordUtils.insertRecord(2L, "2a2"));
        testHarness.setProcessingTime(3L);
        testHarness.processElement1(StreamRecordUtils.insertRecord(1L, "1a3"));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        testHarness.processElement2(StreamRecordUtils.insertRecord(1L, "1b3"));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        testHarness.setProcessingTime(7L);
        testHarness.processElement2(StreamRecordUtils.insertRecord(2L, "2b7"));
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        testHarness.setProcessingTime(12L);
        testHarness.processElement2(StreamRecordUtils.insertRecord(1L, "1b12"));
        testHarness.setProcessingTime(13L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(4);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        testHarness.setProcessingTime(14L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(1);
        testHarness.setProcessingTime(16L);
        Assertions.assertThat((int)testHarness.numKeyedStateEntries()).isEqualTo(0);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(0);
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord(2L, "2a2", 2L, "2b7"));
        expectedOutput.add(StreamRecordUtils.insertRecord(1L, "1a3", 1L, "1b12"));
        this.assertor.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    private KeyedTwoInputStreamOperatorTestHarness<RowData, RowData, RowData, RowData> createTestHarness(ProcTimeIntervalJoin intervalJoinFunc) throws Exception {
        KeyedCoProcessOperator operator = new KeyedCoProcessOperator((KeyedCoProcessFunction)intervalJoinFunc);
        KeyedTwoInputStreamOperatorTestHarness testHarness = new KeyedTwoInputStreamOperatorTestHarness((TwoInputStreamOperator)operator, (KeySelector)this.keySelector, (KeySelector)this.keySelector, this.keyType);
        return testHarness;
    }
}

