/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAggOperator;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.GenericRowRecordSortComparator;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.HandwrittenSelectorUtil;
import org.assertj.core.api.Assertions;

public abstract class WindowAggOperatorTestBase {
    protected static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    protected static final ZoneId SHANGHAI_ZONE_ID = ZoneId.of("Asia/Shanghai");
    protected final ZoneId shiftTimeZone;
    private static final RowType INPUT_ROW_TYPE = new RowType(Arrays.asList(new RowType.RowField("f0", (LogicalType)new VarCharType(Integer.MAX_VALUE)), new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new TimestampType())));
    protected static final RowDataSerializer INPUT_ROW_SER = new RowDataSerializer(INPUT_ROW_TYPE);
    protected static final RowDataSerializer ACC_SER = new RowDataSerializer(new LogicalType[]{new BigIntType(), new BigIntType()});
    protected static final LogicalType[] OUTPUT_TYPES = new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new BigIntType(), new BigIntType(), new BigIntType(), new BigIntType()};
    protected static final RowDataKeySelector KEY_SELECTOR = HandwrittenSelectorUtil.getRowDataSelector(new int[]{0}, INPUT_ROW_TYPE.getChildren().toArray(new LogicalType[0]));
    protected static final PagedTypeSerializer<RowData> KEY_SER = (PagedTypeSerializer)KEY_SELECTOR.getProducedType().toSerializer();
    protected static final TypeSerializer<RowData> OUT_SERIALIZER = new RowDataSerializer(OUTPUT_TYPES);
    protected static final RowDataHarnessAssertor ASSERTER = new RowDataHarnessAssertor(OUTPUT_TYPES, new GenericRowRecordSortComparator(0, (LogicalType)VarCharType.STRING_TYPE));

    public WindowAggOperatorTestBase(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
    }

    protected long localMills(long epochMills) {
        return TimeWindowUtil.toUtcTimestampMills((long)epochMills, (ZoneId)this.shiftTimeZone);
    }

    protected static OneInputStreamOperatorTestHarness<RowData, RowData> createTestHarness(WindowAggOperator<RowData, ?> operator) throws Exception {
        return new KeyedOneInputStreamOperatorTestHarness(operator, (KeySelector)KEY_SELECTOR, (TypeInformation)KEY_SELECTOR.getProducedType());
    }

    protected static <T> GeneratedNamespaceAggsHandleFunction<T> createGeneratedAggsHandle(final NamespaceAggsHandleFunction<T> aggsFunction) {
        return new GeneratedNamespaceAggsHandleFunction<T>("N/A", "", new Object[0]){
            private static final long serialVersionUID = 1L;

            public NamespaceAggsHandleFunction<T> newInstance(ClassLoader classLoader) {
                return aggsFunction;
            }
        };
    }

    protected static long epochMills(ZoneId shiftTimeZone, String timestampStr) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampStr);
        ZoneOffset zoneOffset = shiftTimeZone.getRules().getOffset(localDateTime);
        return localDateTime.toInstant(zoneOffset).toEpochMilli();
    }

    protected static abstract class SumAndCountAggsFunctionBase<T>
    implements NamespaceAggsHandleFunction<T> {
        private static final long serialVersionUID = 1L;
        boolean openCalled;
        final AtomicInteger closeCalled = new AtomicInteger(0);
        long sum;
        boolean sumIsNull;
        long count;
        boolean countIsNull;
        protected transient JoinedRowData result;

        protected SumAndCountAggsFunctionBase() {
        }

        public void open(StateDataViewStore store) throws Exception {
            this.openCalled = true;
            this.result = new JoinedRowData();
        }

        public void setAccumulators(T window, RowData acc) throws Exception {
            if (!this.openCalled) {
                Assertions.fail((String)"Open was not called");
            }
            this.sumIsNull = acc.isNullAt(0);
            this.sum = !this.sumIsNull ? acc.getLong(0) : 0L;
            this.countIsNull = acc.isNullAt(1);
            this.count = !this.countIsNull ? acc.getLong(1) : 0L;
        }

        public void accumulate(RowData inputRow) throws Exception {
            boolean inputIsNull;
            if (!this.openCalled) {
                Assertions.fail((String)"Open was not called");
            }
            if (!(inputIsNull = inputRow.isNullAt(1))) {
                this.sum += (long)inputRow.getInt(1);
                ++this.count;
                this.sumIsNull = false;
                this.countIsNull = false;
            }
        }

        public void retract(RowData inputRow) throws Exception {
            boolean inputIsNull;
            if (!this.openCalled) {
                Assertions.fail((String)"Open was not called");
            }
            if (!(inputIsNull = inputRow.isNullAt(1))) {
                this.sum -= (long)inputRow.getInt(1);
                --this.count;
            }
        }

        public void merge(T window, RowData otherAcc) throws Exception {
            boolean countIsNull2;
            boolean sumIsNull2;
            if (!this.openCalled) {
                Assertions.fail((String)"Open was not called");
            }
            if (!(sumIsNull2 = otherAcc.isNullAt(0))) {
                this.sum += otherAcc.getLong(0);
                this.sumIsNull = false;
            }
            if (!(countIsNull2 = otherAcc.isNullAt(1))) {
                this.count += otherAcc.getLong(1);
                this.countIsNull = false;
            }
        }

        public RowData createAccumulators() {
            if (!this.openCalled) {
                Assertions.fail((String)"Open was not called");
            }
            GenericRowData rowData = new GenericRowData(2);
            rowData.setField(1, (Object)0L);
            return rowData;
        }

        public RowData getAccumulators() throws Exception {
            if (!this.openCalled) {
                Assertions.fail((String)"Open was not called");
            }
            GenericRowData row = new GenericRowData(2);
            if (!this.sumIsNull) {
                row.setField(0, (Object)this.sum);
            } else {
                row.setField(0, null);
            }
            if (!this.countIsNull) {
                row.setField(1, (Object)this.count);
            } else {
                row.setField(1, null);
            }
            return row;
        }

        public void cleanup(T window) {
        }

        public void close() {
            this.closeCalled.incrementAndGet();
        }

        public RowData getValue(T window) throws Exception {
            if (!this.openCalled) {
                Assertions.fail((String)"Open was not called");
            }
            GenericRowData row = new GenericRowData(4);
            if (!this.sumIsNull) {
                row.setField(0, (Object)this.sum);
            } else {
                row.setField(0, null);
            }
            if (!this.countIsNull) {
                row.setField(1, (Object)this.count);
            } else {
                row.setField(1, null);
            }
            row.setField(2, (Object)this.getWindowStart(window));
            row.setField(3, (Object)this.getWindowEnd(window));
            return row;
        }

        protected abstract long getWindowStart(T var1);

        protected abstract long getWindowEnd(T var1);
    }
}

