/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.table.connector.source.lookup.cache.DefaultLookupCache;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.runtime.functions.table.lookup.CachingLookupFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CachingLookupFunctionTest {
    private static final RowData KEY_1 = GenericRowData.of((Object[])new Object[]{1});
    private static final Collection<RowData> VALUE_1 = Collections.singletonList(GenericRowData.of((Object[])new Object[]{1, "Alice", 18L}));
    private static final RowData KEY_2 = GenericRowData.of((Object[])new Object[]{2});
    private static final Collection<RowData> VALUE_2 = Arrays.asList(GenericRowData.of((Object[])new Object[]{2, "Bob", 20L}), GenericRowData.of((Object[])new Object[]{2, "Charlie", 22L}));
    private static final RowData NON_EXIST_KEY = GenericRowData.of((Object[])new Object[]{3});

    CachingLookupFunctionTest() {
    }

    @Test
    void testCaching() throws Exception {
        TestingLookupFunction delegate = new TestingLookupFunction();
        CachingLookupFunction function = this.createCachingFunction(delegate);
        function.lookup(KEY_1);
        function.lookup(KEY_2);
        function.lookup(NON_EXIST_KEY);
        function.lookup(KEY_1);
        function.lookup(KEY_2);
        function.lookup(NON_EXIST_KEY);
        Assertions.assertThat((int)delegate.getLookupCount()).isEqualTo(3);
        Assertions.assertThat((Collection)function.getCache().getIfPresent(KEY_1)).containsExactlyInAnyOrderElementsOf(VALUE_1);
        Assertions.assertThat((Collection)function.getCache().getIfPresent(KEY_2)).containsExactlyInAnyOrderElementsOf(VALUE_2);
        Assertions.assertThat((Collection)function.getCache().getIfPresent(NON_EXIST_KEY)).isEmpty();
    }

    private CachingLookupFunction createCachingFunction(LookupFunction delegate) throws Exception {
        CachingLookupFunction function = new CachingLookupFunction((LookupCache)DefaultLookupCache.newBuilder().maximumSize(Long.MAX_VALUE).build(), delegate);
        function.open(new FunctionContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 0)));
        return function;
    }

    private static final class TestingLookupFunction
    extends LookupFunction {
        private static final long serialVersionUID = 1L;
        private final transient Map<RowData, Collection<RowData>> data = new HashMap<RowData, Collection<RowData>>();
        private int lookupCount = 0;

        private TestingLookupFunction() {
        }

        public void open(FunctionContext context) {
            this.data.put(KEY_1, VALUE_1);
            this.data.put(KEY_2, VALUE_2);
        }

        public Collection<RowData> lookup(RowData keyRow) {
            ++this.lookupCount;
            return this.data.get(keyRow);
        }

        public int getLookupCount() {
            return this.lookupCount;
        }
    }
}

