/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.formats.raw;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.formats.raw.RawFormatDeserializationSchema;
import org.apache.flink.formats.raw.RawFormatSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.TestDynamicTableFactory;
import org.apache.flink.table.factories.utils.FactoryMocks;
import org.apache.flink.table.runtime.connector.sink.SinkRuntimeProviderContext;
import org.apache.flink.table.runtime.connector.source.ScanRuntimeProviderContext;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.Test;

public class RawFormatFactoryTest
extends TestLogger {
    private static final ResolvedSchema SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"field1", (DataType)DataTypes.STRING())});
    private static final RowType ROW_TYPE = (RowType)SCHEMA.toPhysicalRowDataType().getLogicalType();

    @Test
    public void testSeDeSchema() {
        Map<String, String> tableOptions = this.getBasicOptions();
        RawFormatDeserializationSchema expectedDeser = new RawFormatDeserializationSchema(ROW_TYPE.getTypeAt(0), (TypeInformation)InternalTypeInfo.of((RowType)ROW_TYPE), "UTF-8", true);
        DeserializationSchema<RowData> actualDeser = RawFormatFactoryTest.createDeserializationSchema(SCHEMA, tableOptions);
        Assertions.assertThat(actualDeser).isEqualTo((Object)expectedDeser);
        RawFormatSerializationSchema expectedSer = new RawFormatSerializationSchema(ROW_TYPE.getTypeAt(0), "UTF-8", true);
        SerializationSchema<RowData> actualSer = RawFormatFactoryTest.createSerializationSchema(SCHEMA, tableOptions);
        Assertions.assertThat(actualSer).isEqualTo((Object)expectedSer);
    }

    @Test
    public void testCharsetAndEndiannessOption() {
        Map<String, String> tableOptions = this.getModifiedOptions(options -> {
            options.put("raw.charset", "UTF-16");
            options.put("raw.endianness", "little-endian");
        });
        RawFormatDeserializationSchema expectedDeser = new RawFormatDeserializationSchema(ROW_TYPE.getTypeAt(0), (TypeInformation)InternalTypeInfo.of((RowType)ROW_TYPE), "UTF-16", false);
        DeserializationSchema<RowData> actualDeser = RawFormatFactoryTest.createDeserializationSchema(SCHEMA, tableOptions);
        Assertions.assertThat(actualDeser).isEqualTo((Object)expectedDeser);
        RawFormatSerializationSchema expectedSer = new RawFormatSerializationSchema(ROW_TYPE.getTypeAt(0), "UTF-16", false);
        SerializationSchema<RowData> actualSer = RawFormatFactoryTest.createSerializationSchema(SCHEMA, tableOptions);
        Assertions.assertThat(actualSer).isEqualTo((Object)expectedSer);
    }

    @Test
    public void testInvalidSchema() {
        ResolvedSchema invalidSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f0", (DataType)DataTypes.STRING()), Column.physical((String)"f1", (DataType)DataTypes.BIGINT())});
        String expectedError = "The 'raw' format only supports single physical column. However the defined schema contains multiple physical columns: [`f0` STRING, `f1` BIGINT]";
        Assertions.assertThatThrownBy(() -> RawFormatFactoryTest.createDeserializationSchema(invalidSchema, this.getBasicOptions())).hasMessage(expectedError);
        Assertions.assertThatThrownBy(() -> RawFormatFactoryTest.createSerializationSchema(invalidSchema, this.getBasicOptions())).hasMessage(expectedError);
    }

    @Test
    public void testInvalidCharset() {
        Map<String, String> tableOptions = this.getModifiedOptions(options -> options.put("raw.charset", "UNKNOWN"));
        String expectedError = "Unsupported 'raw.charset' name: UNKNOWN.";
        Assertions.assertThatThrownBy(() -> RawFormatFactoryTest.createDeserializationSchema(SCHEMA, tableOptions)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches((String)expectedError)});
        Assertions.assertThatThrownBy(() -> RawFormatFactoryTest.createSerializationSchema(SCHEMA, tableOptions)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches((String)expectedError)});
    }

    @Test
    public void testInvalidEndianness() {
        Map<String, String> tableOptions = this.getModifiedOptions(options -> options.put("raw.endianness", "BIG_ENDIAN"));
        String expectedError = "Unsupported endianness name: BIG_ENDIAN. Valid values of 'raw.endianness' option are 'big-endian' and 'little-endian'.";
        Assertions.assertThatThrownBy(() -> RawFormatFactoryTest.createDeserializationSchema(SCHEMA, tableOptions)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches((String)expectedError)});
        Assertions.assertThatThrownBy(() -> RawFormatFactoryTest.createSerializationSchema(SCHEMA, tableOptions)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches((String)expectedError)});
    }

    @Test
    public void testInvalidFieldTypes() {
        Assertions.assertThatThrownBy(() -> RawFormatFactoryTest.createDeserializationSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"field1", (DataType)DataTypes.TIMESTAMP((int)3))}), this.getBasicOptions())).hasMessage("The 'raw' format doesn't supports 'TIMESTAMP(3)' as column type.");
        Assertions.assertThatThrownBy(() -> RawFormatFactoryTest.createDeserializationSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"field1", (DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING()))}), this.getBasicOptions())).hasMessage("The 'raw' format doesn't supports 'MAP<INT, STRING>' as column type.");
    }

    private static DeserializationSchema<RowData> createDeserializationSchema(ResolvedSchema schema, Map<String, String> options) {
        DynamicTableSource actualSource = FactoryMocks.createTableSource((ResolvedSchema)schema, options);
        Assertions.assertThat((Object)actualSource).isInstanceOf(TestDynamicTableFactory.DynamicTableSourceMock.class);
        TestDynamicTableFactory.DynamicTableSourceMock scanSourceMock = (TestDynamicTableFactory.DynamicTableSourceMock)actualSource;
        return (DeserializationSchema)scanSourceMock.valueFormat.createRuntimeDecoder((DynamicTableSource.Context)ScanRuntimeProviderContext.INSTANCE, schema.toPhysicalRowDataType());
    }

    private static SerializationSchema<RowData> createSerializationSchema(ResolvedSchema schema, Map<String, String> options) {
        DynamicTableSink actualSink = FactoryMocks.createTableSink((ResolvedSchema)schema, options);
        Assertions.assertThat((Object)actualSink).isInstanceOf(TestDynamicTableFactory.DynamicTableSinkMock.class);
        TestDynamicTableFactory.DynamicTableSinkMock sinkMock = (TestDynamicTableFactory.DynamicTableSinkMock)actualSink;
        return (SerializationSchema)sinkMock.valueFormat.createRuntimeEncoder((DynamicTableSink.Context)new SinkRuntimeProviderContext(false), schema.toPhysicalRowDataType());
    }

    private Map<String, String> getModifiedOptions(Consumer<Map<String, String>> optionModifier) {
        Map<String, String> options = this.getBasicOptions();
        optionModifier.accept(options);
        return options;
    }

    private Map<String, String> getBasicOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "test-connector");
        options.put("target", "MyTarget");
        options.put("buffer-size", "1000");
        options.put("format", "raw");
        return options;
    }
}

