/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window;

import java.time.ZoneId;
import java.util.Collection;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.util.Preconditions;

public class WindowTableFunctionOperator
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final WindowAssigner<TimeWindow> windowAssigner;
    private final int rowtimeIndex;
    private final ZoneId shiftTimeZone;
    private transient TimestampedCollector<RowData> collector;
    private transient JoinedRowData outRow;
    private transient GenericRowData windowProperties;

    public WindowTableFunctionOperator(WindowAssigner<TimeWindow> windowAssigner, int rowtimeIndex, ZoneId shiftTimeZone) {
        Preconditions.checkArgument((!windowAssigner.isEventTime() || rowtimeIndex >= 0 ? 1 : 0) != 0);
        this.windowAssigner = windowAssigner;
        this.rowtimeIndex = rowtimeIndex;
        this.shiftTimeZone = shiftTimeZone;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        this.collector.eraseTimestamp();
        this.outRow = new JoinedRowData();
        this.windowProperties = new GenericRowData(3);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        long timestamp;
        RowData inputRow = (RowData)element.getValue();
        if (this.windowAssigner.isEventTime()) {
            if (inputRow.isNullAt(this.rowtimeIndex)) {
                return;
            }
            timestamp = inputRow.getTimestamp(this.rowtimeIndex, 3).getMillisecond();
        } else {
            timestamp = this.getProcessingTimeService().getCurrentProcessingTime();
        }
        timestamp = TimeWindowUtil.toUtcTimestampMills(timestamp, this.shiftTimeZone);
        Collection<TimeWindow> elementWindows = this.windowAssigner.assignWindows(inputRow, timestamp);
        for (TimeWindow window : elementWindows) {
            this.windowProperties.setField(0, (Object)TimestampData.fromEpochMillis((long)window.getStart()));
            this.windowProperties.setField(1, (Object)TimestampData.fromEpochMillis((long)window.getEnd()));
            this.windowProperties.setField(2, (Object)TimestampData.fromEpochMillis((long)TimeWindowUtil.toEpochMills(window.maxTimestamp(), this.shiftTimeZone)));
            this.collector.collect((Object)this.outRow.replace(inputRow, (RowData)this.windowProperties));
        }
    }
}

