/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.over.BufferDataOverWindowOperator;
import org.apache.flink.table.runtime.operators.over.NonBufferOverWindowOperatorTest;
import org.apache.flink.table.runtime.operators.over.frame.InsensitiveOverFrame;
import org.apache.flink.table.runtime.operators.over.frame.OffsetOverFrame;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.operators.over.frame.RangeSlidingOverFrame;
import org.apache.flink.table.runtime.operators.over.frame.RangeUnboundedFollowingOverFrame;
import org.apache.flink.table.runtime.operators.over.frame.RangeUnboundedPrecedingOverFrame;
import org.apache.flink.table.runtime.operators.over.frame.RowSlidingOverFrame;
import org.apache.flink.table.runtime.operators.over.frame.RowUnboundedFollowingOverFrame;
import org.apache.flink.table.runtime.operators.over.frame.RowUnboundedPrecedingOverFrame;
import org.apache.flink.table.runtime.operators.over.frame.UnboundedOverWindowFrame;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class BufferDataOverWindowOperatorTest {
    private static final int MEMORY_SIZE = 0x190000;
    private RowType valueType = new RowType(Collections.singletonList(new RowType.RowField("f0", (LogicalType)new BigIntType())));
    private List<GenericRowData> collect;
    private MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize(0x190000L).build();
    private IOManager ioManager;
    private BufferDataOverWindowOperator operator;
    private GeneratedRecordComparator boundComparator = new GeneratedRecordComparator("", "", new Object[0]){

        public RecordComparator newInstance(ClassLoader classLoader) {
            return (RecordComparator & Serializable)(o1, o2) -> (int)(o1.getLong(1) - o2.getLong(1));
        }
    };

    @Before
    public void before() throws Exception {
        this.ioManager = new IOManagerAsync();
        this.collect = new ArrayList<GenericRowData>();
    }

    @Test
    public void testOffsetWindowFrame() throws Exception {
        this.test(new OverWindowFrame[]{new OffsetOverFrame(NonBufferOverWindowOperatorTest.function, Long.valueOf(2L), null), new OffsetOverFrame(NonBufferOverWindowOperatorTest.function, Long.valueOf(2L), (OffsetOverFrame.CalcOffsetFunc & Serializable)r -> r.getInt(0))}, new GenericRowData[]{GenericRowData.of((Object[])new Object[]{0, 1L, 4L, 1L, 1L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 2L, 2L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 1L, 3L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 0L, 4L}), GenericRowData.of((Object[])new Object[]{1, 5L, 2L, -5L, -5L}), GenericRowData.of((Object[])new Object[]{2, 5L, 4L, 6L, 6L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 12L, 12L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 6L, 6L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 0L, 0L})});
    }

    @Test
    public void testInsensitiveAndUnbounded() throws Exception {
        this.test(new OverWindowFrame[]{new InsensitiveOverFrame(NonBufferOverWindowOperatorTest.function), new UnboundedOverWindowFrame(NonBufferOverWindowOperatorTest.function, this.valueType)}, new GenericRowData[]{GenericRowData.of((Object[])new Object[]{0, 1L, 4L, 1L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 2L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 3L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 4L, 4L}), GenericRowData.of((Object[])new Object[]{1, 5L, 2L, 5L, 5L}), GenericRowData.of((Object[])new Object[]{2, 5L, 4L, 5L, 23L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 11L, 23L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 17L, 23L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 23L, 23L})});
    }

    @Test
    public void testPreceding() throws Exception {
        this.test(new OverWindowFrame[]{new RowUnboundedPrecedingOverFrame(NonBufferOverWindowOperatorTest.function, 1L), new RangeUnboundedPrecedingOverFrame(NonBufferOverWindowOperatorTest.function, this.boundComparator)}, new GenericRowData[]{GenericRowData.of((Object[])new Object[]{0, 1L, 4L, 2L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 3L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 4L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 4L, 4L}), GenericRowData.of((Object[])new Object[]{1, 5L, 2L, 5L, 5L}), GenericRowData.of((Object[])new Object[]{2, 5L, 4L, 11L, 5L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 17L, 23L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 23L, 23L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 23L, 23L})});
    }

    @Test
    public void testFollowing() throws Exception {
        this.test(new OverWindowFrame[]{new RowUnboundedFollowingOverFrame(this.valueType, NonBufferOverWindowOperatorTest.function, -1L), new RangeUnboundedFollowingOverFrame(this.valueType, NonBufferOverWindowOperatorTest.function, this.boundComparator)}, new GenericRowData[]{GenericRowData.of((Object[])new Object[]{0, 1L, 4L, 4L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 4L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 3L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 2L, 4L}), GenericRowData.of((Object[])new Object[]{1, 5L, 2L, 5L, 5L}), GenericRowData.of((Object[])new Object[]{2, 5L, 4L, 23L, 23L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 23L, 18L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 18L, 18L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 12L, 18L})});
    }

    @Test
    public void testSliding() throws Exception {
        this.test(new OverWindowFrame[]{new RowSlidingOverFrame(NonBufferOverWindowOperatorTest.inputType, this.valueType, NonBufferOverWindowOperatorTest.function, -1L, 1L), new RangeSlidingOverFrame(NonBufferOverWindowOperatorTest.inputType, this.valueType, NonBufferOverWindowOperatorTest.function, this.boundComparator, this.boundComparator)}, new GenericRowData[]{GenericRowData.of((Object[])new Object[]{0, 1L, 4L, 2L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 3L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 3L, 4L}), GenericRowData.of((Object[])new Object[]{0, 1L, 1L, 2L, 4L}), GenericRowData.of((Object[])new Object[]{1, 5L, 2L, 5L, 5L}), GenericRowData.of((Object[])new Object[]{2, 5L, 4L, 11L, 5L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 17L, 18L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 18L, 18L}), GenericRowData.of((Object[])new Object[]{2, 6L, 2L, 12L, 18L})});
    }

    private void test(OverWindowFrame[] frames, GenericRowData[] expect) throws Exception {
        MockEnvironment env = new MockEnvironmentBuilder().setIOManager(this.ioManager).setMemoryManager(this.memoryManager).build();
        StreamTask<Object, StreamOperator<Object>> task = new StreamTask<Object, StreamOperator<Object>>((Environment)env){

            protected void init() {
            }
        };
        this.operator = new BufferDataOverWindowOperator(frames, NonBufferOverWindowOperatorTest.comparator, true, (StreamTask)task){
            final /* synthetic */ StreamTask val$task;
            {
                this.val$task = streamTask;
                super(x0, x1, x2);
                this.output = new NonBufferOverWindowOperatorTest.ConsumerOutput(new Consumer<RowData>(){

                    @Override
                    public void accept(RowData r) {
                        BufferDataOverWindowOperatorTest.this.collect.add(GenericRowData.of((Object[])new Object[]{r.getInt(0), r.getLong(1), r.getLong(2), r.getLong(3), r.getLong(4)}));
                    }
                });
            }

            public ClassLoader getUserCodeClassloader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public StreamConfig getOperatorConfig() {
                StreamConfig conf = (StreamConfig)Mockito.mock(StreamConfig.class);
                Mockito.when((Object)conf.getTypeSerializerIn1(this.getUserCodeClassloader())).thenReturn((Object)NonBufferOverWindowOperatorTest.inputSer);
                Mockito.when((Object)conf.getManagedMemoryFractionOperatorUseCaseOfSlot((ManagedMemoryUseCase)ArgumentMatchers.eq((Object)ManagedMemoryUseCase.OPERATOR), (Configuration)ArgumentMatchers.any(Configuration.class), (ClassLoader)ArgumentMatchers.any(ClassLoader.class))).thenReturn((Object)0.99);
                return conf;
            }

            public StreamTask<?, ?> getContainingTask() {
                return this.val$task;
            }

            public StreamingRuntimeContext getRuntimeContext() {
                return (StreamingRuntimeContext)Mockito.mock(StreamingRuntimeContext.class);
            }
        };
        this.operator.setProcessingTimeService((ProcessingTimeService)new TestProcessingTimeService());
        this.operator.open();
        this.addRow(0, 1L, 4L);
        this.addRow(0, 1L, 1L);
        this.addRow(0, 1L, 1L);
        this.addRow(0, 1L, 1L);
        this.addRow(1, 5L, 2L);
        this.addRow(2, 5L, 4L);
        this.addRow(2, 6L, 2L);
        this.addRow(2, 6L, 2L);
        this.addRow(2, 6L, 2L);
        this.operator.endInput();
        Object[] outputs = this.collect.toArray(new GenericRowData[0]);
        Assertions.assertThat((Object[])outputs).isEqualTo((Object)expect);
        this.operator.close();
    }

    private void addRow(Object ... fields) throws Exception {
        this.operator.processElement(new StreamRecord((Object)GenericRowData.of((Object[])fields)));
    }
}

