/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTaskTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedNormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.HashJoinOperator;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.Int2HashJoinOperatorTestBase;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinFunction;
import org.apache.flink.table.runtime.operators.sort.StringNormalizedKeyComputer;
import org.apache.flink.table.runtime.operators.sort.StringRecordComparator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.JoinUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Test;

public class String2HashJoinOperatorTest
implements Serializable {
    private InternalTypeInfo<RowData> typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, VarCharType.STRING_TYPE});
    private InternalTypeInfo<RowData> joinedInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, VarCharType.STRING_TYPE, VarCharType.STRING_TYPE, VarCharType.STRING_TYPE});
    private transient TwoInputStreamTaskTestHarness<BinaryRowData, BinaryRowData, JoinedRowData> testHarness;
    private ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue();
    private long initialTime = 0L;

    public static LinkedBlockingQueue<Object> transformToBinary(LinkedBlockingQueue<Object> output) {
        LinkedBlockingQueue<Object> ret = new LinkedBlockingQueue<Object>();
        for (Object o : output) {
            BinaryRowData binaryRow;
            RowData row = (RowData)((StreamRecord)o).getValue();
            if (row.isNullAt(0)) {
                binaryRow = String2HashJoinOperatorTest.newRow(row.getString(2).toString(), row.getString(3) + "null");
            } else if (row.isNullAt(2)) {
                binaryRow = String2HashJoinOperatorTest.newRow(row.getString(0).toString(), row.getString(1) + "null");
            } else {
                String value1 = row.getString(1).toString();
                String value2 = row.getString(3).toString();
                binaryRow = String2HashJoinOperatorTest.newRow(row.getString(0).toString(), value1 + value2);
            }
            ret.add(new StreamRecord((Object)binaryRow));
        }
        return ret;
    }

    private void init(boolean leftOut, boolean rightOut, boolean buildLeft) throws Exception {
        FlinkJoinType flinkJoinType = JoinUtil.getJoinType(leftOut, rightOut);
        HashJoinType hashJoinType = HashJoinType.of((boolean)buildLeft, (boolean)leftOut, (boolean)rightOut);
        HashJoinOperator operator = this.newOperator(0x108000L, flinkJoinType, hashJoinType, !buildLeft);
        this.testHarness = new TwoInputStreamTaskTestHarness(TwoInputStreamTask::new, 2, 2, new int[]{1, 2}, this.typeInfo, this.typeInfo, this.joinedInfo);
        this.testHarness.memorySize = 0x2400000L;
        this.testHarness.getExecutionConfig().enableObjectReuse();
        this.testHarness.setupOutputForSingletonOperatorChain();
        this.testHarness.getStreamConfig().setStreamOperator((StreamOperator)operator);
        this.testHarness.getStreamConfig().setOperatorID(new OperatorID());
        this.testHarness.getStreamConfig().setManagedMemoryFractionOperatorOfUseCase(ManagedMemoryUseCase.OPERATOR, 0.99);
        this.testHarness.invoke();
        this.testHarness.waitForTaskRunning();
    }

    @Test
    public void testInnerHashJoin() throws Exception {
        this.init(false, false, true);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "1"), this.initialTime), 0, 1);
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(0, 0);
        this.testHarness.endInput(0, 1);
        this.testHarness.waitForInputProcessing();
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "2"), this.initialTime), 1, 1);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "02")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2"), this.initialTime), 1, 1);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "4"), this.initialTime), 1, 0);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "14")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(1, 0);
        this.testHarness.endInput(1, 1);
        this.testHarness.waitForTaskCompletion();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
    }

    @Test
    public void testProbeOuterHashJoin() throws Exception {
        this.init(true, false, false);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "1"), this.initialTime), 0, 1);
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(0, 0);
        this.testHarness.endInput(0, 1);
        this.testHarness.waitForInputProcessing();
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "2"), this.initialTime), 1, 1);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "20")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2"), this.initialTime), 1, 1);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "4"), this.initialTime), 1, 0);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2null")));
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "41")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(1, 0);
        this.testHarness.endInput(1, 1);
        this.testHarness.waitForTaskCompletion();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
    }

    @Test
    public void testBuildOuterHashJoin() throws Exception {
        this.init(false, true, false);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "1"), this.initialTime), 0, 1);
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(0, 0);
        this.testHarness.endInput(0, 1);
        this.testHarness.waitForInputProcessing();
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "2"), this.initialTime), 1, 1);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "20")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2"), this.initialTime), 1, 1);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "4"), this.initialTime), 1, 0);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "41")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(1, 0);
        this.testHarness.endInput(1, 1);
        this.testHarness.waitForTaskCompletion();
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0null")));
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
    }

    @Test
    public void testFullOuterHashJoin() throws Exception {
        this.init(true, true, true);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0"), this.initialTime), 0, 0);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "1"), this.initialTime), 0, 1);
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(0, 0);
        this.testHarness.endInput(0, 1);
        this.testHarness.waitForInputProcessing();
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "2"), this.initialTime), 1, 1);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("a", "02")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2"), this.initialTime), 1, 1);
        this.testHarness.processElement((Object)new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "4"), this.initialTime), 1, 0);
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("c", "2null")));
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("b", "14")));
        this.testHarness.waitForInputProcessing();
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
        this.testHarness.endInput(1, 0);
        this.testHarness.endInput(1, 1);
        this.testHarness.waitForTaskCompletion();
        this.expectedOutput.add(new StreamRecord((Object)String2HashJoinOperatorTest.newRow("d", "0null")));
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", this.expectedOutput, String2HashJoinOperatorTest.transformToBinary(this.testHarness.getOutput()));
    }

    public static BinaryRowData newRow(String ... s) {
        BinaryRowData row = new BinaryRowData(s.length);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) {
                writer.setNullAt(i);
                continue;
            }
            writer.writeString(i, StringData.fromString((String)s[i]));
        }
        writer.complete();
        return row;
    }

    private HashJoinOperator newOperator(long memorySize, FlinkJoinType flinkJoinType, HashJoinType hashJoinType, boolean reverseJoinFunction) {
        boolean buildLeft = false;
        GeneratedJoinCondition condFuncCode = new GeneratedJoinCondition("", "", new Object[0]){

            public JoinCondition newInstance(ClassLoader classLoader) {
                return new Int2HashJoinOperatorTestBase.TrueCondition();
            }
        };
        GeneratedProjection buildProjectionCode = new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new MyProjection();
            }
        };
        GeneratedProjection probeProjectionCode = new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new MyProjection();
            }
        };
        GeneratedNormalizedKeyComputer computer1 = new GeneratedNormalizedKeyComputer("", ""){

            public NormalizedKeyComputer newInstance(ClassLoader classLoader) {
                return new StringNormalizedKeyComputer();
            }
        };
        GeneratedRecordComparator comparator1 = new GeneratedRecordComparator("", "", new Object[0]){

            public RecordComparator newInstance(ClassLoader classLoader) {
                return new StringRecordComparator();
            }
        };
        GeneratedNormalizedKeyComputer computer2 = new GeneratedNormalizedKeyComputer("", ""){

            public NormalizedKeyComputer newInstance(ClassLoader classLoader) {
                return new StringNormalizedKeyComputer();
            }
        };
        GeneratedRecordComparator comparator2 = new GeneratedRecordComparator("", "", new Object[0]){

            public RecordComparator newInstance(ClassLoader classLoader) {
                return new StringRecordComparator();
            }
        };
        GeneratedRecordComparator genKeyComparator = new GeneratedRecordComparator("", "", new Object[0]){

            public RecordComparator newInstance(ClassLoader classLoader) {
                return new StringRecordComparator();
            }
        };
        boolean[] filterNulls = new boolean[]{true};
        int maxNumFileHandles = (Integer)ExecutionConfigOptions.TABLE_EXEC_SORT_MAX_NUM_FILE_HANDLES.defaultValue();
        boolean compressionEnable = (Boolean)ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED.defaultValue();
        int compressionBlockSize = (int)((MemorySize)ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE.defaultValue()).getBytes();
        boolean asyncMergeEnable = (Boolean)ExecutionConfigOptions.TABLE_EXEC_SORT_ASYNC_MERGE_ENABLED.defaultValue();
        SortMergeJoinFunction sortMergeJoinFunction = new SortMergeJoinFunction(0.0, flinkJoinType, buildLeft, maxNumFileHandles, compressionEnable, compressionBlockSize, asyncMergeEnable, condFuncCode, probeProjectionCode, buildProjectionCode, computer2, comparator2, computer1, comparator1, genKeyComparator, filterNulls);
        return HashJoinOperator.newHashJoinOperator((HashJoinType)hashJoinType, (boolean)buildLeft, (boolean)compressionEnable, (int)compressionBlockSize, (GeneratedJoinCondition)condFuncCode, (boolean)reverseJoinFunction, (boolean[])filterNulls, (GeneratedProjection)buildProjectionCode, (GeneratedProjection)probeProjectionCode, (boolean)false, (int)20, (long)10000L, (long)10000L, (RowType)RowType.of((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE}), (SortMergeJoinFunction)sortMergeJoinFunction);
    }

    public static final class MyProjection
    implements Projection<BinaryRowData, BinaryRowData> {
        BinaryRowData innerRow = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(this.innerRow);

        public BinaryRowData apply(BinaryRowData row) {
            this.writer.reset();
            this.writer.writeString(0, row.getString(0));
            this.writer.complete();
            return this.innerRow;
        }
    }
}

