/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.runtime.typeutils.LinkedListSerializer;
import org.apache.flink.util.FlinkRuntimeException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LinkedListSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<LinkedList<Long>, LinkedList<Long>> {
    public LinkedListSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<LinkedList<Long>, LinkedList<Long>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        return FlinkVersion.rangeOf((FlinkVersion)FlinkVersion.v1_13, (FlinkVersion)CURRENT_VERSION).stream().map(version -> {
            try {
                return new TypeSerializerUpgradeTestBase.TestSpecification("linked-list-serializer", version, LinkedListSerializerSetup.class, LinkedListSerializerVerifier.class);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    public static TypeSerializer<LinkedList<Long>> createLinkedListSerializer() {
        return new LinkedListSerializer((TypeSerializer)new LongSerializer());
    }

    public static final class LinkedListSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<LinkedList<Long>> {
        public TypeSerializer<LinkedList<Long>> createUpgradedSerializer() {
            return LinkedListSerializerUpgradeTest.createLinkedListSerializer();
        }

        public Matcher<LinkedList<Long>> testDataMatcher() {
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(42L);
            list.add(-42L);
            list.add(0L);
            list.add(Long.MAX_VALUE);
            list.add(Long.MIN_VALUE);
            return Matchers.is(list);
        }

        public Matcher<TypeSerializerSchemaCompatibility<LinkedList<Long>>> schemaCompatibilityMatcher(FlinkVersion version) {
            if (version.isNewerVersionThan(FlinkVersion.v1_13)) {
                return TypeSerializerMatchers.isCompatibleAsIs();
            }
            return TypeSerializerMatchers.isCompatibleAfterMigration();
        }
    }

    public static final class LinkedListSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<LinkedList<Long>> {
        public TypeSerializer<LinkedList<Long>> createPriorSerializer() {
            return LinkedListSerializerUpgradeTest.createLinkedListSerializer();
        }

        public LinkedList<Long> createTestData() {
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(42L);
            list.add(-42L);
            list.add(0L);
            list.add(Long.MAX_VALUE);
            list.add(Long.MIN_VALUE);
            return list;
        }
    }
}

