/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.slicing;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssignerTestBase;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigners;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TumblingSliceAssignerTest
extends SliceAssignerTestBase {
    @Parameterized.Parameter
    public ZoneId shiftTimeZone;

    @Parameterized.Parameters(name="timezone = {0}")
    public static Collection<ZoneId> parameters() {
        return Arrays.asList(ZoneId.of("America/Los_Angeles"), ZoneId.of("Asia/Shanghai"));
    }

    @Test
    public void testSliceAssignment() {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T04:59:59.999"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T10:00:00"));
    }

    @Test
    public void testSliceAssignmentWithOffset() {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L)).withOffset(Duration.ofMillis(100L));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00.1"))).isEqualTo(this.utcMills("1970-01-01T05:00:00.1"));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.099"))).isEqualTo(this.utcMills("1970-01-01T05:00:00.1"));
        Assertions.assertThat((long)TumblingSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.1"))).isEqualTo(this.utcMills("1970-01-01T10:00:00.1"));
    }

    @Test
    public void testDstSaving() {
        if (!TimeZone.getTimeZone(this.shiftTimeZone).useDaylightTime()) {
            return;
        }
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(4L));
        long epoch1 = 1615708800000L;
        long epoch2 = 1615712400000L;
        long epoch3 = 1615716000000L;
        long epoch4 = 1615719600000L;
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch1, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch2, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch3, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-03-14T04:00", "2021-03-14T08:00", epoch4, (SliceAssigner)assigner);
        long epoch5 = 1636268400000L;
        long epoch6 = 1636272000000L;
        long epoch7 = 1636275600000L;
        long epoch8 = 1636279200000L;
        long epoch9 = 1636282800000L;
        long epoch10 = 1636286400000L;
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch5, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch6, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch7, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch8, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch9, (SliceAssigner)assigner);
        TumblingSliceAssignerTest.assertSliceStartEnd("2021-11-07T04:00", "2021-11-07T08:00", epoch10, (SliceAssigner)assigner);
    }

    @Test
    public void testGetWindowStart() {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T19:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
    }

    @Test
    public void testExpiredSlices() {
        SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L));
        Assertions.assertThat(TumblingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T00:00:00")});
        Assertions.assertThat(TumblingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T05:00:00")});
        Assertions.assertThat(TumblingSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T10:00:00")});
    }

    @Test
    public void testEventTime() {
        SliceAssigners.TumblingSliceAssigner assigner1 = SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L));
        Assertions.assertThat((boolean)assigner1.isEventTime()).isTrue();
        SliceAssigners.TumblingSliceAssigner assigner2 = SliceAssigners.tumbling((int)-1, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L));
        Assertions.assertThat((boolean)assigner2.isEventTime()).isFalse();
    }

    @Test
    public void testInvalidParameters() {
        TumblingSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(-1L)), "Tumbling Window parameters must satisfy size > 0, but got size -1000ms.");
        TumblingSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(20L)), "Tumbling Window parameters must satisfy abs(offset) < size, bot got size 10000ms and offset 20000ms.");
        SliceAssigners.tumbling((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(-1L));
    }

    private long localMills(String timestampStr) {
        return this.localMills(timestampStr, this.shiftTimeZone);
    }
}

