/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.math.BigDecimal;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DecimalDataTest {
    @Test
    public void testNormal() {
        BigDecimal bigDecimal1 = new BigDecimal("13145678.90123");
        BigDecimal bigDecimal2 = new BigDecimal("1234567890.0987654321");
        Assertions.assertThat((Comparable)DecimalData.fromUnscaledBytes((byte[])bigDecimal1.unscaledValue().toByteArray(), (int)15, (int)5)).isEqualTo((Object)DecimalData.fromBigDecimal((BigDecimal)bigDecimal1, (int)15, (int)5));
        Assertions.assertThat((Comparable)DecimalData.fromUnscaledBytes((byte[])bigDecimal2.unscaledValue().toByteArray(), (int)23, (int)10)).isEqualTo((Object)DecimalData.fromBigDecimal((BigDecimal)bigDecimal2, (int)23, (int)10));
        Assertions.assertThat((byte[])DecimalData.fromUnscaledBytes((byte[])bigDecimal1.unscaledValue().toByteArray(), (int)15, (int)5).toUnscaledBytes()).isEqualTo((Object)bigDecimal1.unscaledValue().toByteArray());
        Assertions.assertThat((byte[])DecimalData.fromUnscaledBytes((byte[])bigDecimal2.unscaledValue().toByteArray(), (int)23, (int)10).toUnscaledBytes()).isEqualTo((Object)bigDecimal2.unscaledValue().toByteArray());
        DecimalData decimal1 = DecimalData.fromUnscaledLong((long)10L, (int)5, (int)0);
        DecimalData decimal2 = DecimalData.fromUnscaledLong((long)15L, (int)5, (int)0);
        Assertions.assertThat((int)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)5, (int)0).hashCode()).isEqualTo(decimal1.hashCode());
        Assertions.assertThat((Comparable)decimal1.copy()).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)DecimalData.fromUnscaledLong((long)decimal1.toUnscaledLong(), (int)5, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)DecimalData.fromUnscaledBytes((byte[])decimal1.toUnscaledBytes(), (int)5, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((int)decimal1.compareTo(decimal2)).isLessThan(0);
        Assertions.assertThat((int)DecimalDataUtils.signum((DecimalData)decimal1)).isEqualTo(1);
        Assertions.assertThat((double)DecimalDataUtils.doubleValue((DecimalData)DecimalDataUtils.castFrom((double)10.5, (int)5, (int)1))).isEqualTo(10.5);
        Assertions.assertThat((Comparable)DecimalDataUtils.negate((DecimalData)decimal1)).isEqualTo((Object)DecimalData.fromUnscaledLong((long)-10L, (int)5, (int)0));
        Assertions.assertThat((Comparable)DecimalDataUtils.abs((DecimalData)decimal1)).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)DecimalDataUtils.abs((DecimalData)DecimalDataUtils.negate((DecimalData)decimal1))).isEqualTo((Object)decimal1);
        Assertions.assertThat((long)DecimalDataUtils.add((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)0).toUnscaledLong()).isEqualTo(25L);
        Assertions.assertThat((long)DecimalDataUtils.subtract((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)0).toUnscaledLong()).isEqualTo(-5L);
        Assertions.assertThat((long)DecimalDataUtils.multiply((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)0).toUnscaledLong()).isEqualTo(150L);
        Assertions.assertThat((double)DecimalDataUtils.doubleValue((DecimalData)DecimalDataUtils.divide((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)2))).isEqualTo(0.67);
        Assertions.assertThat((Comparable)DecimalDataUtils.mod((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((long)DecimalDataUtils.divideToIntegralValue((DecimalData)decimal1, (DecimalData)DecimalData.fromUnscaledLong((long)2L, (int)5, (int)0), (int)5, (int)0).toUnscaledLong()).isEqualTo(5L);
        Assertions.assertThat((long)DecimalDataUtils.castToIntegral((DecimalData)decimal1)).isEqualTo(10L);
        Assertions.assertThat((boolean)DecimalDataUtils.castToBoolean((DecimalData)decimal1)).isTrue();
        Assertions.assertThat((int)DecimalDataUtils.compare((DecimalData)decimal1, (long)10L)).isEqualTo(0);
        Assertions.assertThat((int)DecimalDataUtils.compare((DecimalData)decimal1, (long)5L)).isGreaterThan(0);
        Assertions.assertThat((Comparable)DecimalDataUtils.sign((DecimalData)DecimalDataUtils.castFrom((double)5.556, (int)10, (int)5))).isEqualTo((Object)DecimalDataUtils.castFrom((double)1.0, (int)10, (int)5));
        Assertions.assertThat((Comparable)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(Long.MAX_VALUE), (int)5, (int)0)).isNull();
        Assertions.assertThat((int)DecimalData.zero((int)5, (int)2).toBigDecimal().intValue()).isEqualTo(0);
        Assertions.assertThat((int)DecimalData.zero((int)20, (int)2).toBigDecimal().intValue()).isEqualTo(0);
        Assertions.assertThat((Comparable)DecimalDataUtils.floor((DecimalData)DecimalDataUtils.castFrom((double)10.5, (int)5, (int)1))).isEqualTo((Object)DecimalData.fromUnscaledLong((long)10L, (int)5, (int)0));
        Assertions.assertThat((Comparable)DecimalDataUtils.ceil((DecimalData)DecimalDataUtils.castFrom((double)10.5, (int)5, (int)1))).isEqualTo((Object)DecimalData.fromUnscaledLong((long)11L, (int)5, (int)0));
        Assertions.assertThat((String)DecimalDataUtils.castToDecimal((DecimalData)DecimalDataUtils.castFrom((double)5.0, (int)10, (int)1), (int)10, (int)2).toString()).isEqualTo("5.00");
        Assertions.assertThat((long)DecimalDataUtils.castToIntegral((DecimalData)DecimalDataUtils.castFrom((long)5L, (int)5, (int)0))).isEqualTo(5L);
        Assertions.assertThat((long)DecimalDataUtils.castToIntegral((DecimalData)DecimalDataUtils.castFrom((String)"5", (int)5, (int)0))).isEqualTo(5L);
        DecimalData newDecimal = DecimalDataUtils.castFrom((DecimalData)DecimalDataUtils.castFrom((long)10L, (int)5, (int)2), (int)10, (int)4);
        Assertions.assertThat((int)newDecimal.precision()).isEqualTo(10);
        Assertions.assertThat((int)newDecimal.scale()).isEqualTo(4);
        Assertions.assertThat((boolean)DecimalDataUtils.is32BitDecimal((int)6)).isTrue();
        Assertions.assertThat((boolean)DecimalDataUtils.is64BitDecimal((int)11)).isTrue();
        Assertions.assertThat((boolean)DecimalDataUtils.isByteArrayDecimal((int)20)).isTrue();
        Assertions.assertThat((long)DecimalDataUtils.sround((DecimalData)DecimalDataUtils.castFrom((double)5.555, (int)5, (int)0), (int)1).toUnscaledLong()).isEqualTo(6L);
        Assertions.assertThat((long)DecimalDataUtils.sround((DecimalData)DecimalDataUtils.castFrom((double)5.555, (int)5, (int)3), (int)1).toUnscaledLong()).isEqualTo(56L);
    }

    @Test
    public void testNotCompact() {
        DecimalData decimal1 = DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0);
        DecimalData decimal2 = DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(15), (int)20, (int)0);
        Assertions.assertThat((int)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0).hashCode()).isEqualTo(decimal1.hashCode());
        Assertions.assertThat((Comparable)decimal1.copy()).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)DecimalData.fromBigDecimal((BigDecimal)decimal1.toBigDecimal(), (int)20, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)DecimalData.fromUnscaledBytes((byte[])decimal1.toUnscaledBytes(), (int)20, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((int)decimal1.compareTo(decimal2)).isLessThan(0);
        Assertions.assertThat((int)DecimalDataUtils.signum((DecimalData)decimal1)).isEqualTo(1);
        Assertions.assertThat((double)DecimalDataUtils.doubleValue((DecimalData)DecimalDataUtils.castFrom((double)10.5, (int)20, (int)1))).isEqualTo(10.5);
        Assertions.assertThat((Comparable)DecimalDataUtils.negate((DecimalData)decimal1)).isEqualTo((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(-10), (int)20, (int)0));
        Assertions.assertThat((Comparable)DecimalDataUtils.abs((DecimalData)decimal1)).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)DecimalDataUtils.abs((DecimalData)DecimalDataUtils.negate((DecimalData)decimal1))).isEqualTo((Object)decimal1);
        Assertions.assertThat((long)DecimalDataUtils.add((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)0).toBigDecimal().longValue()).isEqualTo(25L);
        Assertions.assertThat((long)DecimalDataUtils.subtract((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)0).toBigDecimal().longValue()).isEqualTo(-5L);
        Assertions.assertThat((long)DecimalDataUtils.multiply((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)0).toBigDecimal().longValue()).isEqualTo(150L);
        Assertions.assertThat((double)DecimalDataUtils.doubleValue((DecimalData)DecimalDataUtils.divide((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)2))).isEqualTo(0.67);
        Assertions.assertThat((Comparable)DecimalDataUtils.mod((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((long)DecimalDataUtils.divideToIntegralValue((DecimalData)decimal1, (DecimalData)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(2), (int)20, (int)0), (int)20, (int)0).toBigDecimal().longValue()).isEqualTo(5L);
        Assertions.assertThat((long)DecimalDataUtils.castToIntegral((DecimalData)decimal1)).isEqualTo(10L);
        Assertions.assertThat((boolean)DecimalDataUtils.castToBoolean((DecimalData)decimal1)).isTrue();
        Assertions.assertThat((int)DecimalDataUtils.compare((DecimalData)decimal1, (long)10L)).isEqualTo(0);
        Assertions.assertThat((int)DecimalDataUtils.compare((DecimalData)decimal1, (long)5L)).isGreaterThan(0);
        Assertions.assertThat((int)DecimalDataUtils.compare((DecimalData)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("10.5"), (int)20, (int)2), (long)10L)).isGreaterThan(0);
        Assertions.assertThat((Comparable)DecimalDataUtils.sign((DecimalData)DecimalDataUtils.castFrom((double)5.556, (int)20, (int)5))).isEqualTo((Object)DecimalDataUtils.castFrom((double)1.0, (int)20, (int)5));
        Assertions.assertThat((Comparable)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(Long.MAX_VALUE), (int)5, (int)0)).isNull();
        Assertions.assertThat((int)DecimalData.zero((int)20, (int)2).toBigDecimal().intValue()).isEqualTo(0);
        Assertions.assertThat((int)DecimalData.zero((int)20, (int)2).toBigDecimal().intValue()).isEqualTo(0);
    }

    @Test
    public void testToString() {
        String val = "0.0000000000000000001";
        Assertions.assertThat((String)DecimalDataUtils.castFrom((String)val, (int)39, (int)(val.length() - 2)).toString()).isEqualTo(val);
        val = "123456789012345678901234567890123456789";
        Assertions.assertThat((String)DecimalDataUtils.castFrom((String)val, (int)39, (int)0).toString()).isEqualTo(val);
    }
}

