/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public interface ModelChange {
    public static SetOption set(String key, String value) {
        return new SetOption(key, value);
    }

    public static ResetOption reset(String key) {
        return new ResetOption(key);
    }

    @PublicEvolving
    public static class ResetOption
    implements ModelChange {
        private final String key;

        public ResetOption(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResetOption)) {
                return false;
            }
            ResetOption that = (ResetOption)o;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return "ResetOption{key='" + this.key + "'}";
        }
    }

    @PublicEvolving
    public static class SetOption
    implements ModelChange {
        private final String key;
        private final String value;

        public SetOption(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetOption)) {
                return false;
            }
            SetOption setOption = (SetOption)o;
            return Objects.equals(this.key, setOption.key) && Objects.equals(this.value, setOption.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "SetOption{key='" + this.key + "', value='" + this.value + "'}";
        }
    }
}

