/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.DefaultIndex;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.utils.ResolvedExpressionMock;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TableSchemaUtilsTest {
    TableSchemaUtilsTest() {
    }

    @Test
    void testBuilderWithGivenSchema() {
        TableSchema oriSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        TableSchema newSchema = TableSchemaUtils.builderWithGivenSchema((TableSchema)oriSchema).build();
        Assertions.assertThat((Object)newSchema).isEqualTo((Object)oriSchema);
    }

    @Test
    void testDropConstraint() {
        TableSchema originalSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        TableSchema newSchema = TableSchemaUtils.dropConstraint((TableSchema)originalSchema, (String)"ct1");
        TableSchema expectedSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        Assertions.assertThat((Object)newSchema).isEqualTo((Object)expectedSchema);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableSchemaUtils.dropConstraint((TableSchema)originalSchema, (String)"ct2")).isInstanceOf(ValidationException.class)).hasMessage("Constraint ct2 to drop does not exist");
    }

    @Test
    void testRemoveTimeAttribute() {
        DataType rowTimeType = DataTypeUtils.replaceLogicalType((DataType)DataTypes.TIMESTAMP((int)3), (LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 3));
        ResolvedSchema schema = new ResolvedSchema(Arrays.asList(Column.physical((String)"id", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"t", (DataType)rowTimeType), Column.computed((String)"date", (ResolvedExpression)ResolvedExpressionMock.of(DataTypes.DATE(), "TO_DATE(t)")), Column.metadata((String)"metadata-1", (DataType)DataTypes.INT(), (String)"metadata", (boolean)false)), Collections.singletonList(WatermarkSpec.of((String)"t", (ResolvedExpression)ResolvedExpressionMock.of(rowTimeType, "t"))), UniqueConstraint.primaryKey((String)"test-pk", Collections.singletonList("id")), Collections.singletonList(DefaultIndex.newIndex((String)"idx", Collections.singletonList("id"))));
        Assertions.assertThat((Object)TableSchemaUtils.removeTimeAttributeFromResolvedSchema((ResolvedSchema)schema)).isEqualTo((Object)new ResolvedSchema(Arrays.asList(Column.physical((String)"id", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"t", (DataType)DataTypes.TIMESTAMP((int)3)), Column.computed((String)"date", (ResolvedExpression)new ResolvedExpressionMock(DataTypes.DATE(), () -> "TO_DATE(t)")), Column.metadata((String)"metadata-1", (DataType)DataTypes.INT(), (String)"metadata", (boolean)false)), Collections.singletonList(WatermarkSpec.of((String)"t", (ResolvedExpression)ResolvedExpressionMock.of(rowTimeType, "t"))), UniqueConstraint.primaryKey((String)"test-pk", Collections.singletonList("id")), Collections.singletonList(DefaultIndex.newIndex((String)"idx", Collections.singletonList("id")))));
    }
}

