/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DescriptorType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.VariantType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class LogicalTypeParserTest {
    private static Stream<TestSpec> testData() {
        return Stream.of(TestSpec.forString("CHAR").expectType((LogicalType)new CharType()), TestSpec.forString("CHAR NOT NULL").expectType(new CharType().copy(false)), TestSpec.forString("CHAR   NOT \t\nNULL").expectType(new CharType().copy(false)), TestSpec.forString("char not null").expectType(new CharType().copy(false)), TestSpec.forString("CHAR NULL").expectType((LogicalType)new CharType()), TestSpec.forString("CHAR(33)").expectType((LogicalType)new CharType(33)), TestSpec.forString("VARCHAR").expectType((LogicalType)new VarCharType()), TestSpec.forString("VARCHAR(33)").expectType((LogicalType)new VarCharType(33)), TestSpec.forString("STRING").expectType((LogicalType)VarCharType.STRING_TYPE), TestSpec.forString("BOOLEAN").expectType((LogicalType)new BooleanType()), TestSpec.forString("BINARY").expectType((LogicalType)new BinaryType()), TestSpec.forString("BINARY(33)").expectType((LogicalType)new BinaryType(33)), TestSpec.forString("VARBINARY").expectType((LogicalType)new VarBinaryType()), TestSpec.forString("VARBINARY(33)").expectType((LogicalType)new VarBinaryType(33)), TestSpec.forString("BYTES").expectType((LogicalType)new VarBinaryType(Integer.MAX_VALUE)), TestSpec.forString("DECIMAL").expectType((LogicalType)new DecimalType()), TestSpec.forString("DEC").expectType((LogicalType)new DecimalType()), TestSpec.forString("NUMERIC").expectType((LogicalType)new DecimalType()), TestSpec.forString("DECIMAL(10)").expectType((LogicalType)new DecimalType(10)), TestSpec.forString("DEC(10)").expectType((LogicalType)new DecimalType(10)), TestSpec.forString("NUMERIC(10)").expectType((LogicalType)new DecimalType(10)), TestSpec.forString("DECIMAL(10, 3)").expectType((LogicalType)new DecimalType(10, 3)), TestSpec.forString("DEC(10, 3)").expectType((LogicalType)new DecimalType(10, 3)), TestSpec.forString("NUMERIC(10, 3)").expectType((LogicalType)new DecimalType(10, 3)), TestSpec.forString("TINYINT").expectType((LogicalType)new TinyIntType()), TestSpec.forString("SMALLINT").expectType((LogicalType)new SmallIntType()), TestSpec.forString("INTEGER").expectType((LogicalType)new IntType()), TestSpec.forString("INT").expectType((LogicalType)new IntType()), TestSpec.forString("BIGINT").expectType((LogicalType)new BigIntType()), TestSpec.forString("FLOAT").expectType((LogicalType)new FloatType()), TestSpec.forString("DOUBLE").expectType((LogicalType)new DoubleType()), TestSpec.forString("DOUBLE PRECISION").expectType((LogicalType)new DoubleType()), TestSpec.forString("DATE").expectType((LogicalType)new DateType()), TestSpec.forString("TIME").expectType((LogicalType)new TimeType()), TestSpec.forString("TIME(3)").expectType((LogicalType)new TimeType(3)), TestSpec.forString("TIME WITHOUT TIME ZONE").expectType((LogicalType)new TimeType()), TestSpec.forString("TIME(3) WITHOUT TIME ZONE").expectType((LogicalType)new TimeType(3)), TestSpec.forString("TIMESTAMP").expectType((LogicalType)new TimestampType()), TestSpec.forString("TIMESTAMP(3)").expectType((LogicalType)new TimestampType(3)), TestSpec.forString("TIMESTAMP WITHOUT TIME ZONE").expectType((LogicalType)new TimestampType()), TestSpec.forString("TIMESTAMP(3) WITHOUT TIME ZONE").expectType((LogicalType)new TimestampType(3)), TestSpec.forString("TIMESTAMP WITH TIME ZONE").expectType((LogicalType)new ZonedTimestampType()), TestSpec.forString("TIMESTAMP(3) WITH TIME ZONE").expectType((LogicalType)new ZonedTimestampType(3)), TestSpec.forString("TIMESTAMP WITH LOCAL TIME ZONE").expectType((LogicalType)new LocalZonedTimestampType()), TestSpec.forString("TIMESTAMP_LTZ").expectType((LogicalType)new LocalZonedTimestampType()), TestSpec.forString("TIMESTAMP(3) WITH LOCAL TIME ZONE").expectType((LogicalType)new LocalZonedTimestampType(3)), TestSpec.forString("TIMESTAMP_LTZ(3)").expectType((LogicalType)new LocalZonedTimestampType(3)), TestSpec.forString("INTERVAL YEAR").expectType((LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR)), TestSpec.forString("INTERVAL YEAR(4)").expectType((LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR, 4)), TestSpec.forString("INTERVAL MONTH").expectType((LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH)), TestSpec.forString("INTERVAL YEAR TO MONTH").expectType((LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH)), TestSpec.forString("INTERVAL YEAR(4) TO MONTH").expectType((LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH, 4)), TestSpec.forString("INTERVAL DAY(2) TO SECOND(3)").expectType((LogicalType)new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 3)), TestSpec.forString("INTERVAL HOUR TO SECOND(3)").expectType((LogicalType)new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_SECOND, 2, 3)), TestSpec.forString("INTERVAL MINUTE").expectType((LogicalType)new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE)), TestSpec.forString("DESCRIPTOR").expectType((LogicalType)new DescriptorType()), TestSpec.forString("ARRAY<TIMESTAMP(3) WITH LOCAL TIME ZONE>").expectType((LogicalType)new ArrayType((LogicalType)new LocalZonedTimestampType(3))), TestSpec.forString("ARRAY<INT NOT NULL>").expectType((LogicalType)new ArrayType((LogicalType)new IntType(false))), TestSpec.forString("INT ARRAY").expectType((LogicalType)new ArrayType((LogicalType)new IntType())), TestSpec.forString("INT NOT NULL ARRAY").expectType((LogicalType)new ArrayType((LogicalType)new IntType(false))), TestSpec.forString("INT ARRAY NOT NULL").expectType((LogicalType)new ArrayType(false, (LogicalType)new IntType())), TestSpec.forString("MULTISET<INT NOT NULL>").expectType((LogicalType)new MultisetType((LogicalType)new IntType(false))), TestSpec.forString("INT MULTISET").expectType((LogicalType)new MultisetType((LogicalType)new IntType())), TestSpec.forString("INT NOT NULL MULTISET").expectType((LogicalType)new MultisetType((LogicalType)new IntType(false))), TestSpec.forString("INT MULTISET NOT NULL").expectType((LogicalType)new MultisetType(false, (LogicalType)new IntType())), TestSpec.forString("MAP<BIGINT, BOOLEAN>").expectType((LogicalType)new MapType((LogicalType)new BigIntType(), (LogicalType)new BooleanType())), TestSpec.forString("ROW<f0 INT NOT NULL, f1 BOOLEAN>").expectType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f0", (LogicalType)new IntType(false)), new RowType.RowField("f1", (LogicalType)new BooleanType())))), TestSpec.forString("ROW(f0 INT NOT NULL, f1 BOOLEAN)").expectType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f0", (LogicalType)new IntType(false)), new RowType.RowField("f1", (LogicalType)new BooleanType())))), TestSpec.forString("ROW<`f0` INT>").expectType((LogicalType)new RowType(Collections.singletonList(new RowType.RowField("f0", (LogicalType)new IntType())))), TestSpec.forString("ROW(`f0` INT)").expectType((LogicalType)new RowType(Collections.singletonList(new RowType.RowField("f0", (LogicalType)new IntType())))), TestSpec.forString("ROW<>").expectType((LogicalType)new RowType(Collections.emptyList())), TestSpec.forString("ROW()").expectType((LogicalType)new RowType(Collections.emptyList())), TestSpec.forString("ROW<f0 INT NOT NULL 'This is a comment.', f1 BOOLEAN 'This as well.'>").expectType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f0", (LogicalType)new IntType(false), "This is a comment."), new RowType.RowField("f1", (LogicalType)new BooleanType(), "This as well.")))), TestSpec.forString("ROW<f0 INT NOT NULL, f1 BOOLEAN>").expectType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f0", (LogicalType)new IntType(false)), new RowType.RowField("f1", (LogicalType)new BooleanType())))), TestSpec.forString("STRUCTURED<'org.apache.flink.NonExistingType', name STRING NOT NULL, `age` INT, city STRING 'Comment'>").expectType((LogicalType)StructuredType.newBuilder((String)"org.apache.flink.NonExistingType").attributes(List.of(new StructuredType.StructuredAttribute("name", VarCharType.STRING_TYPE.copy(false)), new StructuredType.StructuredAttribute("age", (LogicalType)new IntType()), new StructuredType.StructuredAttribute("city", (LogicalType)VarCharType.STRING_TYPE, "Comment"))).build()), TestSpec.forString("STRUCTURED<'org.apache.flink.NonExistingType', name STRING, `udt` MY_TYPE>").expectType((LogicalType)StructuredType.newBuilder((String)"org.apache.flink.NonExistingType").attributes(List.of(new StructuredType.StructuredAttribute("name", (LogicalType)VarCharType.STRING_TYPE), new StructuredType.StructuredAttribute("udt", (LogicalType)new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"MY_TYPE"}))))).build()), TestSpec.forString("STRUCTURED<'" + MyPojo.class.getName() + "', name STRING, `age` INT NOT NULL>").expectType((LogicalType)StructuredType.newBuilder(MyPojo.class).attributes(List.of(new StructuredType.StructuredAttribute("name", (LogicalType)VarCharType.STRING_TYPE), new StructuredType.StructuredAttribute("age", (LogicalType)new IntType(false)))).build()), TestSpec.forString("STRUCTURED<'" + MyPojo.class.getName() + "'>").expectType((LogicalType)StructuredType.newBuilder(MyPojo.class).attributes(List.of()).build()), TestSpec.forString("STRUCTURED<'" + MyPojo.class.getName() + "'>").expectType((LogicalType)StructuredType.newBuilder(MyPojo.class).attributes(List.of()).build()), TestSpec.forString("NULL").expectType((LogicalType)new NullType()), TestSpec.forString(LogicalTypeParserTest.createRawType(LogicalTypeParserTest.class).asSerializableString()).expectType((LogicalType)LogicalTypeParserTest.createRawType(LogicalTypeParserTest.class)), TestSpec.forString("cat.db.MyType").expectType((LogicalType)new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"cat", "db", "MyType"}))), TestSpec.forString("`db`.`MyType`").expectType((LogicalType)new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"db", "MyType"}))), TestSpec.forString("MyType").expectType((LogicalType)new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"MyType"}))), TestSpec.forString("ARRAY<MyType>").expectType((LogicalType)new ArrayType((LogicalType)new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"MyType"})))), TestSpec.forString("ROW<f0 MyType, f1 `c`.`d`.`t`>").expectType((LogicalType)RowType.of((LogicalType[])new LogicalType[]{new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"MyType"})), new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"c", "d", "t"}))})), TestSpec.forString("LEGACY('STRUCTURED_TYPE', 'POJO<org.apache.flink.table.types.LogicalTypeParserTest$MyPojo>')").expectType((LogicalType)LogicalTypeParserTest.createPojoLegacyType()), TestSpec.forString("LEGACY('DECIMAL', 'DECIMAL')").expectType(TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.BIG_DEC).getLogicalType()), TestSpec.forString("LEGACY('RAW', 'ANY<org.apache.flink.table.types.LogicalTypeParserTest>')").expectType((LogicalType)LogicalTypeParserTest.createGenericLegacyType()), TestSpec.forString("VARIANT").expectType((LogicalType)new VariantType()), TestSpec.forString("VARIANT NOT NULL").expectType((LogicalType)new VariantType(false)), TestSpec.forString("ROW<`f0").expectErrorMessage("Unexpected end"), TestSpec.forString("ROW<`f0`").expectErrorMessage("Unexpected end"), TestSpec.forString("VARCHAR(test)").expectErrorMessage("<LITERAL_INT> expected"), TestSpec.forString("VARCHAR(33333333333)").expectErrorMessage("Invalid integer value"), TestSpec.forString("ROW<field INT, field2>").expectErrorMessage("<KEYWORD> expected"), TestSpec.forString("RAW('unknown.class', '')").expectErrorMessage("Unable to restore the RAW type"));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testParsing(TestSpec testSpec) {
        if (testSpec.expectedType != null) {
            Assertions.assertThat((Object)LogicalTypeParser.parse((String)testSpec.typeString, (ClassLoader)Thread.currentThread().getContextClassLoader())).isEqualTo((Object)testSpec.expectedType);
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testSerializableParsing(TestSpec testSpec) {
        if (testSpec.expectedType != null && !testSpec.expectedType.is(LogicalTypeRoot.UNRESOLVED) && testSpec.expectedType.getChildren().stream().noneMatch(t -> t.is(LogicalTypeRoot.UNRESOLVED))) {
            Assertions.assertThat((Object)LogicalTypeParser.parse((String)testSpec.expectedType.asSerializableString(), (ClassLoader)Thread.currentThread().getContextClassLoader())).isEqualTo((Object)testSpec.expectedType);
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testErrorMessage(TestSpec testSpec) {
        if (testSpec.expectedErrorMessage != null) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LogicalTypeParser.parse((String)testSpec.typeString, (ClassLoader)Thread.currentThread().getContextClassLoader())).isInstanceOf(ValidationException.class)).hasMessageContaining(testSpec.expectedErrorMessage);
        }
    }

    private static <T> RawType<T> createRawType(Class<T> clazz) {
        return new RawType(clazz, (TypeSerializer)new KryoSerializer(clazz, (SerializerConfig)new SerializerConfigImpl()));
    }

    private static LegacyTypeInformationType<MyPojo> createPojoLegacyType() {
        TypeInformation typeInfo = TypeExtractor.createTypeInfo(MyPojo.class);
        return (LegacyTypeInformationType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)typeInfo).getLogicalType();
    }

    private static LegacyTypeInformationType<MyPojo> createGenericLegacyType() {
        GenericTypeInfo typeInfo = new GenericTypeInfo(LogicalTypeParserTest.class);
        return (LegacyTypeInformationType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)typeInfo).getLogicalType();
    }

    public static class MyPojo {
        public String name;
        public int age;
    }

    private static class TestSpec {
        private final String typeString;
        @Nullable
        private LogicalType expectedType;
        @Nullable
        private String expectedErrorMessage;

        private TestSpec(String typeString) {
            this.typeString = typeString;
        }

        static TestSpec forString(String typeString) {
            return new TestSpec(typeString);
        }

        TestSpec expectType(LogicalType expectedType) {
            this.expectedType = expectedType;
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public String toString() {
            return this.typeString;
        }
    }
}

