/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TableStatsTest {
    TableStatsTest() {
    }

    @Test
    void testMerge() {
        HashMap<String, ColumnStats> colStats1 = new HashMap<String, ColumnStats>();
        colStats1.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        TableStats stats1 = new TableStats(30L, colStats1);
        HashMap<String, ColumnStats> colStats2 = new HashMap<String, ColumnStats>();
        colStats2.put("a", new ColumnStats(Long.valueOf(3L), Long.valueOf(15L), Double.valueOf(12.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(6)));
        TableStats stats2 = new TableStats(32L, colStats2);
        HashMap<String, ColumnStats> colStatsMerge = new HashMap<String, ColumnStats>();
        colStatsMerge.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)stats1.merge(stats2, null)).isEqualTo((Object)new TableStats(62L, colStatsMerge));
        HashMap<String, ColumnStats> colStatsMerge2 = new HashMap<String, ColumnStats>();
        colStatsMerge2.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)stats1.merge(stats2, new HashSet())).isEqualTo((Object)new TableStats(62L, colStatsMerge2));
        HashMap<String, ColumnStats> colStatsMerge3 = new HashMap<String, ColumnStats>();
        colStatsMerge3.put("a", new ColumnStats(Long.valueOf(7L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)stats1.merge(stats2, new HashSet<String>(Collections.singletonList("a")))).isEqualTo((Object)new TableStats(62L, colStatsMerge3));
        HashMap<String, ColumnStats> colStats3 = new HashMap<String, ColumnStats>();
        colStats3.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        colStats3.put("b", new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        stats1 = new TableStats(30L, colStats3);
        HashMap<String, ColumnStats> colStats4 = new HashMap<String, ColumnStats>();
        colStats4.put("a", new ColumnStats(Long.valueOf(3L), Long.valueOf(15L), Double.valueOf(12.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(6)));
        colStats4.put("b", new ColumnStats(Long.valueOf(3L), Long.valueOf(15L), Double.valueOf(12.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(6)));
        stats2 = new TableStats(32L, colStats4);
        HashMap<String, ColumnStats> colStatsMerge4 = new HashMap<String, ColumnStats>();
        colStatsMerge4.put("a", new ColumnStats(Long.valueOf(7L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(2)));
        colStatsMerge4.put("b", new ColumnStats(Long.valueOf(4L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)stats1.merge(stats2, new HashSet<String>(Collections.singletonList("a")))).isEqualTo((Object)new TableStats(62L, colStatsMerge4));
        stats2 = TableStats.UNKNOWN;
        Assertions.assertThat((Object)stats1.merge(stats2, null)).isEqualTo((Object)TableStats.UNKNOWN);
        stats2 = new TableStats(32L);
        Assertions.assertThat((Object)stats1.merge(stats2, null)).isEqualTo((Object)new TableStats(62L));
    }

    @Test
    void testMergeLackColumnStats() {
        HashMap<String, ColumnStats> colStats1 = new HashMap<String, ColumnStats>();
        colStats1.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        colStats1.put("b", new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        TableStats stats1 = new TableStats(30L, colStats1);
        HashMap<String, ColumnStats> colStats2 = new HashMap<String, ColumnStats>();
        colStats2.put("a", new ColumnStats(Long.valueOf(3L), Long.valueOf(15L), Double.valueOf(12.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(6)));
        TableStats stats2 = new TableStats(32L, colStats2);
        HashMap<String, ColumnStats> colStatsMerge = new HashMap<String, ColumnStats>();
        colStatsMerge.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)stats1.merge(stats2, null)).isEqualTo((Object)new TableStats(62L, colStatsMerge));
        HashMap<String, ColumnStats> colStatsMerge2 = new HashMap<String, ColumnStats>();
        colStatsMerge2.put("a", new ColumnStats(Long.valueOf(4L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)stats1.merge(stats2, new HashSet())).isEqualTo((Object)new TableStats(62L, colStatsMerge2));
        HashMap<String, ColumnStats> colStatsMerge3 = new HashMap<String, ColumnStats>();
        colStatsMerge3.put("a", new ColumnStats(Long.valueOf(7L), Long.valueOf(20L), Double.valueOf(7.0), Integer.valueOf(23), (Comparable)Integer.valueOf(35), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)stats1.merge(stats2, new HashSet<String>(Collections.singletonList("a")))).isEqualTo((Object)new TableStats(62L, colStatsMerge3));
    }

    @Test
    void testMergeUnknownRowCount() {
        TableStats stats1 = new TableStats(-1L, new HashMap());
        TableStats stats2 = new TableStats(32L, new HashMap());
        Assertions.assertThat((Object)stats1.merge(stats2, null)).isEqualTo((Object)TableStats.UNKNOWN);
        stats1 = new TableStats(-1L, new HashMap());
        stats2 = new TableStats(-1L, new HashMap());
        Assertions.assertThat((Object)stats1.merge(stats2, null)).isEqualTo((Object)TableStats.UNKNOWN);
        stats1 = new TableStats(-3L, new HashMap());
        stats2 = new TableStats(-2L, new HashMap());
        Assertions.assertThat((Object)stats1.merge(stats2, null)).isEqualTo((Object)TableStats.UNKNOWN);
    }

    @Test
    void testMergeColumnStatsUnknown() {
        ColumnStats columnStats0 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2));
        ColumnStats columnStats1 = new ColumnStats(Long.valueOf(4L), null, Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2));
        ColumnStats columnStats2 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), null, (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2));
        ColumnStats columnStats3 = new ColumnStats(null, Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2));
        ColumnStats columnStats4 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), null, (Comparable)Integer.valueOf(2));
        ColumnStats columnStats5 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), null);
        ColumnStats columnStats6 = new ColumnStats(Long.valueOf(4L), Long.valueOf(5L), null, Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2));
        Assertions.assertThat((Object)columnStats0.merge(columnStats1, false)).isEqualTo((Object)new ColumnStats(Long.valueOf(4L), null, Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)columnStats0.merge(columnStats2, false)).isEqualTo((Object)new ColumnStats(Long.valueOf(4L), Long.valueOf(10L), Double.valueOf(2.0), null, (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)columnStats0.merge(columnStats3, false)).isEqualTo((Object)new ColumnStats(null, Long.valueOf(10L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)columnStats0.merge(columnStats4, false)).isEqualTo((Object)new ColumnStats(Long.valueOf(4L), Long.valueOf(10L), Double.valueOf(2.0), Integer.valueOf(3), null, (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)columnStats0.merge(columnStats5, false)).isEqualTo((Object)new ColumnStats(Long.valueOf(4L), Long.valueOf(10L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), null));
        Assertions.assertThat((Object)columnStats0.merge(columnStats6, false)).isEqualTo((Object)new ColumnStats(Long.valueOf(4L), Long.valueOf(10L), null, Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)columnStats6.merge(columnStats6, false)).isEqualTo((Object)new ColumnStats(Long.valueOf(4L), Long.valueOf(10L), null, Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)columnStats0.merge(columnStats1, true)).isEqualTo((Object)new ColumnStats(Long.valueOf(8L), null, Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
        Assertions.assertThat((Object)columnStats0.merge(columnStats3, true)).isEqualTo((Object)new ColumnStats(null, Long.valueOf(10L), Double.valueOf(2.0), Integer.valueOf(3), (Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(2)));
    }
}

