/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.legacy.api.TableColumn;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.LogicalTypeParserTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DescriptorPropertiesTest {
    private static final String ARRAY_KEY = "my-array";
    private static final String FIXED_INDEXED_PROPERTY_KEY = "my-fixed-indexed-property";
    private static final String PROPERTY_1_KEY = "property-1";
    private static final String PROPERTY_2_KEY = "property-2";

    DescriptorPropertiesTest() {
    }

    @Test
    void testEquals() {
        DescriptorProperties properties1 = new DescriptorProperties();
        properties1.putString("hello1", "12");
        properties1.putString("hello2", "13");
        properties1.putString("hello3", "14");
        DescriptorProperties properties2 = new DescriptorProperties();
        properties2.putString("hello1", "12");
        properties2.putString("hello2", "13");
        properties2.putString("hello3", "14");
        DescriptorProperties properties3 = new DescriptorProperties();
        properties3.putString("hello1", "12");
        properties3.putString("hello3", "14");
        properties3.putString("hello2", "13");
        Assertions.assertThat((Object)properties2).isEqualTo((Object)properties1);
        Assertions.assertThat((Object)properties3).isEqualTo((Object)properties1);
    }

    @Test
    void testMissingArray() {
        DescriptorProperties properties = new DescriptorProperties();
        this.testArrayValidation(properties, 0, Integer.MAX_VALUE);
    }

    @Test
    void testArrayValues() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("my-array.0", "12");
        properties.putString("my-array.1", "42");
        properties.putString("my-array.2", "66");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
        Assertions.assertThat((List)properties.getArray(ARRAY_KEY, arg_0 -> ((DescriptorProperties)properties).getInt(arg_0))).isEqualTo(Arrays.asList(12, 42, 66));
    }

    @Test
    void testArraySingleValue() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(ARRAY_KEY, "12");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
        Assertions.assertThat((List)properties.getArray(ARRAY_KEY, arg_0 -> ((DescriptorProperties)properties).getInt(arg_0))).isEqualTo(Collections.singletonList(12));
    }

    @Test
    void testArrayInvalidValues() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("my-array.0", "12");
        properties.putString("my-array.1", "66");
        properties.putString("my-array.2", "INVALID");
        Assertions.assertThatThrownBy(() -> this.testArrayValidation(properties, 1, Integer.MAX_VALUE)).isInstanceOf(ValidationException.class);
    }

    @Test
    void testArrayInvalidSingleValue() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(ARRAY_KEY, "INVALID");
        Assertions.assertThatThrownBy(() -> this.testArrayValidation(properties, 1, Integer.MAX_VALUE)).isInstanceOf(ValidationException.class);
    }

    @Test
    void testInvalidMissingArray() {
        DescriptorProperties properties = new DescriptorProperties();
        Assertions.assertThatThrownBy(() -> this.testArrayValidation(properties, 1, Integer.MAX_VALUE)).isInstanceOf(ValidationException.class);
    }

    @Test
    void testInvalidFixedIndexedProperties() {
        DescriptorProperties property = new DescriptorProperties();
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        list.add(Arrays.asList("1", "string"));
        list.add(Arrays.asList("INVALID", "string"));
        property.putIndexedFixedProperties(FIXED_INDEXED_PROPERTY_KEY, Arrays.asList(PROPERTY_1_KEY, PROPERTY_2_KEY), list);
        Assertions.assertThatThrownBy(() -> this.testFixedIndexedPropertiesValidation(property)).isInstanceOf(ValidationException.class);
    }

    @Test
    void testRemoveKeys() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("hello1", "12");
        properties.putString("hello2", "13");
        properties.putString("hello3", "14");
        DescriptorProperties actual = properties.withoutKeys(Arrays.asList("hello1", "hello3"));
        DescriptorProperties expected = new DescriptorProperties();
        expected.putString("hello2", "13");
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    void testPrefixedMap() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("hello1", "12");
        properties.putString("hello2", "13");
        properties.putString("hello3", "14");
        Map actual = properties.asPrefixedMap("prefix.");
        DescriptorProperties expected = new DescriptorProperties();
        expected.putString("prefix.hello1", "12");
        expected.putString("prefix.hello2", "13");
        expected.putString("prefix.hello3", "14");
        Assertions.assertThat((Map)actual).isEqualTo((Object)expected.asMap());
    }

    @Test
    void testTableSchema() {
        TableSchema schema = TableSchema.builder().add((TableColumn)TableColumn.physical((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))).add((TableColumn)TableColumn.physical((String)"f1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)9))}))).add((TableColumn)TableColumn.physical((String)"f2", (DataType)((DataType)DataTypes.STRING().notNull()))).add((TableColumn)TableColumn.computed((String)"f3", (DataType)((DataType)DataTypes.BIGINT().notNull()), (String)"f0 + 1")).add((TableColumn)TableColumn.physical((String)"f4", (DataType)DataTypes.DECIMAL((int)10, (int)3))).add((TableColumn)TableColumn.metadata((String)"f5", (DataType)DataTypes.DECIMAL((int)10, (int)3))).add((TableColumn)TableColumn.metadata((String)"f6", (DataType)DataTypes.INT(), (String)"other.key")).add((TableColumn)TableColumn.metadata((String)"f7", (DataType)DataTypes.INT(), (boolean)true)).add((TableColumn)TableColumn.metadata((String)"f8", (DataType)DataTypes.INT(), (String)"other.key", (boolean)true)).watermark("f1.q2", "`f1`.`q2` - INTERVAL '5' SECOND", DataTypes.TIMESTAMP((int)3)).primaryKey("constraint1", new String[]{"f0", "f2"}).build();
        DescriptorProperties properties = new DescriptorProperties();
        properties.putTableSchema("schema", schema);
        Map actual = properties.asMap();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("schema.0.name", "f0");
        expected.put("schema.0.data-type", "BIGINT NOT NULL");
        expected.put("schema.1.name", "f1");
        expected.put("schema.1.data-type", "ROW<`q1` VARCHAR(2147483647), `q2` TIMESTAMP(9)>");
        expected.put("schema.2.name", "f2");
        expected.put("schema.2.data-type", "VARCHAR(2147483647) NOT NULL");
        expected.put("schema.3.name", "f3");
        expected.put("schema.3.data-type", "BIGINT NOT NULL");
        expected.put("schema.3.expr", "f0 + 1");
        expected.put("schema.4.name", "f4");
        expected.put("schema.4.data-type", "DECIMAL(10, 3)");
        expected.put("schema.5.name", "f5");
        expected.put("schema.5.data-type", "DECIMAL(10, 3)");
        expected.put("schema.5.metadata", "f5");
        expected.put("schema.5.virtual", "false");
        expected.put("schema.6.name", "f6");
        expected.put("schema.6.data-type", "INT");
        expected.put("schema.6.metadata", "other.key");
        expected.put("schema.6.virtual", "false");
        expected.put("schema.7.name", "f7");
        expected.put("schema.7.data-type", "INT");
        expected.put("schema.7.metadata", "f7");
        expected.put("schema.7.virtual", "true");
        expected.put("schema.8.name", "f8");
        expected.put("schema.8.data-type", "INT");
        expected.put("schema.8.metadata", "other.key");
        expected.put("schema.8.virtual", "true");
        expected.put("schema.watermark.0.rowtime", "f1.q2");
        expected.put("schema.watermark.0.strategy.expr", "`f1`.`q2` - INTERVAL '5' SECOND");
        expected.put("schema.watermark.0.strategy.data-type", "TIMESTAMP(3)");
        expected.put("schema.primary-key.name", "constraint1");
        expected.put("schema.primary-key.columns", "f0,f2");
        Assertions.assertThat((Map)actual).isEqualTo(expected);
        TableSchema restored = properties.getTableSchema("schema");
        Assertions.assertThat((Object)restored).isEqualTo((Object)schema);
    }

    @Test
    void testLegacyTableSchema() {
        DescriptorProperties properties = new DescriptorProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("schema.0.name", "f0");
        map.put("schema.0.type", "VARCHAR");
        map.put("schema.1.name", "f1");
        map.put("schema.1.type", "BIGINT");
        map.put("schema.2.name", "f2");
        map.put("schema.2.type", "DECIMAL");
        map.put("schema.3.name", "f3");
        map.put("schema.3.type", "TIMESTAMP");
        map.put("schema.4.name", "f4");
        map.put("schema.4.type", "MAP<TINYINT, SMALLINT>");
        map.put("schema.5.name", "f5");
        map.put("schema.5.type", "ANY<java.lang.Class>");
        map.put("schema.6.name", "f6");
        map.put("schema.6.type", "PRIMITIVE_ARRAY<DOUBLE>");
        map.put("schema.7.name", "f7");
        map.put("schema.7.type", "OBJECT_ARRAY<TIME>");
        map.put("schema.8.name", "f8");
        map.put("schema.8.type", "ROW<q1 VARCHAR, q2 DATE>");
        map.put("schema.9.name", "f9");
        map.put("schema.9.type", "POJO<org.apache.flink.table.types.LogicalTypeParserTest$MyPojo>");
        properties.putProperties(map);
        TableSchema restored = properties.getTableSchema("schema");
        TableSchema expected = TableSchema.builder().field("f0", Types.STRING).field("f1", Types.LONG).field("f2", Types.BIG_DEC).field("f3", Types.SQL_TIMESTAMP).field("f4", Types.MAP((TypeInformation)Types.BYTE, (TypeInformation)Types.SHORT)).field("f5", Types.GENERIC(Class.class)).field("f6", Types.PRIMITIVE_ARRAY((TypeInformation)Types.DOUBLE)).field("f7", Types.OBJECT_ARRAY((TypeInformation)Types.SQL_TIME)).field("f8", Types.ROW_NAMED((String[])new String[]{"q1", "q2"}, (TypeInformation[])new TypeInformation[]{Types.STRING, Types.SQL_DATE})).field("f9", Types.POJO(LogicalTypeParserTest.MyPojo.class)).build();
        Assertions.assertThat((Object)restored).isEqualTo((Object)expected);
    }

    private void testArrayValidation(DescriptorProperties properties, int minLength, int maxLength) {
        Consumer<String> validator = key -> properties.validateInt(key, false);
        properties.validateArray(ARRAY_KEY, validator, minLength, maxLength);
    }

    private void testFixedIndexedPropertiesValidation(DescriptorProperties properties) {
        HashMap<String, Consumer<String>> validatorMap = new HashMap<String, Consumer<String>>();
        Consumer<String> validator1 = key -> properties.validateInt(key, false);
        validatorMap.put(PROPERTY_1_KEY, validator1);
        Consumer<String> validator2 = key -> properties.validateString(key, false);
        validatorMap.put(PROPERTY_2_KEY, validator2);
        properties.validateFixedIndexedProperties(FIXED_INDEXED_PROPERTY_KEY, false, validatorMap);
    }
}

