/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.DefaultIndex;
import org.apache.flink.table.catalog.Index;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;

public class TestSchemaResolver
implements SchemaResolver {
    private final DataTypeFactory dataTypeFactory = new DataTypeFactoryMock();
    private final Map<String, ResolvedExpression> resolveExpressionTable = new HashMap<String, ResolvedExpression>();

    public ResolvedSchema resolve(Schema schema) {
        List<Column> columns = this.resolveColumns(schema.getColumns());
        List watermarkSpecs = schema.getWatermarkSpecs().stream().map(this::resolveWatermarkSpecs).collect(Collectors.toList());
        UniqueConstraint primaryKey = this.resolvePrimaryKey(schema.getPrimaryKey().orElse(null));
        List<Index> indexes = this.resolveIndexes(schema.getIndexes());
        return new ResolvedSchema(columns, watermarkSpecs, primaryKey, indexes);
    }

    private List<Index> resolveIndexes(List<Schema.UnresolvedIndex> unresolvedIndexes) {
        return unresolvedIndexes.stream().map(unresolvedIndex -> DefaultIndex.newIndex((String)unresolvedIndex.getIndexName(), (List)unresolvedIndex.getColumnNames())).collect(Collectors.toList());
    }

    private List<Column> resolveColumns(List<Schema.UnresolvedColumn> unresolvedColumns) {
        Column[] resolvedColumns = new Column[unresolvedColumns.size()];
        int i = 0;
        for (Schema.UnresolvedColumn unresolvedColumn : unresolvedColumns) {
            if (unresolvedColumn instanceof Schema.UnresolvedPhysicalColumn) {
                resolvedColumns[i] = this.resolvePhysicalColumn((Schema.UnresolvedPhysicalColumn)unresolvedColumn);
            } else if (unresolvedColumn instanceof Schema.UnresolvedMetadataColumn) {
                resolvedColumns[i] = this.resolveMetadataColumn((Schema.UnresolvedMetadataColumn)unresolvedColumn);
            } else if (unresolvedColumn instanceof Schema.UnresolvedComputedColumn) {
                resolvedColumns[i] = Column.computed((String)unresolvedColumn.getName(), (ResolvedExpression)this.resolveExpression(((Schema.UnresolvedComputedColumn)unresolvedColumn).getExpression())).withComment((String)unresolvedColumn.getComment().orElse(null));
            }
            ++i;
        }
        return Arrays.asList(resolvedColumns);
    }

    private Column.PhysicalColumn resolvePhysicalColumn(Schema.UnresolvedPhysicalColumn unresolvedColumn) {
        return Column.physical((String)unresolvedColumn.getName(), (DataType)this.dataTypeFactory.createDataType(unresolvedColumn.getDataType())).withComment((String)unresolvedColumn.getComment().orElse(null));
    }

    private Column.MetadataColumn resolveMetadataColumn(Schema.UnresolvedMetadataColumn unresolvedColumn) {
        return Column.metadata((String)unresolvedColumn.getName(), (DataType)this.dataTypeFactory.createDataType(unresolvedColumn.getDataType()), (String)unresolvedColumn.getMetadataKey(), (boolean)unresolvedColumn.isVirtual()).withComment((String)unresolvedColumn.getComment().orElse(null));
    }

    private WatermarkSpec resolveWatermarkSpecs(Schema.UnresolvedWatermarkSpec unresolvedWatermarkSpec) {
        return WatermarkSpec.of((String)unresolvedWatermarkSpec.getColumnName(), (ResolvedExpression)this.resolveExpression(unresolvedWatermarkSpec.getWatermarkExpression()));
    }

    @Nullable
    private UniqueConstraint resolvePrimaryKey(@Nullable Schema.UnresolvedPrimaryKey unresolvedPrimaryKey) {
        if (unresolvedPrimaryKey == null) {
            return null;
        }
        return UniqueConstraint.primaryKey((String)unresolvedPrimaryKey.getConstraintName(), (List)unresolvedPrimaryKey.getColumnNames());
    }

    private ResolvedExpression resolveExpression(Expression expression) {
        String callString;
        if (expression instanceof SqlCallExpression && this.resolveExpressionTable.containsKey(callString = ((SqlCallExpression)expression).getSqlExpression())) {
            return this.resolveExpressionTable.get(callString);
        }
        throw new IllegalArgumentException("Unsupported expression: " + expression);
    }

    public TestSchemaResolver addExpression(String callExpression, ResolvedExpression resolvedExpression) {
        ResolvedExpression oldValue = this.resolveExpressionTable.put(callExpression, resolvedExpression);
        if (oldValue != null) {
            throw new IllegalArgumentException("Conflict key for expression: " + callExpression);
        }
        return this;
    }
}

