/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogPropertiesUtil;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CatalogPropertiesUtilTest {
    @Test
    public void testCatalogModelSerde() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("endpoint", "someendpoint");
        options.put("api_key", "fake_key");
        CatalogModel catalogModel = CatalogModel.of((Schema)Schema.newBuilder().column("f1", DataTypes.INT().getLogicalType().asSerializableString()).column("f2", DataTypes.STRING().getLogicalType().asSerializableString()).build(), (Schema)Schema.newBuilder().column("label", DataTypes.STRING().getLogicalType().asSerializableString()).build(), options, (String)"some comment");
        Column.PhysicalColumn f1 = Column.physical((String)"f1", (DataType)DataTypes.INT());
        Column.PhysicalColumn f2 = Column.physical((String)"f2", (DataType)DataTypes.STRING());
        Column.PhysicalColumn label = Column.physical((String)"label", (DataType)DataTypes.STRING());
        ResolvedSchema inputSchema = ResolvedSchema.of((Column[])new Column[]{f1, f2});
        ResolvedSchema outputSchema = ResolvedSchema.of((Column[])new Column[]{label});
        ResolvedCatalogModel testModel = ResolvedCatalogModel.of((CatalogModel)catalogModel, (ResolvedSchema)inputSchema, (ResolvedSchema)outputSchema);
        Map serializedMap = CatalogPropertiesUtil.serializeResolvedCatalogModel((ResolvedCatalogModel)testModel);
        CatalogModel deserializedModel = CatalogPropertiesUtil.deserializeCatalogModel((Map)serializedMap);
        Assertions.assertThat((String)deserializedModel.getInputSchema().toString()).isEqualTo(catalogModel.getInputSchema().toString());
        Assertions.assertThat((String)deserializedModel.getOutputSchema().toString()).isEqualTo(catalogModel.getOutputSchema().toString());
        Assertions.assertThat((Map)deserializedModel.getOptions()).isEqualTo((Object)catalogModel.getOptions());
        Assertions.assertThat((String)deserializedModel.getComment()).isEqualTo(catalogModel.getComment());
    }

    @Test
    public void testCatalogTableSerde() {
        HashMap options = new HashMap();
        CatalogTable catalogTable = CatalogTable.newBuilder().schema(Schema.newBuilder().column("f1", DataTypes.INT().getLogicalType().asSerializableString()).column("f2", DataTypes.STRING().getLogicalType().asSerializableString()).primaryKey(new String[]{"f1"}).build()).comment("some comment").options(options).build();
        Column.PhysicalColumn f1 = Column.physical((String)"f1", (DataType)DataTypes.INT());
        Column.PhysicalColumn f2 = Column.physical((String)"f2", (DataType)DataTypes.STRING());
        List<Column> columns = Arrays.asList(f1, f2);
        UniqueConstraint primaryKey = UniqueConstraint.primaryKey((String)"PK_f1", Collections.singletonList("f1"));
        ResolvedSchema schema = new ResolvedSchema(columns, Collections.emptyList(), primaryKey);
        ResolvedCatalogTable testTable = new ResolvedCatalogTable(catalogTable, schema);
        Map serializedMap = CatalogPropertiesUtil.serializeCatalogTable((ResolvedCatalogTable)testTable);
        CatalogTable deserializedTable = CatalogPropertiesUtil.deserializeCatalogTable((Map)serializedMap);
        Assertions.assertThat((String)deserializedTable.getUnresolvedSchema().toString()).isEqualTo(catalogTable.getUnresolvedSchema().toString());
    }
}

