/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;

class ItemAtIndexArgumentTypeStrategyTest
extends InputTypeStrategiesTestBase {
    private static final InputTypeStrategy ITEM_AT_INPUT_STRATEGY = BuiltInFunctionDefinitions.AT.getTypeInference((DataTypeFactory)new DataTypeFactoryMock()).getInputTypeStrategy();

    ItemAtIndexArgumentTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("Validate integer index for an array", ITEM_AT_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.SMALLINT().notNull()}).expectSignature("f([<ARRAY> | <MAP>], [<INTEGER NUMERIC> | <MAP_KEY_TYPE>])").expectArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.SMALLINT().notNull()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Validate not an integer index for an array", ITEM_AT_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.STRING()}).expectErrorMessage("Array can be indexed only using an INTEGER NUMERIC type."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Validate correct map key", ITEM_AT_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.SMALLINT()}).expectSignature("f([<ARRAY> | <MAP>], [<INTEGER NUMERIC> | <MAP_KEY_TYPE>])").expectArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Validate incorrect map key", ITEM_AT_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.STRING()}).expectErrorMessage("Expected index for a MAP to be of type: BIGINT"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Validate incorrect index", ITEM_AT_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.BIGINT()), DataTypes.INT().notNull()}).calledWithLiteralAt(1, 0).expectErrorMessage("The provided index must be a valid SQL index starting from 1, but was '0'"));
    }
}

