/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterators;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.util.FlinkRuntimeException;

public class TestManagedIterableSourceSplit
implements IteratorSourceSplit<RowData, Iterator<RowData>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Path filePath;
    private Iterator<RowData> iterator;

    public TestManagedIterableSourceSplit(String id, Path filePath) {
        this.id = id;
        this.filePath = filePath;
    }

    public String splitId() {
        return this.id;
    }

    public Iterator<RowData> getIterator() {
        if (this.iterator == null) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.filePath.getPath()));
                this.iterator = Iterators.transform(reader.lines().iterator(), line -> GenericRowData.of((Object[])new Object[]{StringData.fromString((String)this.id), StringData.fromString((String)this.filePath.getPath()), StringData.fromString((String)line)}));
            }
            catch (IOException e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
        return this.iterator;
    }

    public IteratorSourceSplit<RowData, Iterator<RowData>> getUpdatedSplitForIterator(Iterator<RowData> iterator) {
        TestManagedIterableSourceSplit recovered = new TestManagedIterableSourceSplit(this.id, this.filePath);
        recovered.iterator = this.iterator;
        return recovered;
    }

    public String toString() {
        return "TestManagedIterableSourceSplit{splitId='" + this.id + "', filePath=" + this.filePath + "}";
    }

    public Path getFilePath() {
        return this.filePath;
    }
}

