/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.connector.source.CompactPartition;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@JsonSerialize(using=CompactPartitionsSerializer.class)
@JsonDeserialize(using=CompactPartitionsDeserializer.class)
public class CompactPartitions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_NAME_COMPACT_PARTITIONS = "compact-partitions";
    private static final ObjectMapper MAPPER = JacksonMapperFactory.createObjectMapper();
    private final List<CompactPartition> compactPartitions;

    private CompactPartitions(List<CompactPartition> compactPartitions) {
        this.compactPartitions = compactPartitions;
    }

    public static CompactPartitions from(List<CompactPartition> compactPartitions) {
        return new CompactPartitions(compactPartitions);
    }

    public static Optional<CompactPartitions> deserializeCompactPartitions(String json) {
        try {
            return Optional.of((CompactPartitions)MAPPER.readValue(json, CompactPartitions.class));
        }
        catch (JsonProcessingException jsonProcessingException) {
            return Optional.empty();
        }
    }

    public static Optional<String> serializeCompactPartitions(CompactPartitions partitions) {
        try {
            return Optional.of(MAPPER.writeValueAsString((Object)partitions));
        }
        catch (JsonProcessingException jsonProcessingException) {
            return Optional.empty();
        }
    }

    public List<CompactPartition> getCompactPartitions() {
        return this.compactPartitions;
    }

    public String toString() {
        return "CompactPartitions{compactPartitions=" + this.compactPartitions + "}";
    }

    public static class CompactPartitionsDeserializer
    extends StdDeserializer<CompactPartitions> {
        private static final long serialVersionUID = 6089784742093294800L;
        private final CompactPartition.CompactPartitionDeserializer deserializer = new CompactPartition.CompactPartitionDeserializer();

        public CompactPartitionsDeserializer() {
            super(CompactPartitions.class);
        }

        public CompactPartitions deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<CompactPartition> partitions = new ArrayList<CompactPartition>();
            JsonNode rootNode = (JsonNode)jsonParser.readValueAsTree();
            JsonNode partitionNodes = rootNode.get(CompactPartitions.FIELD_NAME_COMPACT_PARTITIONS);
            for (JsonNode partitionEntry : partitionNodes) {
                this.deserializer.setRoot(partitionEntry);
                partitions.add(this.deserializer.deserialize(jsonParser, deserializationContext));
            }
            return CompactPartitions.from(partitions);
        }
    }

    public static class CompactPartitionsSerializer
    extends StdSerializer<CompactPartitions> {
        private static final long serialVersionUID = 1L;
        private final CompactPartition.CompactPartitionSerializer serializer = new CompactPartition.CompactPartitionSerializer();

        public CompactPartitionsSerializer() {
            super(CompactPartitions.class);
        }

        public void serialize(CompactPartitions compactPartitions, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(CompactPartitions.FIELD_NAME_COMPACT_PARTITIONS);
            jsonGenerator.writeStartArray();
            for (CompactPartition partition : compactPartitions.compactPartitions) {
                this.serializer.serialize(partition, jsonGenerator, serializerProvider);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
    }
}

